/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import org.chromattic.ext.ntdef.NTFile;
import org.chromattic.ext.ntdef.Resource;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.social.core.chromattic.entity.DisabledEntity;
import org.exoplatform.social.core.chromattic.entity.IdentityEntity;
import org.exoplatform.social.core.chromattic.entity.ProfileEntity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.updater.AbstractMigrationService;
import org.exoplatform.social.core.jpa.updater.MigrationContext;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.storage.exception.NodeNotFoundException;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;

@Managed
@ManagedDescription(value="Social migration Identities from JCR to RDBMS.")
@NameTemplate(value={@Property(key="service", value="social"), @Property(key="view", value="migration-identities")})
public class IdentityMigrationService
extends AbstractMigrationService<Identity> {
    public static final String EVENT_LISTENER_KEY = "SOC_IDENTITY_MIGRATION";
    protected static final String REMOVE_LIMIT_THRESHOLD_KEY = "REMOVE_LIMIT_THRESHOLD";
    private int REMOVE_LIMIT_THRESHOLD = 20;
    private long totalNumberIdentites = 0L;
    private final RDBMSIdentityStorageImpl identityStorage;
    private final IdentityStorageImpl jcrIdentityStorage;
    private String identityQuery;
    private long numberIdentities = 0L;
    private Set<String> identitiesMigrateFailed = new HashSet<String>();
    private Set<String> identitiesCleanupFailed = new HashSet<String>();

    public IdentityMigrationService(InitParams initParams, RDBMSIdentityStorageImpl identityStorage, IdentityStorageImpl jcrIdentityStorage, EventManager<Identity, String> eventManager, EntityManagerService entityManagerService) {
        super(initParams, identityStorage, eventManager, entityManagerService);
        this.LIMIT_THRESHOLD = this.getInteger(initParams, "LIMIT_THRESHOLD", 200);
        this.REMOVE_LIMIT_THRESHOLD = this.getInteger(initParams, REMOVE_LIMIT_THRESHOLD_KEY, 20);
        this.identityStorage = identityStorage;
        this.jcrIdentityStorage = jcrIdentityStorage;
    }

    @Override
    protected void beforeMigration() throws Exception {
        MigrationContext.setIdentityDone(false);
        this.identitiesMigrateFailed = new HashSet<String>();
        this.numberIdentities = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    @ManagedDescription(value="Manual to start run migration data of identities from JCR to RDBMS.")
    public void doMigration() throws Exception {
        long t = System.currentTimeMillis();
        long totalIdentities = this.getTotalNumberIdentities();
        this.LOG.info((Object)"|\\ START::Identity migration ---------------------------------");
        RequestLifeCycle.end();
        long offset = 0L;
        boolean cont = true;
        boolean begunTx = false;
        ArrayList<String> transactionList = new ArrayList<String>();
        long numberSuccessful = 0L;
        long batchSize = 0L;
        while (cont && !this.forceStop) {
            try {
                try {
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    begunTx = this.startTx();
                    transactionList = new ArrayList();
                    NodeIterator nodeIter = this.getIdentityNodes(offset, this.LIMIT_THRESHOLD);
                    batchSize = nodeIter.getSize();
                    if (nodeIter == null || batchSize == 0L) {
                        cont = false;
                        continue;
                    }
                    while (nodeIter.hasNext() && !this.forceStop) {
                        Node identityNode = nodeIter.nextNode();
                        String identityName = identityNode.getName();
                        transactionList.add(identityName);
                        this.LOG.info((Object)String.format("|  \\ START::identity number: %s/%s (%s identity)", ++offset, totalIdentities, identityName));
                        long t1 = System.currentTimeMillis();
                        String jcrid = identityNode.getUUID();
                        try {
                            Identity identity = this.migrateIdentity(identityNode, jcrid);
                            if (identity != null) {
                                String newId = identity.getId();
                                identity.setId(jcrid);
                                this.broadcastListener(identity, newId);
                            }
                            ++numberSuccessful;
                        }
                        catch (Exception ex) {
                            this.identitiesMigrateFailed.add(identityName);
                            this.LOG.error((Object)("Error while migrate identity " + identityName), (Throwable)ex);
                        }
                        this.LOG.info((Object)String.format("|  / END::identity number %s (%s identity) consumed %s(ms)", offset, identityNode.getName(), System.currentTimeMillis() - t1));
                    }
                }
                finally {
                    try {
                        this.endTx(begunTx);
                    }
                    catch (Exception ex) {
                        this.identitiesMigrateFailed.addAll(transactionList);
                        numberSuccessful -= batchSize;
                    }
                    RequestLifeCycle.end();
                }
            }
            catch (Throwable ex) {
                this.LOG.error((Object)ex);
            }
        }
        this.numberIdentities = offset;
        if (this.identitiesMigrateFailed.size() > 0) {
            this.LOG.info((Object)String.format("| / END::Identity migration failed for (%s) identity(s)", this.identitiesMigrateFailed.size()));
        }
        this.LOG.info((Object)String.format("|// END::Identity migration for (%s) identity(s) consumed %s(ms)", numberSuccessful, System.currentTimeMillis() - t));
        this.LOG.info((Object)"| \\ START::Re-indexing identity(s) ---------------------------------");
        IndexingService indexingService = (IndexingService)CommonsUtils.getService(IndexingService.class);
        indexingService.reindexAll("profile");
        this.LOG.info((Object)"| / END::Re-indexing identity(s) ---------------------------------");
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
    }

    @Override
    protected void afterMigration() throws Exception {
        MigrationContext.setIdentitiesMigrateFailed(this.identitiesMigrateFailed);
        if (!this.forceStop && this.identitiesMigrateFailed.isEmpty()) {
            MigrationContext.setIdentityDone(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemove() throws Exception {
        this.identitiesCleanupFailed = new HashSet<String>();
        long totalIdentities = this.getTotalNumberIdentities();
        this.LOG.info((Object)"| \\ START::cleanup Identities ---------------------------------");
        long t = System.currentTimeMillis();
        long timePerIdentity = System.currentTimeMillis();
        int offset = 0;
        long failed = 0L;
        ArrayList transactionList = new ArrayList();
        try {
            boolean cont = true;
            while (cont) {
                try {
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    failed = this.identitiesCleanupFailed.size();
                    transactionList = new ArrayList();
                    NodeIterator nodeIter = this.getIdentityNodes(failed, this.REMOVE_LIMIT_THRESHOLD);
                    if (nodeIter == null || nodeIter.getSize() == 0L) {
                        cont = false;
                        continue;
                    }
                    if (nodeIter.getSize() < (long)this.REMOVE_LIMIT_THRESHOLD) {
                        cont = false;
                    }
                    while (nodeIter.hasNext()) {
                        if ((long)(++offset) > totalIdentities) {
                            cont = false;
                        }
                        Node node = nodeIter.nextNode();
                        timePerIdentity = System.currentTimeMillis();
                        this.LOG.info((Object)String.format("|  \\ START::cleanup Identity number: %s/%s (%s identity)", offset, totalIdentities, node.getName()));
                        String name = node.getName();
                        if (!MigrationContext.isForceCleanup() && (MigrationContext.getIdentitiesCleanupConnectionFailed().contains(name) || MigrationContext.getIdentitiesCleanupActivityFailed().contains(name))) {
                            this.identitiesCleanupFailed.add(name);
                            this.LOG.warn((Object)"Will not remove this identity because the cleanup connection or activities were failed for it");
                            continue;
                        }
                        IdentityEntity identityEntity = (IdentityEntity)this._findById(IdentityEntity.class, node.getUUID());
                        String provider = identityEntity.getProviderId();
                        String activityMigrated = identityEntity.getProperty("activity_migrated");
                        String connectionMigrated = identityEntity.getProperty("connection_migrated");
                        if (!"true".equalsIgnoreCase(activityMigrated) || "organization".equals(provider) && !"true".equalsIgnoreCase(connectionMigrated)) {
                            this.LOG.warn((Object)("Can not remove identity " + name + " due to migration was not successful for activities and connections"));
                            this.identitiesCleanupFailed.add(name);
                            continue;
                        }
                        try {
                            PropertyIterator pit = node.getReferences();
                            if (pit != null && pit.getSize() > 0L) {
                                int num = 0;
                                while (pit.hasNext()) {
                                    pit.nextProperty().remove();
                                    if (++num % this.REMOVE_LIMIT_THRESHOLD != 0) continue;
                                    this.getSession().save();
                                }
                                this.getSession().save();
                            }
                            node.remove();
                            this.getSession().save();
                        }
                        catch (Exception ex) {
                            this.LOG.error((Object)("Error when cleanup the identity: " + name), (Throwable)ex);
                            this.identitiesCleanupFailed.add(name);
                            this.getSession().getJCRSession().refresh(false);
                        }
                        this.LOG.info((Object)String.format("|  / END::cleanup (%s identity) consumed time %s(ms)", node.getName(), System.currentTimeMillis() - timePerIdentity));
                    }
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
        }
        catch (Throwable throwable) {
            MigrationContext.setIdentitiesCleanupFailed(this.identitiesCleanupFailed);
            if (this.identitiesCleanupFailed.size() > 0) {
                this.LOG.warn((Object)("Cleanup failed for " + this.identitiesCleanupFailed.size() + " identities"));
            }
            this.LOG.info((Object)String.format("| / END::cleanup Identities migration for (%s) identity consumed %s(ms)", offset, System.currentTimeMillis() - t));
            throw throwable;
        }
        MigrationContext.setIdentitiesCleanupFailed(this.identitiesCleanupFailed);
        if (this.identitiesCleanupFailed.size() > 0) {
            this.LOG.warn((Object)("Cleanup failed for " + this.identitiesCleanupFailed.size() + " identities"));
        }
        this.LOG.info((Object)String.format("| / END::cleanup Identities migration for (%s) identity consumed %s(ms)", offset, System.currentTimeMillis() - t));
    }

    private Identity migrateIdentity(Node node, String jcrId) throws Exception {
        String remoteId;
        String providerId = node.getProperty("soc:providerId").getString();
        Identity identity = this.identityStorage.findIdentity(providerId, remoteId = node.getProperty("soc:remoteId").getString());
        if (identity != null) {
            this.LOG.info((Object)("Identity with providerId = " + identity.getProviderId() + " and remoteId=" + identity.getRemoteId() + " has already been migrated."));
            return identity;
        }
        identity = new Identity(providerId, remoteId);
        identity.setDeleted(node.getProperty("soc:isDeleted").getBoolean());
        if (node.isNodeType("soc:isDisabled")) {
            identity.setEnable(false);
        }
        this.identityStorage.saveIdentity(identity);
        String id = identity.getId();
        identity.setId(jcrId);
        Profile profile = new Profile(identity);
        this.jcrIdentityStorage.loadProfile(profile);
        String oldProfileId = profile.getId();
        profile.setId("0");
        identity.setId(id);
        ProfileEntity entity = (ProfileEntity)this._findById(ProfileEntity.class, oldProfileId);
        NTFile avatar = entity.getAvatar();
        if (avatar != null) {
            Resource resource = avatar.getContentResource();
            AvatarAttachment attachment = new AvatarAttachment();
            attachment.setMimeType(resource.getMimeType());
            attachment.setInputStream((InputStream)new ByteArrayInputStream(resource.getData()));
            profile.setProperty("avatar", (Object)attachment);
        }
        this.identityStorage.saveProfile(profile);
        identity.setProfile(profile);
        return identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity migrateIdentity(String oldId) {
        boolean begun = false;
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            begun = this.startTx();
            IdentityEntity jcrEntity = (IdentityEntity)this._findById(IdentityEntity.class, oldId);
            String providerId = jcrEntity.getProviderId();
            String remoteId = jcrEntity.getRemoteId();
            Identity identity = this.identityStorage.findIdentity(providerId, remoteId);
            if (identity == null) {
                identity = new Identity(providerId, remoteId);
                identity.setDeleted(jcrEntity.isDeleted().booleanValue());
                identity.setEnable(this._getMixin(jcrEntity, DisabledEntity.class, false) == null);
                this.identityStorage.saveIdentity(identity);
                String id = identity.getId();
                identity.setId(oldId);
                Profile profile = new Profile(identity);
                this.jcrIdentityStorage.loadProfile(profile);
                String oldProfileId = profile.getId();
                profile.setId("0");
                identity.setId(id);
                ProfileEntity entity = (ProfileEntity)this._findById(ProfileEntity.class, oldProfileId);
                NTFile avatar = entity.getAvatar();
                if (avatar != null) {
                    Resource resource = avatar.getContentResource();
                    AvatarAttachment attachment = new AvatarAttachment();
                    attachment.setMimeType(resource.getMimeType());
                    attachment.setInputStream((InputStream)new ByteArrayInputStream(resource.getData()));
                    profile.setProperty("avatar", (Object)attachment);
                }
                this.identityStorage.saveProfile(profile);
                identity.setProfile(profile);
            }
            if (identity != null) {
                String newId = identity.getId();
                identity.setId(oldId);
                this.broadcastListener(identity, newId);
            }
            Identity identity2 = identity;
            return identity2;
        }
        catch (NodeNotFoundException ex) {
            this.LOG.error((Object)("Can not find indentity with oldId: " + oldId), (Throwable)ex);
            Identity identity = null;
            return identity;
        }
        catch (Exception ex) {
            this.LOG.error((Object)("Exception while migrate identity with oldId: " + oldId), (Throwable)ex);
            Identity identity = null;
            return identity;
        }
        finally {
            try {
                this.endTx(begun);
            }
            catch (Exception ex) {
                this.LOG.error((Object)"Error while commit transaction", (Throwable)ex);
            }
            RequestLifeCycle.end();
        }
    }

    private NodeIterator getIdentityNodes(long offset, int limit) {
        if (this.identityQuery == null) {
            this.identityQuery = "SELECT * FROM soc:identitydefinition";
        }
        return this.nodes(this.identityQuery, offset, limit);
    }

    private long getTotalNumberIdentities() {
        if (this.totalNumberIdentites == 0L) {
            if (this.identityQuery == null) {
                this.identityQuery = "SELECT * FROM soc:identitydefinition";
            }
            this.totalNumberIdentites = this.nodes(this.identityQuery).getSize();
        }
        return this.totalNumberIdentites;
    }

    @Override
    @Managed
    @ManagedDescription(value="Manual to stop run migration data of identities from JCR to RDBMS.")
    public void stop() {
        super.stop();
    }

    @Override
    protected String getListenerKey() {
        return EVENT_LISTENER_KEY;
    }
}

