/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ActivityTypeUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.plugin.doc.UIDocActivity;
import org.exoplatform.social.plugin.doc.UIDocActivitySelector;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIActivityComposerManager;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.cssfile.CssClassManager;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="classpath:groovy/social/plugin/doc/UIDocActivityComposer.gtmpl", events={@EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class}), @EventConfig(listeners={SelectDocumentActionListener.class}), @EventConfig(listeners={RemoveDocumentActionListener.class})})
public class UIDocActivityComposer
extends UIActivityComposer
implements UISelectable {
    public static final String REPOSITORY = "repository";
    public static final String WORKSPACE = "collaboration";
    private static final String FILE_SPACES = "files:spaces";
    private static final String POPUP_COMPOSER = "UIPopupComposer";
    private final String docActivityTitle = "<a href=\"${DOCLINK}\">${DOCNAME}</a>";
    private String documentRefLink;
    private String documentPath;
    private String documentName;
    private boolean isDocumentReady;
    private String currentUser;
    private String docIcon = "";
    private String docInfo = "";

    public UIDocActivityComposer() {
        this.addChild((UIComponent)new UIFormStringInput("InputDoc", "InputDoc", null));
        this.resetValues();
    }

    private void resetValues() {
        this.documentRefLink = "";
        this.isDocumentReady = false;
        this.setReadyForPostingActivity(false);
    }

    public boolean isDocumentReady() {
        return this.isDocumentReady;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getDocumentIcon() {
        return this.docIcon;
    }

    public String getDocInfo() {
        return this.docInfo;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    protected void onActivate(Event<UIActivityComposer> event) {
        this.setCurrentUser(event.getRequestContext().getRemoteUser());
    }

    protected void onClose(Event<UIActivityComposer> event) {
        this.resetValues();
    }

    protected void onSubmit(Event<UIActivityComposer> event) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
    }

    public ExoSocialActivity onPostActivity(UIComposer.PostContext postContext, String postedMessage) throws Exception {
        ExoSocialActivity activity = null;
        if (!this.isDocumentReady) {
            ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).addMessage(new ApplicationMessage("UIComposer.msg.error.Must_select_file", null, 2));
        } else {
            LinkedHashMap<String, String> activityParams = new LinkedHashMap<String, String>();
            Node node = this.getDocNode(REPOSITORY, WORKSPACE, this.documentPath);
            activityParams.put("docTitle", org.exoplatform.ecm.webui.utils.Utils.getTitle((Node)node));
            boolean isSymlink = node.isNodeType("exo:symlink");
            if (isSymlink) {
                node = org.exoplatform.ecm.webui.utils.Utils.getNodeSymLink((Node)node);
            }
            activityParams.put("isSymlink", String.valueOf(isSymlink));
            activityParams.put("DOCNAME", this.documentName);
            activityParams.put("DOCLINK", this.documentRefLink);
            activityParams.put("DOCPATH", this.documentPath);
            activityParams.put("REPOSITORY", REPOSITORY);
            activityParams.put("WORKSPACE", WORKSPACE);
            activityParams.put("MESSAGE", postedMessage);
            activityParams.put("registeredKeysForProcessor", "MESSAGE");
            if (node.getPrimaryNodeType().getName().equals("nt:file") || node.isNodeType("exo:accessibleMedia")) {
                Node contentNode;
                String activityOwnerId = UIDocActivity.getActivityOwnerId(node);
                SimpleDateFormat dateFormatter = null;
                dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String illustrationImg = UIDocActivity.getIllustrativeImage(node);
                String strDateCreated = "";
                if (node.hasProperty("exo:dateCreated")) {
                    Calendar dateCreated = node.getProperty("exo:dateCreated").getDate();
                    strDateCreated = dateFormatter.format(dateCreated.getTime());
                }
                String strLastModified = "";
                if (node.hasNode("jcr:content") && (contentNode = node.getNode("jcr:content")).hasProperty("jcr:lastModified")) {
                    Calendar lastModified = contentNode.getProperty("jcr:lastModified").getDate();
                    strLastModified = dateFormatter.format(lastModified.getTime());
                }
                activityParams.put("id", node.isNodeType("mix:referenceable") ? node.getUUID() : "");
                activityParams.put("contentName", node.getName());
                activityParams.put("author", activityOwnerId);
                activityParams.put("dateCreated", strDateCreated);
                activityParams.put("lastModified", strLastModified);
                activityParams.put("contenLink", UIDocActivity.getContentLink(node));
                activityParams.put("mimeType", UIDocActivity.getMimeType(node));
                activityParams.put("imagePath", illustrationImg);
            }
            if (postContext == UIComposer.PostContext.SPACE) {
                activity = this.postActivityToSpace(activityParams);
            } else if (postContext == UIComposer.PostContext.USER) {
                activity = this.postActivityToUser(activityParams);
            }
        }
        this.resetValues();
        return activity;
    }

    private ExoSocialActivity postActivityToUser(Map<String, String> activityParams) throws Exception {
        String ownerName = ((UIUserActivitiesDisplay)this.getActivityDisplay()).getOwnerName();
        IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName, true);
        return this.saveActivity(activityParams, identityManager, ownerIdentity);
    }

    private ExoSocialActivity postActivityToSpace(Map<String, String> activityParams) throws Exception {
        Space space = ((SpaceService)this.getApplicationComponent(SpaceService.class)).getSpaceByUrl(SpaceUtils.getSpaceUrlByContext());
        IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
        Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        return this.saveActivity(activityParams, identityManager, spaceIdentity);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String rawPath = value.toString();
        rawPath = rawPath.substring(rawPath.indexOf(":/") + 2);
        this.documentRefLink = this.buildDocumentLink(rawPath);
        this.documentName = rawPath.substring(rawPath.lastIndexOf("/") + 1);
        this.documentPath = this.buildDocumentPath(rawPath);
        this.isDocumentReady = true;
        this.documentRefLink = this.documentRefLink.replace("//", "/");
        this.documentPath = this.documentPath.replace("//", "/");
        this.docIcon = CssClassUtils.getCSSClassByFileNameAndFileType((String)this.documentName, (String)selectField, (CssClassManager.ICON_SIZE)CssClassManager.ICON_SIZE.ICON_64);
        Node docNode = this.getDocNode(REPOSITORY, WORKSPACE, this.documentPath);
        this.documentName = this.getDocumentName(docNode, this.documentName);
        Calendar date = Utils.getDate((Node)docNode);
        this.docInfo = this.getFullName(docNode) + Utils.fileSize((Node)docNode) + this.formatDate(date);
        this.setReadyForPostingActivity(true);
        UIActivityComposer activityComposer = this.getActivityComposerManager().getCurrentActivityComposer();
        activityComposer.setDisplayed(true);
    }

    private String getDocumentName(Node docNode, String pathName) {
        try {
            return docNode.getProperty("exo:title").getString();
        }
        catch (RepositoryException ex) {
            return pathName;
        }
    }

    private String getFullName(Node docNode) throws Exception {
        String ownerId = Utils.getOwner((Node)docNode);
        OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        UserHandler userHandler = organizationService.getUserHandler();
        return userHandler.findUserByName(ownerId).getDisplayName();
    }

    private String formatDate(Calendar date) {
        DateFormat format = SimpleDateFormat.getDateTimeInstance(0, 3);
        return " - " + format.format(date.getTime());
    }

    private ExoSocialActivity saveActivity(Map<String, String> activityParams, IdentityManager identityManager, Identity ownerIdentity) throws RepositoryException {
        Node node = this.getDocNode(activityParams.get("REPOSITORY"), activityParams.get("WORKSPACE"), activityParams.get("DOCPATH"));
        String activity_type = "DOC_ACTIVITY";
        if (node.getPrimaryNodeType().getName().equals("nt:file")) {
            activity_type = FILE_SPACES;
        }
        String remoteUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser, true);
        String title = activityParams.get("MESSAGE");
        if (title == null || title.length() == 0) {
            title = "<a href=\"${DOCLINK}\">${DOCNAME}</a>";
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl(userIdentity.getId(), activity_type, title, null);
        activity.setTemplateParams(activityParams);
        ActivityManager activityManager = (ActivityManager)this.getApplicationComponent(ActivityManager.class);
        activityManager.saveActivityNoReturn(ownerIdentity, (ExoSocialActivity)activity);
        String activityId = activity.getId();
        if (!StringUtils.isEmpty((String)activityId)) {
            ActivityTypeUtils.attachActivityId((Node)node, (String)activityId);
            node.save();
        }
        return activityManager.getActivity(activity.getId());
    }

    private String buildDocumentLink(String rawPath) {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        String restService = "jcr";
        return "/" + portalContainerName + "/" + restContextName + "/" + restService + "/" + REPOSITORY + "/" + WORKSPACE + "/" + rawPath;
    }

    public String buildDocumentPath(String rawPath) {
        return "/" + rawPath;
    }

    protected Node getDocNode(String repository, String workspace, String docPath) {
        NodeLocation nodeLocation = new NodeLocation(repository, workspace, docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    protected void clearComposerData() {
        this.resetValues();
    }

    public static class RemoveDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = docActivityComposer.getActivityComposerManager();
            UIActivityComposer activityComposer = activityComposerManager.getCurrentActivityComposer();
            docActivityComposer.resetValues();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)docActivityComposer);
        }
    }

    public static class SelectDocumentActionListener
    extends EventListener<UIDocActivityComposer> {
        public void execute(Event<UIDocActivityComposer> event) throws Exception {
            UIDocActivityComposer docActivityComposer = (UIDocActivityComposer)((Object)event.getSource());
            PopupContainer popupContainer = (PopupContainer)((UIPortletApplication)docActivityComposer.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(PopupContainer.class);
            popupContainer.activate(UIDocActivitySelector.class, 500, UIDocActivityComposer.POPUP_COMPOSER);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupContainer);
        }
    }
}

