/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptContainer;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptManager;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.form.validator.XSSValidator;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class})})
public class UIScriptForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIScriptForm.class.getName());
    public static final String FIELD_SELECT_VERSION = "selectVersion";
    public static final String FIELD_SCRIPT_CONTENT = "scriptContent";
    public static final String FIELD_SCRIPT_NAME = "scriptName";
    public static final String FIELD_SCRIPT_LABEL = "scriptLabel";
    public static final String FIELD_ENABLE_VERSION = "enableVersion";
    public static final String SCRIPT_FILE_TYPE = ".groovy";
    private List<String> listVersion = new ArrayList<String>();
    private boolean isAddNew_ = true;
    private ScriptService scriptService = (ScriptService)WCMCoreUtils.getService(ScriptService.class);

    public UIScriptForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_SELECT_VERSION, FIELD_SELECT_VERSION, options);
        UIFormTextAreaInput contents = new UIFormTextAreaInput(FIELD_SCRIPT_CONTENT, FIELD_SCRIPT_CONTENT, null);
        contents.addValidator(MandatoryValidator.class, new Object[0]);
        UICheckBoxInput isVersion = new UICheckBoxInput(FIELD_ENABLE_VERSION, FIELD_ENABLE_VERSION, null);
        UIFormStringInput scriptLabel = new UIFormStringInput(FIELD_SCRIPT_LABEL, FIELD_SCRIPT_LABEL, null);
        scriptLabel.addValidator(XSSValidator.class, new Object[0]);
        UIFormStringInput scriptName = new UIFormStringInput(FIELD_SCRIPT_NAME, FIELD_SCRIPT_NAME, null);
        scriptName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]).addValidator(XSSValidator.class, new Object[0]);
        versions.setOnChange("Change");
        versions.setRendered(false);
        isVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)contents);
        this.addUIFormInput((UIFormInput)isVersion);
        this.addUIFormInput((UIFormInput)scriptLabel);
        this.addUIFormInput((UIFormInput)scriptName);
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        return vH == null ? null : new VersionNode((Node)vH.getRootVersion(), node.getSession());
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (int i = 0; i < children.size(); ++i) {
            this.listVersion.add(children.get(i).getName());
            child = children.get(i).getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List<String> versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt(versionList.get(j)) >= Integer.parseInt(versionList.get(i))) continue;
                String temp = versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(versionList.get(i), (Object)versionList.get(i)));
        }
        return options;
    }

    public void update(Node script, boolean isAddNew) throws Exception {
        this.isAddNew_ = isAddNew;
        if (script != null) {
            String scriptContent = this.scriptService.getScriptAsText(script);
            this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setRendered(true);
            boolean isVersioned = script.isNodeType("mix:versionable");
            if (isVersioned) {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(true);
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setOptions(this.getVersionValues(script));
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setValue(script.getBaseVersion().getName());
                this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setDisabled(true);
                this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setChecked(true);
                this.setActions(new String[]{"Save", "Restore", "Refresh", "Cancel"});
            } else {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
                this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setDisabled(false);
                this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
                this.setActions(new String[]{"Save", "Refresh", "Cancel"});
            }
            this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue((Object)scriptContent);
            Node content = script.getNode("jcr:content");
            String scriptLabel = content.getProperty("dc:description").getValues()[0].getString();
            this.getUIStringInput(FIELD_SCRIPT_LABEL).setValue((Object)scriptLabel);
            this.getUIStringInput(FIELD_SCRIPT_NAME).setValue((Object)script.getName());
            this.getUIStringInput(FIELD_SCRIPT_NAME).setDisabled(true);
            return;
        }
        if (!this.isAddNew_) {
            this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
            return;
        }
        this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
        this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setRendered(false);
        this.getUICheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
        this.getUIStringInput(FIELD_SCRIPT_LABEL).setValue(null);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setDisabled(false);
        this.getUIStringInput(FIELD_SCRIPT_NAME).setValue(null);
        this.getUIFormTextAreaInput(FIELD_SCRIPT_CONTENT).setValue(null);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            uiForm.reset();
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("ScriptContainerPopup");
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class RefreshActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            String scriptName = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue();
            if (uiForm.isAddNew_) {
                uiForm.update(null, true);
            } else {
                UIScriptManager uiScriptManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
                UIScriptContainer uiScriptContainer = (UIScriptContainer)uiScriptManager.getChildById(uiScriptManager.getSelectedTabId());
                UIScriptList uiScriptList = (UIScriptList)uiScriptContainer.getChild(UIScriptList.class);
                try {
                    Node script = uiScriptList.getScriptNode(uiScriptList.getTemplateFilter(), scriptName);
                    uiForm.update(script, false);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    String namePrefix = uiScriptList.getScriptCategory();
                    Object[] args = new Object[]{namePrefix};
                    UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.PathNotFoundException", args, 1));
                    return;
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIScriptManager.class));
        }
    }

    public static class RestoreActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            block3: {
                UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
                String name = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue();
                UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
                UIScriptContainer uiContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
                UIScriptList uiScriptList = (UIScriptList)uiContainer.getChild(UIScriptList.class);
                try {
                    Node node = uiScriptList.getScriptNode(uiScriptList.getTemplateFilter(), name);
                    String version = (String)uiForm.getUIFormSelectBox(UIScriptForm.FIELD_SELECT_VERSION).getValue();
                    String baseVersion = node.getBaseVersion().getName();
                    if (!version.equals(baseVersion)) {
                        node.checkout();
                        node.restore(version, true);
                        uiScriptList.refresh(uiScriptList.getTemplateFilter(), 1);
                    }
                    UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChild(UIPopupWindow.class);
                    uiPopup.setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                }
                catch (PathNotFoundException pne) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)pne.getMessage());
                }
            }
        }
    }

    public static class SaveActionListener
    extends EventListener<UIScriptForm> {
        public void execute(Event<UIScriptForm> event) throws Exception {
            UIScriptForm uiForm = (UIScriptForm)((Object)event.getSource());
            ScriptService scriptService = (ScriptService)uiForm.getApplicationComponent(ScriptService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            StringBuilder name = new StringBuilder();
            name.append(((String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_NAME).getValue()).trim());
            String content = ((String)uiForm.getUIFormTextAreaInput(UIScriptForm.FIELD_SCRIPT_CONTENT).getValue()).trim();
            String label = (String)uiForm.getUIStringInput(UIScriptForm.FIELD_SCRIPT_LABEL).getValue();
            if (name.indexOf(UIScriptForm.SCRIPT_FILE_TYPE) < 0) {
                name.append(UIScriptForm.SCRIPT_FILE_TYPE);
            }
            UIScriptList currentList = null;
            UIScriptManager uiManager = (UIScriptManager)uiForm.getAncestorOfType(UIScriptManager.class);
            ArrayList<String> listScript = new ArrayList<String>();
            List<Object> scriptData = new ArrayList();
            String namePrefix = null;
            UIScriptContainer uiContainer = (UIScriptContainer)uiManager.getChildById(uiManager.getSelectedTabId());
            currentList = (UIScriptList)uiContainer.getChild(UIScriptList.class);
            namePrefix = currentList.getScriptCategory();
            String subNamePrefix = namePrefix.substring(namePrefix.lastIndexOf("/") + 1, namePrefix.length());
            scriptData = currentList.getScript(subNamePrefix);
            for (UIScriptList.ScriptData scriptData2 : scriptData) {
                listScript.add(scriptData2.getName());
            }
            if (listScript.contains(name.toString()) && uiForm.isAddNew_) {
                Object[] args = new Object[]{name};
                ApplicationMessage applicationMessage = new ApplicationMessage("UIScriptForm.msg.name-exist", args, 1);
                applicationMessage.setArgsLocalized(false);
                uiApp.addMessage(applicationMessage);
                return;
            }
            boolean isEnableVersioning = uiForm.getUICheckBoxInput(UIScriptForm.FIELD_ENABLE_VERSION).isChecked();
            label = label == null ? name.toString() : label.trim();
            if (uiForm.isAddNew_ || !isEnableVersioning) {
                try {
                    scriptService.addScript(namePrefix + "/" + name, label, content, WCMCoreUtils.getUserSessionProvider());
                }
                catch (AccessDeniedException accessDeniedException) {
                    uiApp.addMessage(new ApplicationMessage("UIECMAdminControlPanel.msg.access-denied", null, 1));
                    return;
                }
            }
            try {
                Node node = currentList.getScriptNode(currentList.getTemplateFilter(), name.toString());
                if (!node.isNodeType("mix:versionable")) {
                    node.addMixin("mix:versionable");
                } else {
                    node.checkout();
                }
                scriptService.addScript(namePrefix + "/" + name, label, content, WCMCoreUtils.getUserSessionProvider());
                node.save();
                node.checkin();
            }
            catch (PathNotFoundException pathNotFoundException) {
                Object[] args = new Object[]{namePrefix};
                uiApp.addMessage(new ApplicationMessage("UIScriptForm.msg.PathNotFoundException", args, 1));
                return;
            }
            uiForm.reset();
            UIPopupWindow uIPopupWindow = (UIPopupWindow)uiManager.getChild(UIPopupWindow.class);
            uIPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)currentList);
            currentList.refresh(currentList.getTemplateFilter(), 1);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

