/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.permission;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class AdjustDrivePermissionNewUserListener
extends UserEventListener {
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public AdjustDrivePermissionNewUserListener(NodeHierarchyCreator nodeHierarchyCreator, InitParams params) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public void preSave(User user, boolean isNew) throws Exception {
        String userName = user.getUserName();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, userName);
        NodeIterator nodeIter = userNode.getNodes();
        while (nodeIter.hasNext()) {
            NodeImpl nodeImpl = (NodeImpl)nodeIter.next();
            if (nodeImpl.canAddMixin("exo:privilegeable")) {
                nodeImpl.addMixin("exo:privilegeable");
                Map<String, String[]> permissions = this.buildPermissions(nodeImpl);
                nodeImpl.setPermissions(permissions);
                nodeImpl.save();
            }
            nodeImpl.removePermission(userName, "remove");
        }
    }

    public void preDelete(User user) throws Exception {
    }

    public Map<String, String[]> buildPermissions(NodeImpl node) throws RepositoryException {
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        List permsList = new ArrayList();
        String key = null;
        for (AccessControlEntry entry : node.getACL().getPermissionEntries()) {
            key = entry.getIdentity();
            if (permissions.containsKey(key)) continue;
            permsList = node.getACL().getPermissions(key);
            permissions.put(key, permsList.toArray(new String[permsList.size()]));
        }
        return permissions;
    }
}

