/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.gadget;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.exoplatform.application.gadget.EncodingDetector;
import org.exoplatform.application.gadget.impl.GadgetDefinition;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public abstract class GadgetImporter {
    protected static final Logger log = LoggerFactory.getLogger(GadgetImporter.class);
    private String gadgetName;
    private String gadgetURI;

    protected GadgetImporter(String gadgetName, String gadgetURI) {
        this.gadgetName = gadgetName;
        this.gadgetURI = gadgetURI;
    }

    public String getGadgetName() {
        return this.gadgetName;
    }

    public String getGadgetURI() {
        return this.gadgetURI;
    }

    protected abstract byte[] getGadgetBytes(String var1) throws IOException;

    protected abstract String getGadgetURL();

    protected abstract void process(String var1, GadgetDefinition var2) throws Exception;

    protected abstract void processMetadata(ModulePrefs var1, GadgetDefinition var2);

    public void doImport(GadgetDefinition def) throws Exception {
        byte[] bytes = this.getGadgetBytes(this.gadgetURI);
        if (bytes == null) {
            throw new IOException("Cannot import gadget " + this.gadgetURI + " because its data could not be found");
        }
        this.process(this.gadgetURI, def);
        String encoding = EncodingDetector.detect(new ByteArrayInputStream(bytes));
        String gadget = new String(bytes, encoding);
        String gadgetURL = this.getGadgetURL();
        GadgetSpec spec = new GadgetSpec(Uri.parse((String)gadgetURL), gadget);
        ModulePrefs prefs = spec.getModulePrefs();
        this.processMetadata(prefs, def);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getGadgetName() + ",path=" + this.getGadgetURI() + "]";
    }
}

