/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UIPageNodeForm;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.social.webui.space.UISpaceSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UIManageMySpaces.gtmpl", events={@EventConfig(listeners={DeleteSpaceActionListener.class}), @EventConfig(listeners={LeaveSpaceActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMoreSpaceActionListener.class})})
public class UIManageMySpaces
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIManageMySpaces.class);
    private static final String MSG_WARNING_LEAVE_SPACE = "UIManageMySpaces.msg.warning_leave_space";
    private static final Integer LEADER = 1;
    private static final Integer MEMBER = 2;
    private static final String SPACE_DELETED_INFO = "UIManageMySpaces.msg.DeletedInfo";
    private static final String MEMBERSHIP_REMOVED_INFO = "UIManageMySpaces.msg.MemberShipRemovedInfo";
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String SEARCH_ALL = "All";
    private static final String SPACE_SEARCH = "SpaceSearch";
    private final Integer SPACES_PER_PAGE = 20;
    private SpaceService spaceService = null;
    private String userId = null;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");
    private boolean hasUpdatedSpace = false;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private String spaceNameSearch;
    private List<Space> mySpacesList;
    private ListAccess<Space> mySpacesListAccess;
    private int mySpacesNum;
    private String selectedChar = null;

    public UIManageMySpaces() throws Exception {
        this.uiSpaceSearch.setTypeOfRelation(CONFIRMED_STATUS);
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.init();
        Utils.setCurrentNavigationData(Util.getPortalRequestContext());
    }

    public void init() {
        try {
            this.enableLoadNext = true;
            this.loadingCapacity = this.SPACES_PER_PAGE;
            this.uiSpaceSearch.setSpaceNameSearch(null);
            this.uiSpaceSearch.getUIStringInput(SPACE_SEARCH).setValue((Object)"");
            if (this.selectedChar != null) {
                this.setSelectedChar(this.selectedChar);
            } else {
                this.setSelectedChar(SEARCH_ALL);
            }
            this.mySpacesList = this.loadMySpaces(0, this.loadingCapacity);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean unableLoadNext) {
        this.enableLoadNext = unableLoadNext;
    }

    public boolean isHasUpdatedSpace() {
        return this.hasUpdatedSpace;
    }

    public void setHasUpdatedSpace(boolean hasUpdatedSpace) {
        this.hasUpdatedSpace = hasUpdatedSpace;
    }

    public List<Space> getMySpacesList() throws Exception {
        if (this.isHasUpdatedSpace()) {
            this.setMySpacesList(this.loadMySpaces(0, this.SPACES_PER_PAGE));
        } else if (!Utils.isRefreshPage()) {
            this.uiSpaceSearch.setSpaceNameSearch(null);
            this.uiSpaceSearch.getUIStringInput(SPACE_SEARCH).setValue((Object)"");
            this.setMySpacesList(this.loadMySpaces(0, this.SPACES_PER_PAGE));
        }
        return this.mySpacesList;
    }

    public void setMySpacesList(List<Space> mySpacesList) {
        this.mySpacesList = mySpacesList;
    }

    public int getMySpacesNum() {
        return this.mySpacesNum;
    }

    public void setMySpacesNum(int mySpacesNum) {
        this.mySpacesNum = mySpacesNum;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public ListAccess<Space> getMySpacesListAccess() {
        return this.mySpacesListAccess;
    }

    public void setMySpacesListAccess(ListAccess<Space> mySpacesListAccess) {
        this.mySpacesListAccess = mySpacesListAccess;
    }

    public void loadNext() throws Exception {
        int _currentIndex = this.mySpacesList.size();
        if (_currentIndex <= this.getMySpacesNum()) {
            ArrayList<Object> loaded = new ArrayList<Object>(Arrays.asList(this.getMySpacesListAccess().load(_currentIndex, this.loadingCapacity)));
            this.mySpacesList.addAll(loaded);
            this.setEnableLoadNext(loaded.size() < this.SPACES_PER_PAGE ? false : this.mySpacesList.size() < this.getMySpacesNum());
        }
    }

    public void loadSearch() throws Exception {
        this.setMySpacesList(this.loadMySpaces(0, this.loadingCapacity));
    }

    private List<Space> loadMySpaces(int index, int length) throws Exception {
        String charSearch = this.getSelectedChar();
        String searchCondition = this.uiSpaceSearch.getSpaceNameSearch();
        if (SEARCH_ALL.equals(charSearch) || charSearch == null && searchCondition == null) {
            this.setMySpacesListAccess((ListAccess<Space>)this.getSpaceService().getMemberSpaces(this.getUserId()));
        } else if (searchCondition != null) {
            this.setMySpacesListAccess((ListAccess<Space>)this.getSpaceService().getMemberSpacesByFilter(this.getUserId(), new SpaceFilter(searchCondition)));
        } else if (charSearch != null) {
            this.setMySpacesListAccess((ListAccess<Space>)this.getSpaceService().getMemberSpacesByFilter(this.getUserId(), new SpaceFilter(charSearch.charAt(0))));
        }
        this.setMySpacesNum(this.getMySpacesListAccess().getSize());
        this.uiSpaceSearch.setSpaceNum(this.getMySpacesNum());
        Space[] spaces = (Space[])this.getMySpacesListAccess().load(index, length);
        this.setEnableLoadNext(spaces.length < this.SPACES_PER_PAGE ? false : this.getMySpacesNum() > this.SPACES_PER_PAGE);
        return new ArrayList<Space>(Arrays.asList(spaces));
    }

    public int getRole(String spaceId) throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(spaceId);
        String userId = this.getUserId();
        if (space != null && spaceService.hasSettingPermission(space, userId)) {
            return LEADER;
        }
        return MEMBER;
    }

    public boolean hasMembership(String spaceId) throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        Space space = spaceService.getSpaceById(spaceId);
        if (space == null) {
            return false;
        }
        return spaceService.isMember(space, userId);
    }

    public String getImageSource(Space space) throws Exception {
        return space.getAvatarUrl();
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public static class LeaveSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            String userId = uiMySpaces.getUserId();
            Space space = spaceService.getSpaceById(spaceId);
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            if (spaceService.isOnlyManager(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MSG_WARNING_LEAVE_SPACE, null, 1));
                return;
            }
            spaceService.removeMember(space, userId);
            spaceService.setManager(space, userId, false);
            uiMySpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class DeleteSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)((Object)event.getSource());
            SpaceService spaceService = uiMySpaces.getSpaceService();
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApp = ctx.getUIApplication();
            String spaceId = ctx.getRequestParameter("objectId");
            Space space = spaceService.getSpaceById(spaceId);
            String userId = uiMySpaces.getUserId();
            if (space == null) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.SPACE_DELETED_INFO, null, 2));
                return;
            }
            if (!spaceService.isMember(space, userId) && !spaceService.hasSettingPermission(space, userId)) {
                uiApp.addMessage(new ApplicationMessage(UIManageMySpaces.MEMBERSHIP_REMOVED_INFO, null, 2));
                return;
            }
            spaceService.deleteSpace(space);
            uiMySpaces.setHasUpdatedSpace(true);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiPageNode = (UIPageNodeForm)((Object)event.getSource());
            UserNavigation contextNavigation = uiPageNode.getContextPageNavigation();
            UIManageMySpaces uiMySpaces = (UIManageMySpaces)uiPageNode.getAncestorOfType(UIManageMySpaces.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiMySpaces.getChild(UIPopupWindow.class);
            UISpaceNavigationManagement navigationManager = (UISpaceNavigationManagement)uiMySpaces.createUIComponent(UISpaceNavigationManagement.class, null, null);
            navigationManager.setOwner(contextNavigation.getKey().getName());
            navigationManager.setOwnerType(contextNavigation.getKey().getTypeName());
            UISpaceNavigationNodeSelector selector = (UISpaceNavigationNodeSelector)navigationManager.getChild(UISpaceNavigationNodeSelector.class);
            selector.setEdittedNavigation(contextNavigation);
            selector.initTreeData();
            uiPopup.setUIComponent((UIComponent)navigationManager);
            uiPopup.setWindowSize(400, 400);
            uiPopup.setRendered(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMySpaces);
        }
    }

    public static class SearchActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiManageMySpaces = (UIManageMySpaces)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            String charSearch = ctx.getRequestParameter("objectId");
            if (charSearch == null) {
                uiManageMySpaces.setSelectedChar(null);
            } else {
                uiManageMySpaces.uiSpaceSearch.getUIStringInput(UIManageMySpaces.SPACE_SEARCH).setValue((Object)"");
                uiManageMySpaces.uiSpaceSearch.setSpaceNameSearch(null);
                uiManageMySpaces.setSelectedChar(charSearch);
            }
            uiManageMySpaces.loadSearch();
            uiManageMySpaces.setHasUpdatedSpace(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageMySpaces);
        }
    }

    public static class LoadMoreSpaceActionListener
    extends EventListener<UIManageMySpaces> {
        public void execute(Event<UIManageMySpaces> event) throws Exception {
            UIManageMySpaces uiManageMySpaces = (UIManageMySpaces)((Object)event.getSource());
            uiManageMySpaces.loadNext();
            uiManageMySpaces.setHasUpdatedSpace(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManageMySpaces);
        }
    }
}

