/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.form.UIFormUploadInputNoUploadButton;
import org.exoplatform.ecm.webui.form.validator.CategoryValidator;
import org.exoplatform.ecm.webui.form.validator.CronExpressionValidator;
import org.exoplatform.ecm.webui.form.validator.DateValidator;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.form.validator.PhoneFormatValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatCountValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatIntervalValidator;
import org.exoplatform.ecm.webui.form.validator.XSSValidator;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.input.UIUploadInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.DoubleFormatValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NullFieldValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

public class DialogFormUtil {
    public static String VALIDATOR_PARAM_BEGIN = "(";
    public static String VALIDATOR_PARAM_END = ")";
    public static String VALIDATOR_PARAM_SEPERATOR = ";";
    public static String SANITIZATION_FLAG = "noSanitization";
    public static String TYPE_FLOAT = "Float";
    public static String TYPE_DOUBLE = "Double";
    public static String TYPE_INTEGER = "Int";
    public static String TYPE_STRING = "String";

    public static Map<String, JcrInputProperty> prepareMap(List inputs, Map properties) throws Exception {
        return DialogFormUtil.prepareMap(inputs, properties, null);
    }

    public static Map<String, JcrInputProperty> prepareMap(List inputs, Map properties, Map options) throws Exception {
        HashMap<String, String> changeInJcrPathParamMap = new HashMap<String, String>();
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        String inputName = null;
        String mimeTypeJcrPath = null;
        InputStream inputStream = null;
        HashMap<String, JcrInputProperty> mimeTypes = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            Object option = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                UIFormMultiValueInputSet inputI = (UIFormMultiValueInputSet)inputs.get(i);
                inputName = inputI.getName();
                if (!hasMap.containsKey(inputName)) {
                    List inputChild = inputI.getChildren();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (inputChild != null && inputChild.size() > 0 && inputChild.get(0) instanceof UIUploadInput) {
                        TreeMap uploadDataMap = new TreeMap();
                        for (UIComponent child : inputChild) {
                            UIUploadInput uploadInput = (UIUploadInput)child;
                            String uploadId = uploadInput.getUploadIds()[0];
                            String uploadDataName = null;
                            String uploadMimeType = null;
                            byte[] uploadData = null;
                            if (uploadInput instanceof UIFormUploadInputNoUploadButton) {
                                uploadDataName = ((UIFormUploadInputNoUploadButton)uploadInput).getFileName();
                                uploadMimeType = ((UIFormUploadInputNoUploadButton)uploadInput).getMimeType();
                                uploadData = ((UIFormUploadInputNoUploadButton)uploadInput).getByteValue();
                            } else {
                                UploadResource uploadResource = uploadInput.getUploadResource(uploadId);
                                if (uploadResource != null) {
                                    String location = uploadResource.getStoreLocation();
                                    uploadDataName = uploadResource.getFileName();
                                    uploadData = IOUtil.getFileContentAsBytes((String)location);
                                    uploadMimeType = uploadResource.getMimeType();
                                }
                            }
                            if (uploadDataName == null || uploadData == null) continue;
                            ArrayList<Object> data = new ArrayList<Object>();
                            data.add(uploadMimeType);
                            data.add(uploadData);
                            if (!uploadDataMap.containsKey(uploadDataName)) {
                                uploadDataMap.put(uploadDataName, data);
                                continue;
                            }
                            int count = 1;
                            while (uploadDataMap.containsKey(uploadDataName + count)) {
                                ++count;
                            }
                            uploadDataMap.put(uploadDataName + count, data);
                        }
                        property.setValue(uploadDataMap);
                    } else {
                        List values = inputI.getValue();
                        if (property != null) {
                            property.setValue((Object)values.toArray(new String[values.size()]));
                        }
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (options != null && options.get(input.getName()) != null) {
                option = (String)options.get(input.getName());
            }
            if (property == null) continue;
            if (input instanceof UIUploadInput) {
                String uploadId = ((UIUploadInput)input).getUploadIds()[0];
                UploadResource uploadResource = ((UIUploadInput)input).getUploadResource(uploadId);
                if (uploadResource == null) {
                    if (property.getChangeInJcrPathParam() == null) continue;
                    changeInJcrPathParamMap.put(property.getChangeInJcrPathParam(), "");
                    continue;
                }
                String location = uploadResource.getStoreLocation();
                byte[] uploadData = IOUtil.getFileContentAsBytes((String)location);
                property.setValue((Object)uploadData);
                if (property.getChangeInJcrPathParam() != null) {
                    changeInJcrPathParamMap.put(property.getChangeInJcrPathParam(), Text.escapeIllegalJcrChars((String)uploadResource.getFileName()));
                }
                mimeTypeJcrPath = property.getJcrPath().replace("jcr:data", "jcr:mimeType");
                JcrInputProperty mimeTypeInputPropertyTmp = new JcrInputProperty();
                mimeTypeInputPropertyTmp.setJcrPath(mimeTypeJcrPath);
                mimeTypeInputPropertyTmp.setValue((Object)((UIUploadInput)input).getUploadResource(uploadId).getMimeType());
                mimeTypes.put(mimeTypeJcrPath, mimeTypeInputPropertyTmp);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            if (input instanceof UIFormSelectBox) {
                UIFormSelectBox uiSelectBox = (UIFormSelectBox)input;
                if (!uiSelectBox.isMultiple()) {
                    property.setValue(uiSelectBox.getValue());
                    continue;
                }
                property.setValue((Object)uiSelectBox.getSelectedValues());
                continue;
            }
            if (input instanceof UICheckBoxInput) {
                property.setValue((Object)((UICheckBoxInput)input).isChecked());
                continue;
            }
            if (input.getValue() != null) {
                String inputValue = input.getValue().toString().trim();
                boolean isEmpty = Utils.isEmptyContent(inputValue);
                if (isEmpty) {
                    inputValue = "";
                } else if (option == null || ((String)option).indexOf(SANITIZATION_FLAG) < 0) {
                    inputValue = HTMLSanitizer.sanitize((String)inputValue);
                }
                if (input.getName().equals("name") && ((UIDialogForm)input.getAncestorOfType(UIDialogForm.class)).isAddNew()) {
                    JcrInputProperty jcrExoTitle;
                    JcrInputProperty titleInputProperty = (JcrInputProperty)properties.get("title");
                    if (titleInputProperty == null) {
                        jcrExoTitle = new JcrInputProperty();
                        jcrExoTitle.setJcrPath("/node/exo:title");
                        jcrExoTitle.setValue((Object)inputValue);
                        properties.put("/node/exo:title", jcrExoTitle);
                    } else if (titleInputProperty.getValue() == null) {
                        jcrExoTitle = new JcrInputProperty();
                        jcrExoTitle.setJcrPath(titleInputProperty.getJcrPath());
                        jcrExoTitle.setValue((Object)inputValue);
                        properties.put("title", jcrExoTitle);
                    }
                    property.setValue((Object)Text.escapeIllegalJcrChars((String)org.exoplatform.services.cms.impl.Utils.cleanString((String)inputValue)));
                    continue;
                }
                property.setValue((Object)inputValue);
                continue;
            }
            if (input.getName() == "title") continue;
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        for (Object jcrPath : mimeTypes.keySet()) {
            if (rawinputs.containsKey(jcrPath)) continue;
            rawinputs.put((String)jcrPath, (JcrInputProperty)mimeTypes.get(jcrPath));
        }
        ArrayList<UIUploadInput> formUploadList = new ArrayList<UIUploadInput>();
        for (Object input : inputs) {
            if (input instanceof UIFormMultiValueInputSet) {
                UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)input;
                if (uiSet.getId() == null || !uiSet.getUIFormInputBase().equals(UIUploadInput.class) || !uiSet.getId().equals("attachment__")) continue;
                List list = uiSet.getChildren();
                for (UIComponent component : list) {
                    if (formUploadList.contains(component)) continue;
                    formUploadList.add((UIUploadInput)component);
                }
                continue;
            }
            if (!(input instanceof UIUploadInput) || formUploadList.contains(input)) continue;
            formUploadList.add((UIUploadInput)input);
        }
        if (formUploadList.size() > 0) {
            ArrayList<String> keyListToRemove = new ArrayList<String>();
            HashMap<String, JcrInputProperty> jcrPropertiesToAdd = new HashMap<String, JcrInputProperty>();
            for (Object inputJCRKeyTmp : rawinputs.keySet()) {
                String inputJCRKey = (String)inputJCRKeyTmp;
                if (!inputJCRKey.contains("attachment__")) continue;
                JcrInputProperty jcrInputProperty = (JcrInputProperty)rawinputs.get(inputJCRKey);
                for (UIUploadInput uploadInput : formUploadList) {
                    String uploadId = uploadInput.getUploadIds()[0];
                    JcrInputProperty newJcrInputProperty = DialogFormUtil.clone(jcrInputProperty);
                    if (uploadInput == null || uploadInput.getUploadResource(uploadId) == null || uploadInput.getUploadResource(uploadId).getFileName() == null) continue;
                    String fileName = uploadInput.getUploadResource(uploadId).getFileName();
                    String newJCRPath = inputJCRKey.replace("attachment__", fileName);
                    newJcrInputProperty.setJcrPath(newJCRPath);
                    if (inputJCRKey.endsWith("attachment__")) {
                        newJcrInputProperty.setValue((Object)fileName);
                        JcrInputProperty mimeTypeInputPropertyTmp = new JcrInputProperty();
                        mimeTypeInputPropertyTmp.setJcrPath(newJCRPath + "/jcr:content/jcr:mimeType");
                        mimeTypeInputPropertyTmp.setValue((Object)uploadInput.getUploadResource(uploadId).getMimeType());
                        jcrPropertiesToAdd.put(mimeTypeInputPropertyTmp.getJcrPath(), mimeTypeInputPropertyTmp);
                    }
                    if (inputJCRKey.endsWith("jcr:data")) {
                        inputStream = uploadInput.getUploadDataAsStream(uploadId);
                        newJcrInputProperty.setValue((Object)inputStream);
                    }
                    jcrPropertiesToAdd.put(newJCRPath, newJcrInputProperty);
                }
                keyListToRemove.add(inputJCRKey);
                keyListToRemove.add(inputJCRKey.replace("jcr:data", "jcr:mimeType"));
            }
            for (String keyToRemove : keyListToRemove) {
                rawinputs.remove(keyToRemove);
            }
            rawinputs.putAll(jcrPropertiesToAdd);
        }
        if (changeInJcrPathParamMap.isEmpty()) {
            return rawinputs;
        }
        HashMap<String, JcrInputProperty> ret = new HashMap<String, JcrInputProperty>();
        HashSet removedKeys = new HashSet();
        for (Map.Entry changeEntry : changeInJcrPathParamMap.entrySet()) {
            for (Map.Entry entry : rawinputs.entrySet()) {
                if (!((String)entry.getKey()).contains((CharSequence)changeEntry.getKey())) continue;
                removedKeys.add(entry.getKey());
                JcrInputProperty value = (JcrInputProperty)entry.getValue();
                if (value.getJcrPath() != null) {
                    value.setJcrPath(value.getJcrPath().replace((CharSequence)changeEntry.getKey(), (CharSequence)changeEntry.getValue()));
                }
                if (value.getValue() != null && value.getValue() instanceof String) {
                    value.setValue((Object)((String)value.getValue()).replace((CharSequence)changeEntry.getKey(), (CharSequence)changeEntry.getValue()));
                }
                if (value == null || "".equals(value) || changeEntry.getValue() == null || "".equals(changeEntry.getValue())) continue;
                ret.put(((String)entry.getKey()).replace((CharSequence)changeEntry.getKey(), (CharSequence)changeEntry.getValue()), value);
            }
        }
        for (Map.Entry entry : rawinputs.entrySet()) {
            if (removedKeys.contains(entry.getKey())) continue;
            ret.put((String)entry.getKey(), (JcrInputProperty)entry.getValue());
        }
        return ret;
    }

    private static JcrInputProperty clone(JcrInputProperty fileNodeInputProperty) {
        JcrInputProperty jcrInputProperty = new JcrInputProperty();
        jcrInputProperty.setJcrPath(fileNodeInputProperty.getJcrPath());
        jcrInputProperty.setMixintype(fileNodeInputProperty.getMixintype());
        jcrInputProperty.setNodetype(fileNodeInputProperty.getNodetype());
        jcrInputProperty.setType(fileNodeInputProperty.getType());
        jcrInputProperty.setValue(fileNodeInputProperty.getValue());
        jcrInputProperty.setValueType(fileNodeInputProperty.getValueType());
        return jcrInputProperty;
    }

    public static <T extends UIFormInputBase> T createFormInput(Class<T> type, String name, String label, String validateType, Class valueType) throws Exception {
        Object[] args = new Object[]{name, null, valueType};
        UIFormInputBase formInput = (UIFormInputBase)type.getConstructor(new Class[0]).newInstance(args);
        DialogFormUtil.addValidators(formInput, validateType);
        if (label != null && label.length() != 0) {
            formInput.setLabel(label);
        }
        return (T)((UIFormInputBase)type.cast(formInput));
    }

    public static String getPropertyValueAsString(Node node, String propertyName) throws Exception {
        Property property = null;
        try {
            property = node.getProperty(propertyName);
        }
        catch (PathNotFoundException e) {
            return "";
        }
        int valueType = property.getType();
        switch (valueType) {
            case 1: {
                return property.getString();
            }
            case 3: {
                return Long.toString(property.getLong());
            }
            case 4: {
                return Double.toString(property.getDouble());
            }
            case 5: {
                return property.getDate().getTime().toString();
            }
            case 6: {
                return Boolean.toString(property.getBoolean());
            }
            case 7: {
                return property.getName();
            }
        }
        return "";
    }

    public static Class getValidator(String validatorType) throws ClassNotFoundException {
        if (validatorType.equals("name")) {
            return ECMNameValidator.class;
        }
        if (validatorType.equals("email")) {
            return EmailAddressValidator.class;
        }
        if (validatorType.equals("number")) {
            return NumberFormatValidator.class;
        }
        if (validatorType.equals("double")) {
            return DoubleFormatValidator.class;
        }
        if (validatorType.equals("empty")) {
            return MandatoryValidator.class;
        }
        if (validatorType.equals("null")) {
            return NullFieldValidator.class;
        }
        if (validatorType.equals("datetime")) {
            return DateTimeValidator.class;
        }
        if (validatorType.equals("date")) {
            return DateValidator.class;
        }
        if (validatorType.equals("cronExpressionValidator")) {
            return CronExpressionValidator.class;
        }
        if (validatorType.equals("repeatCountValidator")) {
            return RepeatCountValidator.class;
        }
        if (validatorType.equals("repeatIntervalValidator")) {
            return RepeatIntervalValidator.class;
        }
        if (validatorType.equals("length")) {
            return StringLengthValidator.class;
        }
        if (validatorType.equals("category")) {
            return CategoryValidator.class;
        }
        if (validatorType.equals("XSSValidator")) {
            return XSSValidator.class;
        }
        if (validatorType.equals("phone")) {
            return PhoneFormatValidator.class;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(validatorType);
    }

    public static void addValidators(UIFormInputBase uiInput, String validators) throws Exception {
        String[] validatorList = null;
        validatorList = validators.indexOf(44) > -1 ? validators.split(",") : new String[]{validators};
        for (String validator : validatorList) {
            String s_param = null;
            int p_begin = validator.indexOf(VALIDATOR_PARAM_BEGIN);
            int p_end = validator.indexOf(VALIDATOR_PARAM_END);
            if (p_begin > 0 && p_end > p_begin) {
                s_param = validator.substring(p_begin + 1, p_end);
                Object[] params = s_param.split(VALIDATOR_PARAM_SEPERATOR);
                params = DialogFormUtil.parserValidatorParam(params, params.length - 1, params[params.length - 1].toString());
                String v_name = validator.substring(0, p_begin);
                uiInput.addValidator(DialogFormUtil.getValidator(v_name.trim()), params);
                continue;
            }
            uiInput.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
        }
    }

    public static Object[] parserValidatorParam(Object[] params, int length, String type) throws Exception {
        if (length < 1) {
            return params;
        }
        Object[] newParams = new Object[length];
        if (type.equalsIgnoreCase(TYPE_INTEGER)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Integer.parseInt(params[i].toString());
            }
        } else if (type.equalsIgnoreCase(TYPE_FLOAT)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Float.valueOf(Float.parseFloat(params[i].toString()));
            }
        } else if (type.equalsIgnoreCase(TYPE_DOUBLE)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Double.parseDouble(params[i].toString());
            }
        } else {
            return params;
        }
        return newParams;
    }
}

