/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.ClusteringInterceptor;
import org.infinispan.remoting.responses.ClusteredGetResponseValidityFilter;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicationInterceptor
extends ClusteringInterceptor {
    private boolean isPessimisticCache;
    private static final Log log = LogFactory.getLog(ReplicationInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    protected Log getLog() {
        return log;
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("This should not be possible!");
        }
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.sendCommitCommand(command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void sendCommitCommand(CommitCommand command) throws TimeoutException, InterruptedException {
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.cacheConfiguration.transaction().syncCommitPhase(), true);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.broadcastPrepare(ctx, command);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastPrepare(TxInvocationContext context, PrepareCommand command) {
        try {
            boolean async = this.cacheConfiguration.clustering().cacheMode() == CacheMode.REPL_ASYNC;
            this.rpcManager.broadcastRpcCommand(command, !async, false);
        }
        finally {
            ReplicationInterceptor.transactionRemotelyPrepared(context);
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        boolean prepareSent;
        boolean bl = prepareSent = ctx.isOriginLocal() && ((LocalTransaction)ctx.getCacheTransaction()).isPrepareSent();
        if (!(!this.shouldInvokeRemoteTxCommand(ctx) || prepareSent && Configurations.isOnePhaseCommit(this.cacheConfiguration))) {
            this.rpcManager.broadcastRpcCommand(command, this.cacheConfiguration.transaction().syncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue == null && ctx.isOriginLocal()) {
                if (this.needsRemoteGet(ctx, command)) {
                    returnValue = this.remoteGet(ctx, command.getKey(), command, false);
                }
                if (returnValue == null) {
                    returnValue = this.localGet(ctx, command.getKey(), false, command);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
            this.rpcManager.broadcastRpcCommand(command, sync, false);
        }
        return retVal;
    }

    private Object remoteGet(InvocationContext ctx, Object key, FlagAffectedCommand command, boolean isWrite) throws Throwable {
        if (trace) {
            log.tracef("Key %s is not yet available on %s, so we may need to look elsewhere", key, this.rpcManager.getAddress());
        }
        boolean acquireRemoteLock = false;
        if (ctx.isInTxScope()) {
            TxInvocationContext txContext = (TxInvocationContext)ctx;
            acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
        }
        InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command);
        if (acquireRemoteLock) {
            ((TxInvocationContext)ctx).addAffectedKey(key);
        }
        if (ice != null) {
            if (!ctx.replaceValue(key, ice.getValue())) {
                if (isWrite) {
                    this.lockAndWrap(ctx, key, ice, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return ice.getValue();
        }
        return null;
    }

    protected Address getPrimaryOwner() {
        return this.stateTransferManager.getCacheTopology().getReadConsistentHash().getMembers().get(0);
    }

    @Override
    protected InternalCacheEntry retrieveFromRemoteSource(Object key, InvocationContext ctx, boolean acquireRemoteLock, FlagAffectedCommand command) {
        GlobalTransaction gtx = acquireRemoteLock ? ((TxInvocationContext)ctx).getGlobalTransaction() : null;
        ClusteredGetCommand get = this.cf.buildClusteredGetCommand(key, command.getFlags(), acquireRemoteLock, gtx);
        List<Address> targets = Collections.singletonList(this.getPrimaryOwner());
        ClusteredGetResponseValidityFilter filter = new ClusteredGetResponseValidityFilter(targets, this.rpcManager.getAddress());
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(targets, get, ResponseMode.WAIT_FOR_VALID_RESPONSE, this.cacheConfiguration.clustering().sync().replTimeout(), true, filter);
        if (!responses.isEmpty()) {
            for (Response r : responses.values()) {
                if (!(r instanceof SuccessfulResponse)) continue;
                InternalCacheValue cacheValue = (InternalCacheValue)((SuccessfulResponse)r).getResponseValue();
                return cacheValue.toInternalCacheEntry(key);
            }
        }
        return null;
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (!ctx.replaceValue(key, ice.getValue())) {
                if (isWrite) {
                    this.lockAndWrap(ctx, key, ice, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return command instanceof GetCacheEntryCommand ? ice : ice.getValue();
        }
        return null;
    }

    private void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        if (this.isPessimisticCache && this.rpcManager.getAddress().equals(this.getPrimaryOwner())) {
            boolean skipLocking = this.hasSkipLocking(command);
            long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
            this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        }
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, !ctx.isOriginLocal());
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            Object object = this.handleCrudMethod(ctx, command, !ctx.isOriginLocal());
            return object;
        }
        finally {
            if (this.ignorePreviousValueOnBackup(command, ctx)) {
                command.setIgnorePreviousValue(true);
            }
        }
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            Object object = this.handleCrudMethod(ctx, command, !ctx.isOriginLocal());
            return object;
        }
        finally {
            if (this.ignorePreviousValueOnBackup(command, ctx)) {
                command.setIgnorePreviousValue(true);
            }
        }
    }

    private Object handleCrudMethod(InvocationContext ctx, WriteCommand command, boolean skipRemoteGet) throws Throwable {
        if (!skipRemoteGet || command.hasFlag(Flag.DELTA_WRITE)) {
            this.remoteGetBeforeWrite(ctx, command);
        }
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(command) && command.isSuccessful() && ctx.isOriginLocal() && !ctx.isInTxScope()) {
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(command));
        }
        return returnValue;
    }

    private void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (command instanceof AbstractDataCommand && (this.isNeedReliableReturnValues(command) || command.isConditional()) || command.hasFlag(Flag.DELTA_WRITE)) {
            AbstractDataCommand singleKeyCommand = (AbstractDataCommand)((Object)command);
            Object returnValue = null;
            if (this.needsRemoteGet(ctx, singleKeyCommand)) {
                returnValue = this.remoteGet(ctx, singleKeyCommand.getKey(), singleKeyCommand, true);
            }
            if (returnValue == null) {
                this.localGet(ctx, singleKeyCommand.getKey(), true, command);
            }
        }
    }
}

