/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.jpa.storage.dao.IdentityDAO;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;

@Path(value="/social/identity")
public class IdentityAvatarRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(IdentityAvatarRestService.class);
    static final String BASE_URL = "/social/identity";
    private IdentityDAO identityDAO = null;
    private FileService fileService = null;
    private final CacheControl cc = new CacheControl();

    public IdentityAvatarRestService() {
        this.cc.setMaxAge(86400);
    }

    @GET
    @Path(value="/{provider}/{username}/avatar")
    public Response avatar(@Context Request req, @PathParam(value="provider") String providerId, @PathParam(value="username") String username) {
        IdentityDAO identityDAO = this.getIdentityDAO();
        IdentityEntity entity = identityDAO.findByProviderAndRemoteId(providerId, username);
        if (entity == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!entity.getRemoteId().equals(username)) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        Long fileId = entity.getAvatarFileId();
        if (fileId == null || fileId <= 0L) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            Response.ResponseBuilder rb;
            FileItem file = this.getFileService().getFile(fileId.longValue());
            FileInfo info = file.getFileInfo();
            EntityTag eTag = new EntityTag(info.getChecksum());
            Response.ResponseBuilder responseBuilder = rb = eTag == null ? null : req.evaluatePreconditions(eTag);
            if (rb != null) {
                return rb.cacheControl(this.cc).tag(eTag).build();
            }
            MediaType type = MediaType.valueOf((String)info.getMimetype());
            return Response.ok((Object)file.getAsStream(), (MediaType)type).tag(eTag).cacheControl(this.cc).build();
        }
        catch (Exception ex) {
            LOG.warn((Object)("Can not load file ID: " + fileId));
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private IdentityDAO getIdentityDAO() {
        if (this.identityDAO == null) {
            this.identityDAO = this.getService(IdentityDAO.class);
        }
        return this.identityDAO;
    }

    private FileService getFileService() {
        if (this.fileService == null) {
            this.fileService = this.getService(FileService.class);
        }
        return this.fileService;
    }

    private <T> T getService(Class<T> clazz) {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (T)portalContainer.getComponentInstanceOfType(clazz);
    }

    public static String buildAvatarURL(String providerId, String remoteId) {
        if (providerId == null || remoteId == null) {
            return null;
        }
        String username = remoteId;
        String provider = providerId;
        try {
            username = URLEncoder.encode(username, "UTF-8");
            provider = URLEncoder.encode(provider, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn((Object)"Failure to encode username for build URL", (Throwable)ex);
        }
        return "/rest" + BASE_URL + "/" + provider + "/" + username + "/avatar";
    }
}

