/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ProfileSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(ProfileSearchConnector.class);
    private final ElasticSearchingClient client;
    private String index;
    private String searchType;

    public ProfileSearchConnector(InitParams initParams, ElasticSearchingClient client) {
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        this.searchType = param.getProperty("searchType");
        this.client = client;
    }

    public List<Identity> search(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        if (identity == null && filter.getViewerIdentity() != null) {
            identity = filter.getViewerIdentity();
        }
        String esQuery = this.buildQueryStatement(identity, filter, type, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index, this.searchType);
        return this.buildResult(jsonResponse);
    }

    public int count(Identity identity, ProfileFilter filter, Relationship.Type type) {
        String esQuery = this.buildQueryStatement(identity, filter, type, 0L, 1L);
        String jsonResponse = this.client.sendRequest(esQuery, this.index, this.searchType);
        return this.getCount(jsonResponse);
    }

    private int getCount(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return 0;
        }
        int count = Integer.parseInt(jsonResult.get((Object)"total").toString());
        return count;
    }

    private List<Identity> buildResult(String jsonResponse) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<Identity> results = new ArrayList<Identity>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        Identity identity = null;
        for (Object jsonHit : jsonHits) {
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            String position = (String)hitSource.get((Object)"position");
            String name = (String)hitSource.get((Object)"name");
            String userName = (String)hitSource.get((Object)"userName");
            String firstName = (String)hitSource.get((Object)"firstName");
            String lastName = (String)hitSource.get((Object)"lastName");
            String avatarUrl = (String)hitSource.get((Object)"avatarUrl");
            String email = (String)hitSource.get((Object)"email");
            String identityId = (String)((JSONObject)jsonHit).get((Object)"_id");
            identity = new Identity("organization", userName);
            identity.setId(identityId);
            Profile p = new Profile(identity);
            p.setAvatarUrl(avatarUrl);
            p.setUrl(LinkProvider.getProfileUri((String)userName));
            p.setProperty("fullName", (Object)name);
            p.setProperty("firstName", (Object)firstName);
            p.setProperty("lastName", (Object)lastName);
            p.setProperty("position", (Object)position);
            p.setProperty("email", (Object)email);
            p.setProperty("username", (Object)userName);
            identity.setProfile(p);
            results.add(identity);
        }
        return results;
    }

    private String buildQueryStatement(Identity identity, ProfileFilter filter, Relationship.Type type, long offset, long limit) {
        String expEs = this.buildExpression(filter);
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{\n");
        esQuery.append("   \"from\" : " + offset + ", \"size\" : " + limit + ",\n");
        esQuery.append("   \"sort\": [\n");
        esQuery.append("             {\"lastName\": {\"order\": \"asc\"}},\n");
        esQuery.append("             {\"firstName\": {\"order\": \"asc\"}}\n");
        esQuery.append("             ]\n");
        if (identity != null && type != null) {
            esQuery.append("       ,\n");
            esQuery.append("\"query\" : {\n");
            esQuery.append("    \"bool\" :{\n");
            esQuery.append("      \"must\" : {\n");
            esQuery.append("        \"query_string\" : {\n");
            esQuery.append("          \"query\" : \"*" + identity.getId() + "*\",\n");
            esQuery.append("          \"fields\" : [\"" + this.buildTypeEx(type) + "\"]\n");
            esQuery.append("        }\n");
            esQuery.append("      }\n");
        } else if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            esQuery.append("       ,\n");
            esQuery.append("\"query\" : {\n");
            esQuery.append("\"filtered\" :{\n");
            esQuery.append("  \"query\" : {\n");
            esQuery.append("    \"bool\" : {\n");
            esQuery.append("\"must_not\": [\n");
            esQuery.append("        {\n");
            esQuery.append("          \"ids\" : {\n");
            esQuery.append("             \"values\" : [" + this.buildExcludedIdentities(filter) + "]\n");
            esQuery.append("          }\n");
            esQuery.append("        }\n");
            esQuery.append("      ]\n");
            esQuery.append("    }\n");
            esQuery.append("  }\n");
            esQuery.append("  }\n");
            esQuery.append("}\n");
        }
        if (expEs != null && expEs.length() > 0) {
            esQuery.append("      ,\n");
            esQuery.append("\"filter\" : {\n");
            esQuery.append("  \"bool\" : {\n");
            esQuery.append("    \"must\": [\n");
            esQuery.append("      {");
            esQuery.append("        \"query\": {\n");
            esQuery.append("          \"query_string\": {\n");
            esQuery.append("            \"query\": \"" + expEs + "\"\n");
            esQuery.append("          }\n");
            esQuery.append("         }\n");
            esQuery.append("      }\n");
            esQuery.append("    ]\n");
            esQuery.append("  }\n");
            esQuery.append("}\n");
        }
        if (identity != null && type != null) {
            esQuery.append("     }\n");
            esQuery.append("   }\n");
        }
        esQuery.append("}\n");
        LOG.debug("Search Query request to ES : {} ", new Object[]{esQuery});
        return esQuery.toString();
    }

    private String buildExcludedIdentities(ProfileFilter filter) {
        StringBuilder typeExp = new StringBuilder();
        if (filter.getExcludedIdentityList() != null && filter.getExcludedIdentityList().size() > 0) {
            Iterator iter = filter.getExcludedIdentityList().iterator();
            Identity first = (Identity)iter.next();
            typeExp.append("\"").append(first.getId()).append("\"");
            if (!iter.hasNext()) {
                return typeExp.toString();
            }
            while (iter.hasNext()) {
                Identity next = (Identity)iter.next();
                typeExp.append(",\"").append(next.getId()).append("\"");
            }
        }
        return typeExp.toString();
    }

    private String buildTypeEx(Relationship.Type type) {
        String result;
        switch (type) {
            case CONFIRMED: {
                result = "connections";
                break;
            }
            case INCOMING: {
                result = "outgoings";
                break;
            }
            case OUTGOING: {
                result = "incomings";
                break;
            }
            default: {
                throw new IllegalArgumentException("Type [" + type + "] not supported");
            }
        }
        return result;
    }

    private String buildExpression(ProfileFilter filter) {
        String position;
        String skills;
        String inputName;
        StringBuilder esExp = new StringBuilder();
        char firstChar = filter.getFirstCharacterOfName();
        if (firstChar != '\u0000') {
            esExp.append("lastName:").append(firstChar).append("*");
            return esExp.toString();
        }
        String string = inputName = StringUtils.isBlank((String)filter.getName()) ? null : filter.getName().replace("*", "");
        if (StringUtils.isNotBlank(inputName)) {
            String[] keys = inputName.split(" ");
            if (keys.length > 1) {
                esExp.append("(");
                for (int i = 0; i < keys.length; ++i) {
                    if (i != 0) {
                        esExp.append(" AND ");
                    }
                    esExp.append(" name:").append("*").append(ProfileSearchConnector.removeAccents(keys[i])).append("*");
                }
                esExp.append(")");
            } else {
                esExp.append("( name:").append("*").append(ProfileSearchConnector.removeAccents(inputName)).append("*");
                esExp.append(" OR userName:").append("*").append(ProfileSearchConnector.removeAccents(inputName)).append("*").append(")");
            }
        }
        String string2 = skills = StringUtils.isBlank((String)filter.getSkills()) ? null : filter.getSkills().replace("*", "");
        if (StringUtils.isNotBlank(skills)) {
            if (esExp.length() > 0) {
                esExp.append(" AND ");
            }
            esExp.append("skills:").append("*").append(ProfileSearchConnector.removeAccents(skills)).append("*");
        }
        String string3 = position = StringUtils.isBlank((String)filter.getPosition()) ? null : filter.getPosition().replace("*", "");
        if (StringUtils.isNotBlank(position)) {
            if (esExp.length() > 0) {
                esExp.append(" AND ");
            }
            esExp.append("position:").append("*").append(ProfileSearchConnector.removeAccents(position)).append("*");
        }
        return esExp.toString();
    }

    private static String removeAccents(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        return string;
    }
}

