/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.LockModeType;
import org.apache.commons.lang.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.activity.filter.ActivityUpdateFilter;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ActivityStreamImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure1;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure11;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure13;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure15;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure17;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure19;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure21;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure23;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure25;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure27;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure29;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure3;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure31;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure33;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure35;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure37;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure39;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure41;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure43;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure45;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure5;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure7;
import org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl$AjcClosure9;
import org.exoplatform.social.core.jpa.storage.dao.ActivityDAO;
import org.exoplatform.social.core.jpa.storage.dao.ConnectionDAO;
import org.exoplatform.social.core.jpa.storage.dao.StreamItemDAO;
import org.exoplatform.social.core.jpa.storage.entity.ActivityEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamItemEntity;
import org.exoplatform.social.core.jpa.storage.entity.StreamType;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;
import org.exoplatform.social.core.storage.api.SpaceStorage;
import org.exoplatform.social.core.storage.impl.ActivityBuilderWhere;
import org.exoplatform.social.core.storage.impl.ActivityStorageImpl;

public class RDBMSActivityStorageImpl
extends ActivityStorageImpl {
    private static final Log LOG;
    private final ActivityDAO activityDAO;
    private final StreamItemDAO streamItemDAO;
    private IdentityStorage identityStorage;
    private final SpaceStorage spaceStorage;
    private final SortedSet<ActivityProcessor> activityProcessors;
    private static final Pattern MENTION_PATTERN;
    public static final String COMMENT_PREFIX = "comment";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;

    public RDBMSActivityStorageImpl(RelationshipStorage relationshipStorage, IdentityStorage identityStorage, SpaceStorage spaceStorage, ActivityDAO activityDAO, ConnectionDAO connectionDAO, StreamItemDAO streamItemDAO) {
        super(relationshipStorage, identityStorage, spaceStorage);
        this.identityStorage = identityStorage;
        this.activityProcessors = new TreeSet<ActivityProcessor>(RDBMSActivityStorageImpl.processorComparator());
        this.activityDAO = activityDAO;
        this.streamItemDAO = streamItemDAO;
        this.spaceStorage = spaceStorage;
    }

    private static Comparator<ActivityProcessor> processorComparator() {
        return new Comparator<ActivityProcessor>(){

            @Override
            public int compare(ActivityProcessor p1, ActivityProcessor p2) {
                if (p1 == null || p2 == null) {
                    throw new IllegalArgumentException("Cannot compare null ActivityProcessor");
                }
                return p1.getPriority() - p2.getPriority();
            }
        };
    }

    public void addPlugin(BaseComponentPlugin baseComponent) {
        super.addPlugin(baseComponent);
    }

    public void setInjectStreams(boolean mustInject) {
        super.setInjectStreams(mustInject);
    }

    private ExoSocialActivity fillActivityFromEntity(ActivityEntity activityEntity, ExoSocialActivity activity) {
        if (activity == null) {
            activity = new ExoSocialActivityImpl(activityEntity.getPosterId(), activityEntity.getType(), activityEntity.getTitle(), activityEntity.getBody(), false);
        } else {
            activity.setPosterId(activityEntity.getPosterId());
            activity.setType(activityEntity.getType());
            activity.setTitle(activity.getTitle());
            activity.setBody(activity.getBody());
            activity.isComment(false);
        }
        activity.setId(String.valueOf(activityEntity.getId()));
        activity.setLikeIdentityIds(activityEntity.getLikerIds().toArray(new String[0]));
        activity.setTemplateParams((Map)(activityEntity.getTemplateParams() != null ? new LinkedHashMap<String, String>(activityEntity.getTemplateParams()) : new HashMap()));
        String ownerIdentityId = activityEntity.getOwnerId();
        ActivityStreamImpl stream = new ActivityStreamImpl();
        Identity owner = this.identityStorage.findIdentityById(ownerIdentityId);
        stream.setType(owner.getProviderId());
        stream.setPrettyId(owner.getRemoteId());
        stream.setId(owner.getId());
        activity.setActivityStream((ActivityStream)stream);
        activity.setStreamOwner(owner.getRemoteId());
        activity.setPosterId(activityEntity.getPosterId());
        activity.isLocked(activityEntity.getLocked().booleanValue());
        activity.isHidden(activityEntity.getHidden().booleanValue());
        activity.setTitleId(activityEntity.getTitleId());
        activity.setPostedTime(Long.valueOf(activityEntity.getPosted() != null ? activityEntity.getPosted().getTime() : 0L));
        activity.setUpdated(Long.valueOf(activityEntity.getUpdatedDate().getTime()));
        ArrayList<String> commentIds = new ArrayList<String>();
        ArrayList<String> replyToIds = new ArrayList<String>();
        ArrayList comments = activityEntity.getComments() != null ? activityEntity.getComments() : new ArrayList();
        for (ActivityEntity comment : comments) {
            if (!commentIds.contains(comment.getPosterId())) {
                commentIds.add(comment.getPosterId());
            }
            replyToIds.add(this.getExoCommentID(comment.getId()));
        }
        activity.setCommentedIds(commentIds.toArray(new String[commentIds.size()]));
        activity.setReplyToId(replyToIds.toArray(new String[replyToIds.size()]));
        activity.setMentionedIds(activityEntity.getMentionerIds().toArray(new String[activityEntity.getMentionerIds().size()]));
        return activity;
    }

    private ExoSocialActivity convertActivityEntityToActivity(ActivityEntity activityEntity) {
        if (activityEntity == null) {
            return null;
        }
        ExoSocialActivity activity = this.fillActivityFromEntity(activityEntity, null);
        this.processActivity(activity);
        return activity;
    }

    private ActivityEntity convertActivityToActivityEntity(ExoSocialActivity activity, String ownerId) {
        Map params;
        ActivityEntity activityEntity = new ActivityEntity();
        if (activity.getId() != null) {
            activityEntity = (ActivityEntity)this.activityDAO.find(Long.valueOf(activity.getId()));
        }
        activityEntity.setTitle(activity.getTitle());
        activityEntity.setTitleId(activity.getTitleId());
        activityEntity.setType(activity.getType());
        activityEntity.setBody(activity.getBody());
        if (ownerId != null) {
            activityEntity.setPosterId(activity.getUserId() != null ? activity.getUserId() : ownerId);
        }
        if (activity.getLikeIdentityIds() != null) {
            activityEntity.setLikerIds(new HashSet<String>(Arrays.asList(activity.getLikeIdentityIds())));
        }
        if ((params = activity.getTemplateParams()) != null) {
            for (Map.Entry param : params.entrySet()) {
                String key = (String)param.getKey();
                String string = (String)param.getValue();
            }
            activityEntity.setTemplateParams(params);
        }
        if (activity.getPostedTime() == null || activity.getPostedTime() <= 0L) {
            activity.setPostedTime(Long.valueOf(System.currentTimeMillis()));
        }
        activityEntity.setPosted(new Date(activity.getPostedTime()));
        activityEntity.setLocked(activity.isLocked());
        activityEntity.setHidden(activity.isHidden());
        activityEntity.setUpdatedDate(activity.getUpdated());
        activityEntity.setMentionerIds(new HashSet<String>(Arrays.asList(this.processMentions(activity.getTitle()))));
        return activityEntity;
    }

    private ExoSocialActivity convertCommentEntityToComment(ActivityEntity comment) {
        ExoSocialActivityImpl exoComment = new ExoSocialActivityImpl(comment.getPosterId(), null, comment.getTitle(), comment.getBody(), false);
        exoComment.setId(this.getExoCommentID(comment.getId()));
        exoComment.setTitle(comment.getTitle());
        exoComment.setType(comment.getType());
        exoComment.setTitleId(comment.getTitleId());
        exoComment.setBody(comment.getBody());
        exoComment.setTemplateParams((Map)(comment.getTemplateParams() != null ? new LinkedHashMap<String, String>(comment.getTemplateParams()) : new HashMap()));
        exoComment.setPosterId(comment.getPosterId());
        exoComment.isComment(true);
        exoComment.isLocked(comment.getLocked().booleanValue());
        exoComment.isHidden(comment.getHidden().booleanValue());
        exoComment.setUpdated(Long.valueOf(comment.getUpdatedDate().getTime()));
        exoComment.setParentId(String.valueOf(comment.getParent().getId()));
        exoComment.setPostedTime(Long.valueOf(comment.getPosted() != null ? comment.getPosted().getTime() : 0L));
        exoComment.setUpdated(Long.valueOf(comment.getUpdatedDate().getTime()));
        Set<String> mentioned = comment.getMentionerIds();
        if (mentioned != null && !mentioned.isEmpty()) {
            exoComment.setMentionedIds(comment.getMentionerIds().toArray(new String[mentioned.size()]));
        }
        this.processActivity((ExoSocialActivity)exoComment);
        return exoComment;
    }

    private List<ExoSocialActivity> convertCommentEntitiesToComments(List<ActivityEntity> comments) {
        ArrayList<ExoSocialActivity> exoSocialActivities = new ArrayList<ExoSocialActivity>();
        if (comments == null) {
            return exoSocialActivities;
        }
        for (ActivityEntity comment : comments) {
            exoSocialActivities.add(this.convertCommentEntityToComment(comment));
        }
        return exoSocialActivities;
    }

    private ActivityEntity convertCommentToCommentEntity(ExoSocialActivity comment) {
        ActivityEntity commentEntity = new ActivityEntity();
        if (comment.getId() != null) {
            commentEntity = (ActivityEntity)this.activityDAO.find(this.getCommentID(comment.getId()));
        }
        commentEntity.setComment(true);
        commentEntity.setTitle(comment.getTitle());
        commentEntity.setTitleId(comment.getTitleId());
        commentEntity.setType(comment.getType());
        commentEntity.setBody(comment.getBody());
        commentEntity.setPosterId(comment.getPosterId() != null ? comment.getPosterId() : comment.getUserId());
        if (comment.getTemplateParams() != null) {
            commentEntity.setTemplateParams(comment.getTemplateParams());
        }
        commentEntity.setLocked(comment.isLocked());
        commentEntity.setHidden(comment.isHidden());
        Date commentTime = comment.getPostedTime() != null ? new Date(comment.getPostedTime()) : new Date();
        commentEntity.setPosted(commentTime);
        commentEntity.setUpdatedDate(commentTime);
        commentEntity.setMentionerIds(new HashSet<String>(Arrays.asList(this.processMentions(comment.getTitle()))));
        return commentEntity;
    }

    private List<ExoSocialActivity> convertActivityEntitiesToActivities(List<ActivityEntity> activities) {
        ArrayList<ExoSocialActivity> exoSocialActivities = new ArrayList<ExoSocialActivity>();
        if (activities == null) {
            return exoSocialActivities;
        }
        for (ActivityEntity activity : activities) {
            exoSocialActivities.add(this.convertActivityEntityToActivity(activity));
        }
        return exoSocialActivities;
    }

    @ExoTransactional
    public ExoSocialActivity getActivity(String activityId) throws ActivityStorageException {
        String string = activityId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (ExoSocialActivity)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public ExoSocialActivity getComment(String commentId) throws ActivityStorageException {
        try {
            ActivityEntity entity = (ActivityEntity)this.activityDAO.find(this.getCommentID(commentId));
            return this.convertCommentEntityToComment(entity);
        }
        catch (Exception e) {
            if (PropertyManager.isDevelopping()) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public List<ExoSocialActivity> getUserActivities(Identity owner) throws ActivityStorageException {
        return this.getUserActivities(owner, 0L, -1L);
    }

    public List<ExoSocialActivity> getUserActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.getUserActivitiesForUpgrade(owner, offset, limit);
    }

    public List<String> getUserSpacesActivityIds(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getUserSpacesActivityIds(ownerIdentity, offset, limit, this.memberOfSpaceIds(ownerIdentity));
    }

    public List<String> getUserIdsActivities(Identity owner, long offset, long limit) throws ActivityStorageException {
        return this.activityDAO.getUserIdsActivities(owner, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getUserActivitiesForUpgrade(Identity owner, long offset, long limit) throws ActivityStorageException {
        Identity identity = owner;
        long l = offset;
        long l2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivities(Identity owner, Identity viewer, long offset, long limit) throws ActivityStorageException {
        Identity identity = owner;
        Identity identity2 = viewer;
        long l = offset;
        long l2 = limit;
        Object[] objectArray = new Object[]{identity, identity2, Conversions.longObject((long)l), Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, identity2, Conversions.longObject((long)l), Conversions.longObject((long)l2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void saveComment(ExoSocialActivity activity, ExoSocialActivity eXoComment) throws ActivityStorageException {
        ExoSocialActivity exoSocialActivity = activity;
        ExoSocialActivity exoSocialActivity2 = eXoComment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)exoSocialActivity, (Object)exoSocialActivity2);
        Object[] objectArray = new Object[]{this, exoSocialActivity, exoSocialActivity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void saveStreamItemForCommenter(Identity commenter, ActivityEntity activityEntity) {
        Identity ownerActivity = this.identityStorage.findIdentityById(activityEntity.getOwnerId());
        if (!"space".equals(ownerActivity.getProviderId())) {
            this.createStreamItem(StreamType.COMMENTER, activityEntity, Long.parseLong(commenter.getId()));
        }
    }

    private Set<String> processMentionOfComment(ActivityEntity activityEntity, ActivityEntity commentEntity, String[] activityMentioners, String[] commentMentioners, boolean isAdded) {
        HashSet<String> mentioners = new HashSet<String>(Arrays.asList(activityMentioners));
        if (commentMentioners.length == 0) {
            return mentioners;
        }
        for (String mentioner : commentMentioners) {
            if (!mentioners.contains(mentioner) && isAdded) {
                mentioners.add(mentioner);
            }
            if (!mentioners.contains(mentioner) || isAdded || !this.isAllowedToRemove(activityEntity, commentEntity, mentioner)) continue;
            mentioners.remove(mentioner);
            StreamItemEntity item = new StreamItemEntity(StreamType.MENTIONER);
            item.setOwnerId(Long.parseLong(mentioner));
            activityEntity.removeStreamItem(item);
        }
        return mentioners;
    }

    private boolean isAllowedToRemove(ActivityEntity activity, ActivityEntity comment, String mentioner) {
        if (ArrayUtils.contains((Object[])this.processMentions(activity.getTitle()), (Object)mentioner)) {
            return false;
        }
        List<ActivityEntity> comments = activity.getComments();
        comments.remove(comment);
        for (ActivityEntity cmt : comments) {
            if (!ArrayUtils.contains((Object[])this.processMentions(cmt.getTitle()), (Object)mentioner)) continue;
            return false;
        }
        return true;
    }

    public ExoSocialActivity saveActivity(Identity owner, ExoSocialActivity activity) throws ActivityStorageException {
        boolean isNew = activity.getId() == null;
        ActivityEntity entity = this.convertActivityToActivityEntity(activity, owner.getId());
        entity.setOwnerId(owner.getId());
        entity.setProviderId(owner.getProviderId());
        this.saveStreamItem(owner, entity);
        entity = (ActivityEntity)this.activityDAO.create(entity);
        activity.setId(Long.toString(entity.getId()));
        if (isNew) {
            this.fillActivityFromEntity(entity, activity);
        }
        return activity;
    }

    private void spaceMembers(Identity spaceOwner, ActivityEntity activity) {
        this.createStreamItem(StreamType.SPACE, activity, Long.parseLong(spaceOwner.getId()));
        this.createStreamItem(StreamType.SPACE, activity, Long.parseLong(activity.getPosterId()));
    }

    private void saveStreamItem(Identity owner, ActivityEntity activity) {
        if ("organization".equals(owner.getProviderId())) {
            this.poster(owner, activity);
        } else {
            this.spaceMembers(owner, activity);
        }
        this.mention(owner, activity, this.processMentions(activity.getTitle()));
    }

    private void poster(Identity owner, ActivityEntity activity) {
        this.createStreamItem(StreamType.POSTER, activity, Long.parseLong(activity.getPosterId()));
        if (!owner.getId().equals(activity.getPosterId())) {
            this.createStreamItem(StreamType.POSTER, activity, Long.parseLong(owner.getId()));
        }
    }

    private void mention(Identity owner, ActivityEntity activity, String[] mentions) {
        for (String mentioner : mentions) {
            Identity identity = this.identityStorage.findIdentityById(mentioner);
            if (identity == null) continue;
            this.createStreamItem(StreamType.MENTIONER, activity, Long.parseLong(identity.getId()));
        }
    }

    private void createStreamItem(StreamType streamType, ActivityEntity activity, Long ownerId) {
        StreamItemEntity streamItem = new StreamItemEntity(streamType);
        streamItem.setOwnerId(ownerId);
        streamItem.setUpdatedDate(activity.getUpdatedDate());
        boolean isExist = false;
        if (activity.getId() != null) {
            for (StreamItemEntity item : activity.getStreamItems()) {
                if (!item.getOwnerId().equals(ownerId) || !streamType.equals((Object)item.getStreamType())) continue;
                isExist = true;
                break;
            }
        }
        if (!isExist) {
            activity.addStreamItem(streamItem);
        }
    }

    private String[] processMentions(String title) {
        if (title == null || title.length() == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        HashSet<String> mentions = new HashSet<String>();
        Matcher matcher = MENTION_PATTERN.matcher(title);
        while (matcher.find()) {
            String remoteId = matcher.group().substring(1);
            Identity identity = this.identityStorage.findIdentity("organization", remoteId);
            if (identity == null || mentions.contains(identity.getId())) continue;
            mentions.add(identity.getId());
        }
        return mentions.toArray(new String[mentions.size()]);
    }

    @ExoTransactional
    public ExoSocialActivity getParentActivity(ExoSocialActivity comment) throws ActivityStorageException {
        ExoSocialActivity exoSocialActivity = comment;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)exoSocialActivity);
        Object[] objectArray = new Object[]{this, exoSocialActivity, joinPoint};
        return (ExoSocialActivity)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void deleteActivity(String activityId) throws ActivityStorageException {
        ActivityEntity a = (ActivityEntity)this.activityDAO.find(Long.valueOf(activityId));
        if (a != null) {
            this.activityDAO.delete(a);
        } else {
            LOG.warn((Object)("The activity's " + activityId + " is not found!"));
        }
    }

    @ExoTransactional
    public void deleteComment(String activityId, String commentId) throws ActivityStorageException {
        String string = activityId;
        String string2 = commentId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean hasOtherComment(ActivityEntity activity, String poster) {
        for (ActivityEntity comment : activity.getComments()) {
            if (!poster.equals(comment.getPosterId())) continue;
            return true;
        }
        return false;
    }

    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> connectionList, long offset, long limit) throws ActivityStorageException {
        return null;
    }

    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> connectionList, ActivityStorage.TimestampType type, long offset, long limit) throws ActivityStorageException {
        return null;
    }

    public int getNumberOfUserActivities(Identity owner) throws ActivityStorageException {
        return this.getNumberOfUserActivitiesForUpgrade(owner);
    }

    public int getNumberOfUserActivitiesForUpgrade(Identity owner) throws ActivityStorageException {
        return this.activityDAO.getNumberOfUserActivities(owner);
    }

    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnUserActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerUserActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnUserActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnUserActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderUserActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getActivityFeed(Identity ownerIdentity, int offset, int limit) {
        return this.getActivityFeedForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getActivityIdsFeed(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getActivityIdsFeed(ownerIdentity, offset, limit, this.memberOfSpaceIds(ownerIdentity));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivityFeedForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfActivitesOnActivityFeed(Identity ownerIdentity) {
        return this.getNumberOfActivitesOnActivityFeedForUpgrade(ownerIdentity);
    }

    public int getNumberOfActivitesOnActivityFeedForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfActivitesOnActivityFeed(ownerIdentity, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnActivityFeed(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerFeedActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnActivityFeed(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnActivityFeed(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderFeedActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getActivitiesOfConnections(Identity ownerIdentity, int offset, int limit) {
        return this.getActivitiesOfConnectionsForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getActivityIdsOfConnections(Identity ownerIdentity, int offset, int limit) {
        return this.activityDAO.getActivityIdsOfConnections(ownerIdentity, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getActivitiesOfConnectionsForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfActivitiesOfConnections(Identity ownerIdentity) {
        return this.getNumberOfActivitiesOfConnectionsForUpgrade(ownerIdentity);
    }

    public int getNumberOfActivitiesOfConnectionsForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfActivitiesOfConnections(ownerIdentity);
    }

    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity ownerIdentity, long offset, long limit) {
        return this.getUserActivities(ownerIdentity, offset, limit);
    }

    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, long limit) {
        return this.getNewerActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime(), (int)limit);
    }

    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderActivitiesOfConnections(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getUserSpacesActivities(Identity ownerIdentity, int offset, int limit) {
        return this.getUserSpacesActivitiesForUpgrade(ownerIdentity, offset, limit);
    }

    public List<String> getSpaceActivityIds(Identity spaceIdentity, int offset, int limit) {
        return this.activityDAO.getSpaceActivityIds(spaceIdentity, offset, limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getUserSpacesActivitiesForUpgrade(Identity ownerIdentity, int offset, int limit) {
        Identity identity = ownerIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure17(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfUserSpacesActivities(Identity ownerIdentity) {
        return this.getNumberOfUserSpacesActivitiesForUpgrade(ownerIdentity);
    }

    public int getNumberOfUserSpacesActivitiesForUpgrade(Identity ownerIdentity) {
        return this.activityDAO.getNumberOfUserSpacesActivities(ownerIdentity, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(Identity ownerIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderUserSpacesActivities(ownerIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public List<ExoSocialActivity> getComments(ExoSocialActivity existingActivity, int offset, int limit) {
        long activityId = 0L;
        try {
            activityId = Long.parseLong(existingActivity.getId());
        }
        catch (NumberFormatException ex) {
            activityId = 0L;
        }
        List<ActivityEntity> comments = activityId > 0L ? this.activityDAO.getComments(activityId, offset, limit) : null;
        return this.convertCommentEntitiesToComments(comments);
    }

    public int getNumberOfComments(ExoSocialActivity existingActivity) {
        return (int)this.activityDAO.getNumberOfComments(Long.valueOf(existingActivity.getId()));
    }

    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.getNewerComments(existingActivity, baseComment, 0).size();
    }

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.getNewerComments(existingActivity, baseComment.getPostedTime(), limit);
    }

    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment) {
        return this.getOlderComments(existingActivity, baseComment, 0).size();
    }

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, ExoSocialActivity baseComment, int limit) {
        return this.getOlderComments(existingActivity, baseComment.getPostedTime(), limit);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity existingActivity, Long sinceTime, int limit) {
        ExoSocialActivity exoSocialActivity = existingActivity;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{exoSocialActivity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, exoSocialActivity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity existingActivity, Long sinceTime, int limit) {
        ExoSocialActivity exoSocialActivity = existingActivity;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{exoSocialActivity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, exoSocialActivity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfNewerComments(ExoSocialActivity existingActivity, Long sinceTime) {
        return this.getNewerComments(existingActivity, sinceTime, 0).size();
    }

    public int getNumberOfOlderComments(ExoSocialActivity existingActivity, Long sinceTime) {
        return this.getOlderComments(existingActivity, sinceTime, 0).size();
    }

    public SortedSet<ActivityProcessor> getActivityProcessors() {
        return this.activityProcessors;
    }

    public void updateActivity(ExoSocialActivity existingActivity) throws ActivityStorageException {
        if (existingActivity == null) {
            throw new IllegalArgumentException("Activity to update cannot be null");
        }
        ActivityEntity updatedActivity = null;
        if (existingActivity.getId().startsWith(COMMENT_PREFIX)) {
            String id = existingActivity.getId().replace(COMMENT_PREFIX, "");
            updatedActivity = (ActivityEntity)this.activityDAO.find(Long.valueOf(id));
        } else {
            updatedActivity = (ActivityEntity)this.activityDAO.find(Long.valueOf(existingActivity.getId()));
        }
        if (updatedActivity != null) {
            if (existingActivity.getId().startsWith(COMMENT_PREFIX)) {
                updatedActivity.setUpdatedDate(new Date());
            } else {
                this.processLikerActivityInStreams(new HashSet<String>(Arrays.asList(existingActivity.getLikeIdentityIds())), new HashSet<String>(updatedActivity.getLikerIds()), updatedActivity);
            }
            if (existingActivity.getTitleId() != null) {
                updatedActivity.setTitleId(existingActivity.getTitleId());
            }
            if (existingActivity.getTitle() != null) {
                updatedActivity.setTitle(existingActivity.getTitle());
            }
            if (existingActivity.getBody() != null) {
                updatedActivity.setBody(existingActivity.getBody());
            }
            if (existingActivity.getLikeIdentityIds() != null) {
                updatedActivity.setLikerIds(new HashSet<String>(Arrays.asList(existingActivity.getLikeIdentityIds())));
            }
            if (existingActivity.getMentionedIds() != null) {
                updatedActivity.setMentionerIds(new HashSet<String>(Arrays.asList(existingActivity.getMentionedIds())));
            }
            if (existingActivity.getPermaLink() != null) {
                updatedActivity.setPermaLink(existingActivity.getPermaLink());
            }
            if (existingActivity.getTemplateParams() != null) {
                updatedActivity.setTemplateParams(existingActivity.getTemplateParams());
            }
        } else {
            throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_UPDATE_ACTIVITY, "Cannot find activity with id=" + existingActivity.getId());
        }
        updatedActivity.setHidden(existingActivity.isHidden());
        updatedActivity.setComment(existingActivity.isComment());
        updatedActivity.setLocked(existingActivity.isLocked());
        this.activityDAO.update(updatedActivity);
    }

    private void processLikerActivityInStreams(Set<String> newLikerList, Set<String> oldLikerList, ActivityEntity activity) {
        for (String id : newLikerList) {
            if (!oldLikerList.contains(id)) {
                this.createStreamItem(StreamType.LIKER, activity, Long.parseLong(id));
                continue;
            }
            oldLikerList.remove(id);
        }
        if (oldLikerList.size() > 0) {
            for (String id : oldLikerList) {
                StreamItemEntity item = new StreamItemEntity(StreamType.LIKER);
                item.setOwnerId(Long.parseLong(id));
                activity.removeStreamItem(item);
            }
        }
    }

    public int getNumberOfNewerOnActivityFeed(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnActivityFeed(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfNewerOnUserActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnUserActivities(ownerIdentity, sinceTime);
    }

    public int getNumberOfNewerOnActivitiesOfConnections(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnActivitiesOfConnections(ownerIdentity, sinceTime);
    }

    public int getNumberOfNewerOnUserSpacesActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnUserSpacesActivities(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public List<ExoSocialActivity> getActivitiesOfIdentities(ActivityBuilderWhere where, ActivityFilter filter, long offset, long limit) throws ActivityStorageException {
        return null;
    }

    public int getNumberOfSpaceActivities(Identity spaceIdentity) {
        return this.getNumberOfSpaceActivitiesForUpgrade(spaceIdentity);
    }

    public int getNumberOfSpaceActivitiesForUpgrade(Identity spaceIdentity) {
        return this.activityDAO.getNumberOfSpaceActivities(spaceIdentity);
    }

    @ExoTransactional
    public List<ExoSocialActivity> getSpaceActivities(Identity spaceIdentity, int offset, int limit) {
        Identity identity = spaceIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure23(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getSpaceActivitiesForUpgrade(Identity spaceIdentity, int offset, int limit) {
        Identity identity = spaceIdentity;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{identity, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure25(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public List<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity, int offset, int limit) {
        return this.getActivitiesByPoster(posterIdentity, offset, limit, new String[0]);
    }

    public List<ExoSocialActivity> getActivitiesByPoster(Identity posterIdentity, int offset, int limit, String ... activityTypes) {
        return this.convertActivityEntitiesToActivities(this.activityDAO.getActivitiesByPoster(posterIdentity, offset, limit, activityTypes));
    }

    public int getNumberOfActivitiesByPoster(Identity posterIdentity) {
        return this.activityDAO.getNumberOfActivitiesByPoster(posterIdentity, new String[0]);
    }

    public int getNumberOfActivitiesByPoster(Identity ownerIdentity, Identity viewerIdentity) {
        return 0;
    }

    public List<ExoSocialActivity> getNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getNewerSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfNewerOnSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime());
    }

    public List<ExoSocialActivity> getOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity, int limit) {
        return this.getOlderSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime(), limit);
    }

    public int getNumberOfOlderOnSpaceActivities(Identity spaceIdentity, ExoSocialActivity baseActivity) {
        return this.getNumberOfOlderOnSpaceActivities(spaceIdentity, baseActivity.getUpdated().getTime());
    }

    public int getNumberOfNewerOnSpaceActivities(Identity spaceIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfNewerOnSpaceActivities(spaceIdentity, sinceTime);
    }

    public int getNumberOfUpdatedOnActivityFeed(Identity owner, ActivityUpdateFilter filter) {
        return 0;
    }

    public int getNumberOfUpdatedOnUserActivities(Identity owner, ActivityUpdateFilter filter) {
        return 0;
    }

    public int getNumberOfUpdatedOnActivitiesOfConnections(Identity owner, ActivityUpdateFilter filter) {
        return 0;
    }

    public int getNumberOfUpdatedOnUserSpacesActivities(Identity owner, ActivityUpdateFilter filter) {
        return 0;
    }

    public int getNumberOfUpdatedOnSpaceActivities(Identity owner, ActivityUpdateFilter filter) {
        return 0;
    }

    public int getNumberOfMultiUpdated(Identity owner, Map<String, Long> sinceTimes) {
        return 0;
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerFeedActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure27(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerUserActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure29(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerUserSpacesActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure31(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerActivitiesOfConnections(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure33(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getNewerSpaceActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure35(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderFeedActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure37(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderUserActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure39(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderUserSpacesActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_20, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure41(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderActivitiesOfConnections(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_21, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure43(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<ExoSocialActivity> getOlderSpaceActivities(Identity owner, Long sinceTime, int limit) {
        Identity identity = owner;
        Long l = sinceTime;
        int n = limit;
        Object[] objectArray = new Object[]{identity, l, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_22, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, identity, l, Conversions.intObject((int)n), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new RDBMSActivityStorageImpl$AjcClosure45(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int getNumberOfOlderOnActivityFeed(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnActivityFeed(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfOlderOnUserActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnUserActivities(ownerIdentity, sinceTime);
    }

    public int getNumberOfOlderOnActivitiesOfConnections(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnActivitiesOfConnections(ownerIdentity, sinceTime);
    }

    public int getNumberOfOlderOnUserSpacesActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnUserSpacesActivities(ownerIdentity, sinceTime, this.memberOfSpaceIds(ownerIdentity));
    }

    public int getNumberOfOlderOnSpaceActivities(Identity ownerIdentity, Long sinceTime) {
        return this.activityDAO.getNumberOfOlderOnSpaceActivities(ownerIdentity, sinceTime);
    }

    private Long getCommentID(String commentId) {
        return commentId == null || commentId.trim().isEmpty() ? null : Long.valueOf(commentId.replace(COMMENT_PREFIX, ""));
    }

    private String getExoCommentID(Long commentId) {
        return String.valueOf(COMMENT_PREFIX + commentId);
    }

    private void processActivity(ExoSocialActivity existingActivity) {
        Iterator it = this.activityProcessors.iterator();
        while (it.hasNext()) {
            try {
                ((ActivityProcessor)it.next()).processActivity(existingActivity);
            }
            catch (Exception e) {
                LOG.debug((Object)"activity processing failed ");
            }
        }
    }

    private List<String> memberOfSpaceIds(Identity ownerIdentity) {
        return this.spaceStorage.getMemberSpaceIds(ownerIdentity.getId(), 0, -1);
    }

    public void setIdentityStorage(IdentityStorage identityStorage) {
        this.identityStorage = identityStorage;
    }

    static {
        RDBMSActivityStorageImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(RDBMSActivityStorageImpl.class);
        MENTION_PATTERN = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
    }

    static /* synthetic */ ExoSocialActivity getActivity_aroundBody0(RDBMSActivityStorageImpl ajc$this, String activityId, JoinPoint joinPoint) {
        if (activityId == null || activityId.isEmpty()) {
            return null;
        }
        if (activityId != null && activityId.startsWith(COMMENT_PREFIX)) {
            return ajc$this.getComment(activityId);
        }
        try {
            ActivityEntity entity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activityId));
            return ajc$this.convertActivityEntityToActivity(entity);
        }
        catch (Exception e) {
            if (PropertyManager.isDevelopping()) {
                throw new ActivityStorageException(ActivityStorageException.Type.FAILED_TO_GET_ACTIVITY, e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    static /* synthetic */ List getUserActivitiesForUpgrade_aroundBody2(RDBMSActivityStorageImpl ajc$this, Identity owner, long offset, long limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getUserActivities(owner, offset, limit));
    }

    static /* synthetic */ List getActivities_aroundBody4(RDBMSActivityStorageImpl ajc$this, Identity owner, Identity viewer, long offset, long limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getActivities(owner, viewer, offset, limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void saveComment_aroundBody6(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity activity, ExoSocialActivity eXoComment, JoinPoint joinPoint) {
        ActivityEntity activityEntity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activity.getId()));
        try {
            EntityManagerHolder.get().lock((Object)activityEntity, LockModeType.PESSIMISTIC_WRITE);
            ActivityEntity commentEntity = ajc$this.convertCommentToCommentEntity(eXoComment);
            commentEntity.setParent(activityEntity);
            commentEntity = (ActivityEntity)ajc$this.activityDAO.create(commentEntity);
            activityEntity.addComment(commentEntity);
            eXoComment.setId(ajc$this.getExoCommentID(commentEntity.getId()));
            eXoComment.setPosterId(commentEntity.getPosterId());
            eXoComment.setParentId(String.valueOf(commentEntity.getParent().getId()));
            Set<String> mentioned = commentEntity.getMentionerIds();
            if (mentioned != null && !mentioned.isEmpty()) {
                eXoComment.setMentionedIds(mentioned.toArray(new String[mentioned.size()]));
            }
            Identity commenter = ajc$this.identityStorage.findIdentityById(commentEntity.getPosterId());
            ajc$this.saveStreamItemForCommenter(commenter, activityEntity);
            String[] mentioners = ajc$this.processMentions(eXoComment.getTitle());
            if (mentioners != null && mentioners.length > 0) {
                ajc$this.mention(commenter, activityEntity, mentioners);
                activityEntity.setMentionerIds(ajc$this.processMentionOfComment(activityEntity, commentEntity, activity.getMentionedIds(), mentioners, true));
            }
            if (eXoComment.getUpdated() != null) {
                activityEntity.setUpdatedDate(eXoComment.getUpdated());
            } else {
                activityEntity.setUpdatedDate(new Date());
            }
            ajc$this.activityDAO.update(activityEntity);
        }
        finally {
            EntityManagerHolder.get().lock((Object)activityEntity, LockModeType.NONE);
        }
    }

    static /* synthetic */ ExoSocialActivity getParentActivity_aroundBody8(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity comment, JoinPoint joinPoint) {
        try {
            Long commentId = ajc$this.getCommentID(comment.getId());
            return ajc$this.convertActivityEntityToActivity(ajc$this.activityDAO.getParentActivity(commentId));
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"The input ExoSocialActivity is not comment, it is Activity");
            return null;
        }
    }

    static /* synthetic */ void deleteComment_aroundBody10(RDBMSActivityStorageImpl ajc$this, String activityId, String commentId, JoinPoint joinPoint) {
        ActivityEntity comment = (ActivityEntity)ajc$this.activityDAO.find(ajc$this.getCommentID(commentId));
        ajc$this.activityDAO.delete(comment);
        ActivityEntity activity = (ActivityEntity)ajc$this.activityDAO.find(Long.valueOf(activityId));
        activity.getComments().remove(comment);
        activity.setMentionerIds(ajc$this.processMentionOfComment(activity, comment, activity.getMentionerIds().toArray(new String[activity.getMentionerIds().size()]), ajc$this.processMentions(comment.getTitle()), false));
        if (!ajc$this.hasOtherComment(activity, comment.getPosterId())) {
            StreamItemEntity item = new StreamItemEntity(StreamType.COMMENTER);
            item.setOwnerId(Long.parseLong(comment.getPosterId()));
            activity.removeStreamItem(item);
        }
        ajc$this.activityDAO.update(activity);
    }

    static /* synthetic */ List getActivityFeedForUpgrade_aroundBody12(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getActivityFeed(ownerIdentity, offset, limit, ajc$this.memberOfSpaceIds(ownerIdentity)));
    }

    static /* synthetic */ List getActivitiesOfConnectionsForUpgrade_aroundBody14(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getActivitiesOfConnections(ownerIdentity, offset, limit));
    }

    static /* synthetic */ List getUserSpacesActivitiesForUpgrade_aroundBody16(RDBMSActivityStorageImpl ajc$this, Identity ownerIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getUserSpacesActivities(ownerIdentity, offset, limit, ajc$this.memberOfSpaceIds(ownerIdentity)));
    }

    static /* synthetic */ List getNewerComments_aroundBody18(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity existingActivity, Long sinceTime, int limit, JoinPoint joinPoint) {
        List<ActivityEntity> comments = ajc$this.activityDAO.getNewerComments(Long.valueOf(existingActivity.getId()), sinceTime > 0L ? new Date(sinceTime) : null, 0, limit);
        return ajc$this.convertCommentEntitiesToComments(comments);
    }

    static /* synthetic */ List getOlderComments_aroundBody20(RDBMSActivityStorageImpl ajc$this, ExoSocialActivity existingActivity, Long sinceTime, int limit, JoinPoint joinPoint) {
        List<ActivityEntity> comments = ajc$this.activityDAO.getOlderComments(Long.valueOf(existingActivity.getId()), sinceTime > 0L ? new Date(sinceTime) : null, 0, limit);
        return ajc$this.convertCommentEntitiesToComments(comments);
    }

    static /* synthetic */ List getSpaceActivities_aroundBody22(RDBMSActivityStorageImpl ajc$this, Identity spaceIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getSpaceActivities(spaceIdentity, offset, limit));
    }

    static /* synthetic */ List getSpaceActivitiesForUpgrade_aroundBody24(RDBMSActivityStorageImpl ajc$this, Identity spaceIdentity, int offset, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getSpaceActivities(spaceIdentity, offset, limit));
    }

    static /* synthetic */ List getNewerFeedActivities_aroundBody26(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getNewerOnActivityFeed(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getNewerUserActivities_aroundBody28(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getNewerOnUserActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getNewerUserSpacesActivities_aroundBody30(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getNewerOnUserSpacesActivities(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getNewerActivitiesOfConnections_aroundBody32(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getNewerOnActivitiesOfConnections(owner, sinceTime, limit));
    }

    static /* synthetic */ List getNewerSpaceActivities_aroundBody34(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getNewerOnSpaceActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderFeedActivities_aroundBody36(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getOlderOnActivityFeed(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getOlderUserActivities_aroundBody38(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getOlderOnUserActivities(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderUserSpacesActivities_aroundBody40(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getOlderOnUserSpacesActivities(owner, sinceTime, limit, ajc$this.memberOfSpaceIds(owner)));
    }

    static /* synthetic */ List getOlderActivitiesOfConnections_aroundBody42(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getOlderOnActivitiesOfConnections(owner, sinceTime, limit));
    }

    static /* synthetic */ List getOlderSpaceActivities_aroundBody44(RDBMSActivityStorageImpl ajc$this, Identity owner, Long sinceTime, int limit, JoinPoint joinPoint) {
        return ajc$this.convertActivityEntitiesToActivities(ajc$this.activityDAO.getOlderOnSpaceActivities(owner, sinceTime, limit));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RDBMSActivityStorageImpl.java", RDBMSActivityStorageImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivity", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "java.lang.String", "activityId", "org.exoplatform.social.core.storage.ActivityStorageException", "org.exoplatform.social.core.activity.model.ExoSocialActivity"), 284);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:long:long", "owner:offset:limit", "org.exoplatform.social.core.storage.ActivityStorageException", "java.util.List"), 336);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderComments", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:java.lang.Long:int", "existingActivity:sinceTime:limit", "", "java.util.List"), 840);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "spaceIdentity:offset:limit", "", "java.util.List"), 953);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSpaceActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "spaceIdentity:offset:limit", "", "java.util.List"), 959);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerFeedActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1040);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerUserActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1046);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerUserSpacesActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1052);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerActivitiesOfConnections", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1058);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1064);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderFeedActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1070);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderUserActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1076);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:org.exoplatform.social.core.identity.model.Identity:long:long", "owner:viewer:offset:limit", "org.exoplatform.social.core.storage.ActivityStorageException", "java.util.List"), 342);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderUserSpacesActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1082);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderActivitiesOfConnections", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1088);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getOlderSpaceActivities", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:java.lang.Long:int", "owner:sinceTime:limit", "", "java.util.List"), 1094);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveComment", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:org.exoplatform.social.core.activity.model.ExoSocialActivity", "activity:eXoComment", "org.exoplatform.social.core.storage.ActivityStorageException", "void"), 348);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getParentActivity", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity", COMMENT_PREFIX, "org.exoplatform.social.core.storage.ActivityStorageException", "org.exoplatform.social.core.activity.model.ExoSocialActivity"), 555);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteComment", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "java.lang.String:java.lang.String", "activityId:commentId", "org.exoplatform.social.core.storage.ActivityStorageException", "void"), 576);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivityFeedForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 655);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getActivitiesOfConnectionsForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 701);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserSpacesActivitiesForUpgrade", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.identity.model.Identity:int:int", "ownerIdentity:offset:limit", "", "java.util.List"), 752);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNewerComments", "org.exoplatform.social.core.jpa.storage.RDBMSActivityStorageImpl", "org.exoplatform.social.core.activity.model.ExoSocialActivity:java.lang.Long:int", "existingActivity:sinceTime:limit", "", "java.util.List"), 832);
    }
}

