/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity;
import org.exoplatform.social.core.jpa.storage.entity.ConnectionEntity_;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity_;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;

public final class RelationshipQueryBuilder {
    private Identity owner;
    private Identity sender;
    private Identity receiver;
    private long offset;
    private long limit;
    private Relationship.Type status = null;
    private static Collection<Relationship.Type> types = Arrays.asList(Relationship.Type.INCOMING, Relationship.Type.OUTGOING);
    private ProfileFilter profileFilter;

    public static RelationshipQueryBuilder builder() {
        return new RelationshipQueryBuilder();
    }

    public RelationshipQueryBuilder owner(Identity owner) {
        this.owner = owner;
        return this;
    }

    public RelationshipQueryBuilder sender(Identity sender) {
        this.sender = sender;
        return this;
    }

    public RelationshipQueryBuilder receiver(Identity receiver) {
        this.receiver = receiver;
        return this;
    }

    public RelationshipQueryBuilder status(Relationship.Type status) {
        this.status = status;
        return this;
    }

    public RelationshipQueryBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public RelationshipQueryBuilder limit(long limit) {
        this.limit = limit;
        return this;
    }

    public TypedQuery<ConnectionEntity> buildSingleRelationship() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ConnectionEntity.class);
        Root connection = criteria.from(ConnectionEntity.class);
        Predicate predicate = null;
        if (this.sender != null && this.receiver != null) {
            predicate = cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.sender.getId()));
            predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id), (Object)Long.valueOf(this.receiver.getId())));
        }
        CriteriaQuery select = criteria.select((Selection)connection).distinct(true);
        select.where(predicate);
        TypedQuery typedQuery = em.createQuery(select);
        return typedQuery;
    }

    public TypedQuery<ConnectionEntity> build() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ConnectionEntity.class);
        Root connection = criteria.from(ConnectionEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Path sender = connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id);
        Path receiver = connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id);
        if (this.owner != null) {
            Predicate predicate = null;
            predicate = this.status == Relationship.Type.OUTGOING ? cb.equal((Expression)sender, (Object)Long.valueOf(this.owner.getId())) : (this.status == Relationship.Type.INCOMING ? cb.equal((Expression)receiver, (Object)Long.valueOf(this.owner.getId())) : cb.or((Expression)cb.equal((Expression)sender, (Object)Long.valueOf(this.owner.getId())), (Expression)cb.equal((Expression)receiver, (Object)Long.valueOf(this.owner.getId()))));
            predicates.add(predicate);
        }
        if (this.status != null) {
            if (this.status == Relationship.Type.OUTGOING || this.status == Relationship.Type.INCOMING) {
                predicates.add(cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)Relationship.Type.PENDING));
            } else {
                predicates.add(cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)this.status));
            }
        }
        if (this.sender != null) {
            predicates.add(cb.equal((Expression)sender, (Object)Long.valueOf(this.sender.getId())));
        }
        if (this.receiver != null) {
            predicates.add(cb.equal((Expression)receiver, (Object)Long.valueOf(this.receiver.getId())));
        }
        CriteriaQuery select = criteria.select((Selection)connection).distinct(true);
        select.where(predicates.toArray(new Predicate[predicates.size()]));
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Long> buildCount() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Long.class);
        Root connection = criteria.from(ConnectionEntity.class);
        Predicate predicate = null;
        if (this.owner != null) {
            predicate = this.status == Relationship.Type.OUTGOING ? cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())) : (this.status == Relationship.Type.INCOMING ? cb.equal((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())) : cb.or((Expression)cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())), (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId()))));
        }
        if (this.status != null) {
            predicate = this.status == Relationship.Type.OUTGOING || this.status == Relationship.Type.INCOMING ? cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)Relationship.Type.PENDING)) : cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)this.status));
        }
        CriteriaQuery select = criteria.select((Selection)cb.countDistinct((Expression)connection));
        select.where(predicate);
        return em.createQuery(select);
    }

    public TypedQuery<ConnectionEntity> buildLastConnections() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ConnectionEntity.class);
        Root connection = criteria.from(ConnectionEntity.class);
        Predicate predicate = null;
        if (this.owner != null) {
            predicate = this.status == Relationship.Type.OUTGOING ? cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())) : (this.status == Relationship.Type.INCOMING ? cb.equal((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())) : cb.or((Expression)cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId())), (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId()))));
        }
        if (this.status != null) {
            predicate = this.status == Relationship.Type.OUTGOING || this.status == Relationship.Type.INCOMING ? cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)Relationship.Type.PENDING)) : cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)this.status));
        }
        CriteriaQuery select = criteria.select((Selection)connection).distinct(true);
        select.where(predicate);
        select.orderBy(new Order[]{cb.desc((Expression)connection.get(ConnectionEntity_.updatedDate))});
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<ConnectionEntity> buildFilter() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(ConnectionEntity.class);
        Root connection = criteria.from(ConnectionEntity.class);
        CriteriaQuery select = criteria.select((Selection)connection);
        select.where((Expression)this.buildPredicateFilter(cb, (Root<ConnectionEntity>)connection));
        TypedQuery typedQuery = em.createQuery(select);
        if (this.limit > 0L) {
            typedQuery.setFirstResult((int)this.offset);
            typedQuery.setMaxResults((int)this.limit);
        }
        return typedQuery;
    }

    public TypedQuery<Long> buildFilterCount() {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(Long.class);
        Root relationship = criteria.from(ConnectionEntity.class);
        CriteriaQuery select = criteria.select((Selection)cb.countDistinct((Expression)relationship));
        select.where((Expression)this.buildPredicateFilter(cb, (Root<ConnectionEntity>)relationship));
        return em.createQuery(select);
    }

    private Predicate buildPredicateFilter(CriteriaBuilder cb, Root<ConnectionEntity> connection) {
        List excludedIdentityList;
        Predicate predicate = null;
        if (this.owner != null) {
            predicate = cb.equal((Expression)connection.get(ConnectionEntity_.sender).get(IdentityEntity_.id), (Object)Long.valueOf(this.owner.getId()));
        }
        if (this.status != null) {
            predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)connection.get(ConnectionEntity_.status), (Object)this.status));
        }
        Predicate pFilter = null;
        if (this.profileFilter != null && (excludedIdentityList = this.profileFilter.getExcludedIdentityList()) != null && excludedIdentityList.size() > 0) {
            CriteriaBuilder.In in = cb.in((Expression)connection.get(ConnectionEntity_.receiver).get(IdentityEntity_.id));
            for (Identity id : excludedIdentityList) {
                in.value((Object)Long.valueOf(id.getId()));
            }
            predicate = cb.and((Expression)predicate, (Expression)in.not());
        }
        return this.appendPredicate(cb, predicate, pFilter);
    }

    public RelationshipQueryBuilder filter(ProfileFilter profileFilter) {
        this.profileFilter = profileFilter;
        return this;
    }

    private Predicate appendPredicate(CriteriaBuilder cb, Predicate pSource, Predicate input) {
        if (pSource != null) {
            if (input != null) {
                return cb.and((Expression)pSource, (Expression)input);
            }
            return pSource;
        }
        return input;
    }

    private <T> Predicate addInClause(CriteriaBuilder cb, Path<Relationship.Type> path, Collection<Relationship.Type> types) {
        CriteriaBuilder.In in = cb.in(path);
        for (Relationship.Type value : types) {
            in.value((Object)value);
        }
        return in;
    }
}

