/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater.listener;

import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SpaceActivityUpdaterListener
extends Listener<ExoSocialActivity, String> {
    private static final Log LOG = ExoLogger.getLogger(SpaceActivityUpdaterListener.class);
    private static final String SPACE_ACTIVITY_TYPE = "SPACE_ACTIVITY";

    public void onEvent(Event<ExoSocialActivity, String> event) throws Exception {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        String newActivityId = (String)event.getData();
        IdentityStorage identityStorage = (IdentityStorage)CommonsUtils.getService(IdentityStorage.class);
        if (SPACE_ACTIVITY_TYPE.equals(activity.getType())) {
            Identity spaceIdentity = identityStorage.findIdentity("space", activity.getStreamOwner());
            identityStorage.updateProfileActivityId(spaceIdentity, newActivityId, Profile.AttachedActivityType.SPACE);
            LOG.info((Object)String.format("Migration the space activity '%s' with old id's %s and new id's %s", activity.getTitle(), activity.getId(), newActivityId));
        }
    }
}

