/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public final class Crypto {
    public static final SecureRandom RAND = new SecureRandom();
    private static final String HMAC_TYPE = "HMACSHA1";
    private static final int MIN_HMAC_KEY_LEN = 8;
    private static final String CIPHER_TYPE = "AES/CBC/PKCS5Padding";
    private static final String CIPHER_KEY_TYPE = "AES";
    public static final int CIPHER_KEY_LEN = 16;
    private static final int CIPHER_BLOCK_SIZE = 16;
    public static final int HMAC_SHA1_LEN = 20;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private Crypto() {
    }

    public static String getRandomString(int numBytes) {
        return new String(Hex.encodeHex((byte[])Crypto.getRandomBytes(numBytes)));
    }

    public static String getRandomDigits(int len) {
        byte[] random = Crypto.getRandomBytes(len);
        StringBuilder out = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            out.append(DIGITS[Math.abs(random[i] % DIGITS.length)]);
        }
        return out.toString();
    }

    public static byte[] getRandomBytes(int numBytes) {
        byte[] out = new byte[numBytes];
        RAND.nextBytes(out);
        return out;
    }

    public static byte[] hmacSha1(byte[] key, byte[] in) throws GeneralSecurityException {
        if (key.length < 8) {
            throw new GeneralSecurityException("HMAC key should be at least 8 bytes.");
        }
        Mac hmac = Mac.getInstance(HMAC_TYPE);
        SecretKeySpec hmacKey = new SecretKeySpec(key, HMAC_TYPE);
        hmac.init(hmacKey);
        hmac.update(in);
        return hmac.doFinal();
    }

    public static void hmacSha1Verify(byte[] key, byte[] in, byte[] expected) throws GeneralSecurityException {
        Mac hmac = Mac.getInstance(HMAC_TYPE);
        SecretKeySpec hmacKey = new SecretKeySpec(key, HMAC_TYPE);
        hmac.init(hmacKey);
        hmac.update(in);
        byte[] actual = hmac.doFinal();
        if (actual.length != expected.length) {
            throw new GeneralSecurityException("HMAC verification failure");
        }
        for (int i = 0; i < actual.length; ++i) {
            if (actual[i] == expected[i]) continue;
            throw new GeneralSecurityException("HMAC verification failure");
        }
    }

    public static byte[] aes128cbcEncrypt(byte[] key, byte[] plain) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        byte[] iv = Crypto.getRandomBytes(cipher.getBlockSize());
        return Crypto.concat(iv, Crypto.aes128cbcEncryptWithIV(key, iv, plain));
    }

    public static byte[] aes128cbcEncryptWithIV(byte[] key, byte[] iv, byte[] plain) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        SecretKeySpec cipherKey = new SecretKeySpec(key, CIPHER_KEY_TYPE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)cipherKey, ivSpec);
        return cipher.doFinal(plain);
    }

    public static byte[] aes128cbcDecrypt(byte[] key, byte[] cipherText) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        System.arraycopy(cipherText, 0, iv, 0, iv.length);
        return Crypto.aes128cbcDecryptWithIv(key, iv, cipherText, iv.length);
    }

    public static byte[] aes128cbcDecryptWithIv(byte[] key, byte[] iv, byte[] cipherText, int offset) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
        SecretKeySpec cipherKey = new SecretKeySpec(key, CIPHER_KEY_TYPE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)cipherKey, ivSpec);
        return cipher.doFinal(cipherText, offset, cipherText.length - offset);
    }

    public static byte[] concat(byte[] a, byte[] b) {
        byte[] out = new byte[a.length + b.length];
        int cursor = 0;
        System.arraycopy(a, 0, out, cursor, a.length);
        System.arraycopy(b, 0, out, cursor += a.length, b.length);
        return out;
    }
}

