/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.Locale;
import java.util.Map;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.gatein.api.ApiException;
import org.gatein.api.PortalRequest;
import org.gatein.api.internal.Parameters;
import org.gatein.api.navigation.ApiNode;
import org.gatein.api.navigation.ApiNodeModel;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Navigation18NResolver;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.NodeVisitor;
import org.gatein.api.navigation.NodeVisitorScope;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.ObjectFactory;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;

public class NavigationImpl
implements Navigation {
    private final NavigationService navigationService;
    private final NavigationContext navCtx;
    private final DescriptionService descriptionService;
    private final ResourceBundleManager bundleManager;
    private final SiteId siteId;
    private final ApiNodeModel model;
    private Navigation18NResolver i18nResolver;

    public NavigationImpl(SiteId siteId, NavigationService navigationService, NavigationContext navCtx, DescriptionService descriptionService, ResourceBundleManager bundleManager) {
        this.siteId = siteId;
        this.navigationService = navigationService;
        this.navCtx = navCtx;
        this.descriptionService = descriptionService;
        this.bundleManager = bundleManager;
        this.model = new ApiNodeModel(this);
    }

    NavigationImpl(SiteId siteId) {
        this.siteId = siteId;
        this.navigationService = null;
        this.navCtx = null;
        this.descriptionService = null;
        this.bundleManager = null;
        this.model = null;
    }

    public boolean removeNode(NodePath path) {
        Parameters.requireNonNull((Object)path, (String)"path");
        Node parent = this.getNode(path.parent(), Nodes.visitChildren());
        if (parent == null || !parent.removeChild(path.getLastSegment())) {
            return false;
        }
        this.saveNode(parent);
        return true;
    }

    public Node getNode(String ... nodePath) {
        return this.getNode(NodePath.path((String[])nodePath));
    }

    public Node getNode(NodePath nodePath) {
        return this.getNode(nodePath, Nodes.visitNone());
    }

    public Node getNode(NodePath nodePath, NodeVisitor visitor) {
        Parameters.requireNonNull((Object)nodePath, (String)"nodePath");
        Parameters.requireNonNull((Object)visitor, (String)"visitor");
        NodeContext<ApiNode> ctx = this.getNodeContext(nodePath, visitor);
        return ctx == null ? null : (ApiNode)ctx.getNode();
    }

    public int getPriority() {
        return this.navCtx.getState().getPriority();
    }

    public SiteId getSiteId() {
        return this.siteId;
    }

    public Node getRootNode(NodeVisitor visitor) {
        NodeContext<ApiNode> ctx = this.loadNodeContext(visitor);
        return ctx == null ? null : (ApiNode)ctx.getNode();
    }

    public void refreshNode(Node node) {
        this.refreshNode(node, Nodes.visitNone());
    }

    public void refreshNode(Node node, NodeVisitor visitor) {
        Parameters.requireNonNull((Object)node, (String)"node");
        Parameters.requireNonNull((Object)visitor, (String)"visitor");
        NodeContext<ApiNode> ctx = ((ApiNode)node).getContext();
        this.rebaseNodeContext(ctx, new NodeVisitorScope(visitor), null);
        Node r = node;
        while (!r.isRoot()) {
            r = r.getParent();
        }
        this.clearCached(r);
    }

    private void clearCached(Node node) {
        ((ApiNode)node).clearCached();
        if (node.isChildrenLoaded()) {
            for (Node c : node) {
                this.clearCached(c);
            }
        }
    }

    public void saveNode(Node node) {
        Parameters.requireNonNull((Object)node, (String)"node");
        NodeContext<ApiNode> ctx = ((ApiNode)node).getContext();
        this.saveNodeContext(ctx, null);
        this.saveDisplayNames(ctx);
    }

    public void setPriority(int priority) {
        this.navCtx.setState(new NavigationState(Integer.valueOf(priority)));
        this.save(this.navCtx);
    }

    Map<Locale, Described.State> loadDescriptions(String id) {
        try {
            return this.descriptionService.getDescriptions(id);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to retrieve descriptions", t);
        }
    }

    String resolve(NodeContext<ApiNode> ctx) {
        if (this.i18nResolver == null) {
            PortalRequest request = PortalRequest.getInstance();
            Site site = request.getSiteId().equals((Object)this.siteId) ? request.getSite() : request.getPortal().getSite(this.siteId);
            if (site == null) {
                throw new ApiException("Could not resolve display name because site " + this.siteId + " could not be found.");
            }
            this.i18nResolver = new Navigation18NResolver(this.descriptionService, this.bundleManager, site.getLocale(), this.siteId);
        }
        return this.i18nResolver.resolveName(ctx.getState().getLabel(), ctx.getId(), ctx.getName());
    }

    NodeContext<ApiNode> getNodeContext(NodePath nodePath, NodeVisitor visitor) {
        NodeContext ctx = this.loadNodeContext(Nodes.visitNodes((NodePath)nodePath, (NodeVisitor)visitor));
        for (String name : nodePath) {
            if ((ctx = ctx.get(name)) != null) continue;
            return null;
        }
        return ctx;
    }

    private NodeContext<ApiNode> loadNodeContext(NodeVisitor visitor) {
        return this.loadNodeContext(new NodeVisitorScope(visitor), null);
    }

    private NodeContext<ApiNode> loadNodeContext(Scope scope, NodeChangeListener<NodeContext<ApiNode>> listener) {
        try {
            return this.navigationService.loadNode((NodeModel)this.model, this.navCtx, scope, listener);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to load node", e);
        }
    }

    void rebaseNodeContext(NodeContext<ApiNode> ctx, Scope scope, NodeChangeListener<NodeContext<ApiNode>> listener) {
        try {
            this.navigationService.rebaseNode(ctx, scope, listener);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to refresh node", e);
        }
    }

    private void saveNodeContext(NodeContext<ApiNode> ctx, NodeChangeListener<NodeContext<ApiNode>> listener) {
        try {
            this.navigationService.saveNode(ctx, listener);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to save node", e);
        }
    }

    private void save(NavigationContext ctx) {
        try {
            this.navigationService.saveNavigation(ctx);
        }
        catch (Throwable e) {
            throw new ApiException("Failed to save navigation", e);
        }
    }

    private void saveDisplayNames(NodeContext<ApiNode> ctx) {
        ApiNode node = (ApiNode)ctx.getNode();
        if (node != null && node.isDisplayNameChanged()) {
            Map<Locale, Described.State> descriptions;
            if (!node.getDisplayNames().isLocalized()) {
                descriptions = this.loadDescriptions(ctx.getId());
                if (descriptions != null) {
                    this.setDescriptions(ctx.getId(), null);
                }
            } else {
                descriptions = ObjectFactory.createDescriptions(node.getDisplayNames());
                this.setDescriptions(ctx.getId(), descriptions);
            }
        }
        for (NodeContext c = (NodeContext)ctx.getFirst(); c != null; c = (NodeContext)c.getNext()) {
            this.saveDisplayNames((NodeContext<ApiNode>)c);
        }
    }

    private void setDescriptions(String id, Map<Locale, Described.State> descriptions) {
        try {
            this.descriptionService.setDescriptions(id, descriptions);
        }
        catch (Throwable t) {
            throw new ApiException("Failed to set descriptions", t);
        }
    }
}

