/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.organization.integration;

import javax.jcr.Session;
import org.exoplatform.platform.organization.integration.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    private RepositoryService repositoryService;

    public NewGroupListener(RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(Group group, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (!Util.hasGroupFolder(session, group.getId())) {
                Util.createGroupFolder(session, group.getId());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public void postDelete(Group group) throws Exception {
        Session session = null;
        try {
            session = this.repositoryService.getCurrentRepository().getSystemSession(Util.WORKSPACE);
            if (Util.hasGroupFolder(session, group.getId())) {
                Util.deleteGroupFolder(session, group.getId());
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

