/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.cache.model.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.search.Sorting;
import org.exoplatform.social.core.storage.cache.model.key.IdentityKey;
import org.exoplatform.social.core.storage.cache.model.key.ScopeCacheKey;

public class IdentityFilterKey
extends ScopeCacheKey {
    private static final long serialVersionUID = 6711481249085725845L;
    private final String providerId;
    private final String remoteId;
    private final String name;
    private final String position;
    private final String company;
    private final String skills;
    private final char firstChar;
    private final List<IdentityKey> excluded;
    private final List<String> onlineRemoteIds;
    private final String all;
    private final Sorting sorting;

    public IdentityFilterKey(String providerId, String remoteId, ProfileFilter filter) {
        this.remoteId = remoteId;
        this.providerId = providerId;
        this.name = filter.getName();
        this.position = filter.getPosition();
        this.company = filter.getCompany();
        this.skills = filter.getSkills();
        this.firstChar = filter.getFirstCharacterOfName();
        ArrayList<IdentityKey> keys = new ArrayList<IdentityKey>();
        for (Identity i : filter.getExcludedIdentityList()) {
            keys.add(new IdentityKey(i));
        }
        this.excluded = Collections.unmodifiableList(keys);
        this.onlineRemoteIds = Collections.unmodifiableList(filter.getOnlineRemoteIds());
        this.all = filter.getAll();
        this.sorting = filter.getSorting();
    }

    public IdentityFilterKey(String providerId, ProfileFilter filter) {
        this.providerId = providerId;
        this.remoteId = filter.getViewerIdentity() == null ? null : filter.getViewerIdentity().getRemoteId();
        this.name = filter.getName();
        this.position = filter.getPosition();
        this.company = filter.getCompany();
        this.skills = filter.getSkills();
        this.firstChar = filter.getFirstCharacterOfName();
        ArrayList<IdentityKey> keys = new ArrayList<IdentityKey>();
        for (Identity i : filter.getExcludedIdentityList()) {
            keys.add(new IdentityKey(i));
        }
        this.excluded = Collections.unmodifiableList(keys);
        this.onlineRemoteIds = Collections.unmodifiableList(filter.getOnlineRemoteIds());
        this.all = filter.getAll();
        this.sorting = filter.getSorting();
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getName() {
        return this.name;
    }

    public String getPosition() {
        return this.position;
    }

    public String getCompany() {
        return this.company;
    }

    public String getSkills() {
        return this.skills;
    }

    public char getFirstChar() {
        return this.firstChar;
    }

    public List<IdentityKey> getExcluded() {
        return this.excluded;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityFilterKey)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityFilterKey that = (IdentityFilterKey)o;
        if (this.firstChar != that.firstChar) {
            return false;
        }
        if (this.all != null ? !this.all.equals(that.all) : that.all != null) {
            return false;
        }
        if (this.company != null ? !this.company.equals(that.company) : that.company != null) {
            return false;
        }
        if (this.excluded != null ? !this.excluded.equals(that.excluded) : that.excluded != null) {
            return false;
        }
        if (this.onlineRemoteIds != null ? !this.onlineRemoteIds.equals(that.onlineRemoteIds) : that.onlineRemoteIds != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals(that.position) : that.position != null) {
            return false;
        }
        if (this.providerId != null ? !this.providerId.equals(that.providerId) : that.providerId != null) {
            return false;
        }
        if (this.remoteId != null ? !this.remoteId.equals(that.remoteId) : that.remoteId != null) {
            return false;
        }
        if (this.skills != null ? !this.skills.equals(that.skills) : that.skills != null) {
            return false;
        }
        return !(this.sorting != null ? !this.sorting.equals(that.sorting) : that.sorting != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.providerId != null ? this.providerId.hashCode() : 0);
        result = 31 * result + (this.remoteId != null ? this.remoteId.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + (this.company != null ? this.company.hashCode() : 0);
        result = 31 * result + (this.skills != null ? this.skills.hashCode() : 0);
        result = 31 * result + this.firstChar;
        result = 31 * result + (this.excluded != null ? this.excluded.hashCode() : 0);
        result = 31 * result + (this.onlineRemoteIds != null ? this.onlineRemoteIds.hashCode() : 0);
        result = 31 * result + (this.all != null ? this.all.hashCode() : 0);
        result = 31 * result + (this.sorting != null ? this.sorting.hashCode() : 0);
        return result;
    }
}

