/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.recovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.I18N;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.login.recovery.PasswordRecoveryHandler;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.security.Credentials;

public class PasswordRecoveryServiceImpl
implements PasswordRecoveryService {
    protected static Logger log = LoggerFactory.getLogger(PasswordRecoveryServiceImpl.class);
    private final OrganizationService orgService;
    private final MailService mailService;
    private final ResourceBundleService bundleService;
    private final RemindPasswordTokenService remindPasswordTokenService;
    private final WebAppController webController;
    private static final Pattern PATTERN = Pattern.compile("&\\{([a-zA-Z0-9\\.]+)\\}");

    public PasswordRecoveryServiceImpl(OrganizationService orgService, MailService mailService, ResourceBundleService bundleService, RemindPasswordTokenService remindPasswordTokenService, WebAppController controller) {
        this.orgService = orgService;
        this.mailService = mailService;
        this.bundleService = bundleService;
        this.remindPasswordTokenService = remindPasswordTokenService;
        this.webController = controller;
    }

    @Override
    public Credentials verifyToken(String tokenId) {
        GateInToken token = this.remindPasswordTokenService.getToken(tokenId);
        if (token == null || token.isExpired()) {
            return null;
        }
        return token.getPayload();
    }

    @Override
    public boolean changePass(String tokenId, String username, String password) {
        try {
            User user = this.orgService.getUserHandler().findUserByName(username);
            user.setPassword(password);
            this.orgService.getUserHandler().saveUser(user, true);
            try {
                this.remindPasswordTokenService.deleteToken(tokenId);
            }
            catch (Exception ex) {
                log.warn((Object)("Can not delete token: " + tokenId), (Throwable)ex);
            }
            return true;
        }
        catch (Exception ex) {
            log.error((Object)("Can not change pass for user: " + username), (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean sendRecoverPasswordEmail(User user, Locale defaultLocale, HttpServletRequest req) {
        if (user == null) {
            throw new IllegalArgumentException("User or Locale must not be null");
        }
        Locale locale = this.getLocaleOfUser(user.getUserName(), defaultLocale);
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)req.getServletContext());
        ResourceBundle bundle = this.bundleService.getResourceBundle(this.bundleService.getSharedResourceBundleNames(), locale);
        Credentials credentials = new Credentials(user.getUserName(), "");
        String tokenId = this.remindPasswordTokenService.createToken(credentials);
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "forgot-password");
        params.put(PasswordRecoveryHandler.TOKEN, tokenId);
        params.put(PasswordRecoveryHandler.LANG, I18N.toTagIdentifier((Locale)locale));
        StringBuilder url = new StringBuilder();
        url.append(req.getScheme()).append("://").append(req.getServerName());
        if (req.getServerPort() != 80 && req.getServerPort() != 443) {
            url.append(':').append(req.getServerPort());
        }
        url.append(container.getPortalContext().getContextPath());
        url.append(router.render(params));
        String emailBody = this.buildEmailBody(user, bundle, url.toString());
        String emailSubject = this.getEmailSubject(user, bundle);
        String senderName = this.getSenderName();
        String from = this.getSenderEmail();
        if (senderName != null && !senderName.trim().isEmpty()) {
            from = senderName + " <" + from + ">";
        }
        Message message = new Message();
        message.setFrom(from);
        message.setTo(user.getEmail());
        message.setSubject(emailSubject);
        message.setBody(emailBody);
        message.setMimeType("text/html");
        try {
            this.mailService.sendMessage(message);
        }
        catch (Exception ex) {
            log.error((Object)"Failure to send recover password email", (Throwable)ex);
            return false;
        }
        return true;
    }

    private Locale getLocaleOfUser(String username, Locale defLocale) {
        try {
            UserProfile profile = this.orgService.getUserProfileHandler().findUserProfileByName(username);
            String lang = profile == null ? null : (String)profile.getUserInfoMap().get("user.language");
            return lang != null ? LocaleContextInfo.getLocale((String)lang) : defLocale;
        }
        catch (Exception ex) {
            log.debug((Object)"Can not load user profile language", (Throwable)ex);
            return defLocale;
        }
    }

    private String buildEmailBody(User user, ResourceBundle bundle, String link) {
        InputStream input = this.getClass().getClassLoader().getResourceAsStream("conf/forgot_password_email_template.html");
        String content = input == null ? "" : this.resolveLanguage(input, bundle);
        content = content.replaceAll("\\$\\{FIRST_NAME\\}", user.getFirstName());
        content = content.replaceAll("\\$\\{USERNAME\\}", user.getUserName());
        content = content.replaceAll("\\$\\{RESET_PASSWORD_LINK\\}", link);
        return content;
    }

    private String resolveLanguage(InputStream input, ResourceBundle bundle) {
        StringBuffer content = new StringBuffer();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            while ((line = reader.readLine()) != null) {
                if (content.length() > 0) {
                    content.append("\n");
                }
                this.resolveLanguage(content, line, bundle);
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
        }
        return content.toString();
    }

    private void resolveLanguage(StringBuffer sb, String input, ResourceBundle bundle) {
        Matcher matcher = PATTERN.matcher(input);
        while (matcher.find()) {
            String resource;
            String key = matcher.group(1);
            try {
                resource = bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                resource = key;
            }
            matcher.appendReplacement(sb, resource);
        }
        matcher.appendTail(sb);
    }

    protected String getEmailSubject(User user, ResourceBundle bundle) {
        return bundle.getString("gatein.forgotPassword.email.subject");
    }

    protected String getSenderName() {
        return "";
    }

    protected String getSenderEmail() {
        return System.getProperty("gatein.email.smtp.from", "noreply@gatein.org");
    }

    @Override
    public String getPasswordRecoverURL(String tokenId, String lang) {
        Router router = this.webController.getRouter();
        HashMap<QualifiedName, String> params = new HashMap<QualifiedName, String>();
        params.put(WebAppController.HANDLER_PARAM, "forgot-password");
        if (tokenId != null) {
            params.put(PasswordRecoveryHandler.TOKEN, tokenId);
        }
        if (lang != null) {
            params.put(PasswordRecoveryHandler.LANG, lang);
        }
        return router.render(params);
    }
}

