/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.security.security;

import java.util.Date;
import java.util.Map;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.exoplatform.web.security.GateInToken;
import org.exoplatform.web.security.security.HashedToken;
import org.exoplatform.web.security.security.TokenEntry;
import org.exoplatform.web.security.security.TokenExistsException;
import org.gatein.wci.security.Credentials;

@PrimaryType(name="tkn:tokencontainer")
public abstract class TokenContainer {
    @Create
    protected abstract TokenEntry createToken();

    @OneToMany
    public abstract Map<String, TokenEntry> getTokens();

    public GateInToken getToken(String tokenId) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        return entry != null ? entry.getToken() : null;
    }

    public GateInToken removeToken(String tokenId) {
        Map<String, TokenEntry> tokens = this.getTokens();
        TokenEntry entry = tokens.get(tokenId);
        if (entry != null) {
            GateInToken token = entry.getToken();
            entry.remove();
            return token;
        }
        return null;
    }

    public void saveToken(ChromatticSession session, String id, String hashedToken, Credentials credentials, Date expirationTime) throws TokenExistsException {
        Map<String, TokenEntry> tokens = this.getTokens();
        if (tokens.containsKey(id)) {
            throw new TokenExistsException();
        }
        TokenEntry entry = this.createToken();
        tokens.put(id, entry);
        entry.setUserName(credentials.getUsername());
        entry.setPassword(credentials.getPassword());
        entry.setExpirationTime(expirationTime);
        HashedToken hashedTokenMixin = (HashedToken)session.create(HashedToken.class);
        session.setEmbedded((Object)entry, HashedToken.class, (Object)hashedTokenMixin);
        hashedTokenMixin.setHashedToken(hashedToken);
    }

    public void cleanExpiredTokens() {
        Map<String, TokenEntry> tokens = this.getTokens();
        if (tokens != null) {
            for (TokenEntry en : tokens.values()) {
                GateInToken token = en.getToken();
                if (!token.isExpired()) continue;
                en.remove();
            }
        }
    }

    public void cleanLegacyTokens() {
        Map<String, TokenEntry> tokens = this.getTokens();
        if (tokens != null) {
            for (Map.Entry<String, TokenEntry> en : tokens.entrySet()) {
                String token = en.getKey();
                if (!token.startsWith("rememberme")) continue;
                en.getValue().remove();
            }
        }
    }

    public int size() {
        Map<String, TokenEntry> tokens = this.getTokens();
        return tokens != null ? tokens.size() : 0;
    }

    public void removeAll() {
        for (TokenEntry en : this.getTokens().values()) {
            en.remove();
        }
    }
}

