/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.EmptySerializablePageList;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.DocumentProviderUtils;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.action.ManageVersionsActionComponent;
import org.exoplatform.ecm.webui.component.explorer.versions.UIActivateVersion;
import org.exoplatform.ecm.webui.component.explorer.versions.UIVersionInfo;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.ItemLinkAware;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDocumentNodeList.gtmpl", events={@EventConfig(listeners={ExpandNodeActionListener.class}), @EventConfig(listeners={CollapseNodeActionListener.class}), @EventConfig(listeners={ManageVersionsActionListener.class}), @EventConfig(listeners={MoreActionListener.class})})
public class UIDocumentNodeList
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentNodeList.class.getName());
    private UIPageIterator pageIterator_;
    private LinkManager linkManager_ = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
    private List dataList_;
    private int padding_;
    private boolean showMoreButton_ = true;

    public UIDocumentNodeList() throws Exception {
        this.addChild(ManageVersionsActionComponent.class, null, null);
        this.pageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIDocumentNodeListPageIterator");
        this.padding_ = 0;
    }

    public List<Node> getNodeChildrenList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)(this.showMoreButton_ ? this.dataList_ : this.pageIterator_.getCurrentPageData()));
    }

    public void setPageList(PageList p) throws Exception {
        this.pageIterator_.setPageList(p);
        this.dataList_ = new ArrayList();
        if (p != null && p.getAvailable() > 0) {
            this.dataList_.addAll(p.getPage(1));
        }
        this.updateUIDocumentNodeListChildren();
    }

    public int getPadding() {
        return this.padding_;
    }

    public void setPadding(int value) {
        this.padding_ = value;
    }

    public boolean isShowMoreButton() {
        return this.showMoreButton_ && this.pageIterator_ != null && this.pageIterator_.getPageList() != null && this.dataList_ != null && this.dataList_.size() < this.pageIterator_.getPageList().getAvailable();
    }

    public void setShowMoreButton(boolean value) {
        this.showMoreButton_ = value;
    }

    public void setCurrentNode(Node node) throws Exception {
        this.setPageList(this.getPageList(node.getPath()));
    }

    public void updateUIDocumentNodeListChildren() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        for (UIComponent component : this.getChildren()) {
            if (!(component instanceof UIDocumentNodeList)) continue;
            ids.add(component.getId());
        }
        for (String id : ids) {
            this.removeChildById(id);
        }
        for (Node node : this.getNodeChildrenList()) {
            if (node instanceof NodeLinkAware) {
                node = ((NodeLinkAware)node).getRealNode();
            }
            try {
                Node targetNode;
                Node node2 = targetNode = this.linkManager_.isLink((Item)node) ? this.linkManager_.getTarget(node) : node;
                if (!targetNode.isNodeType("nt:folder") && !targetNode.isNodeType("nt:unstructured")) continue;
                this.addUIDocList(this.getID(node));
            }
            catch (ItemNotFoundException ine) {}
        }
    }

    public UIPageIterator getContentPageIterator() {
        return this.pageIterator_;
    }

    public String getID(Node node) throws Exception {
        return ((Object)((Object)((UIDocumentInfo)this.getAncestorOfType(UIDocumentInfo.class)))).getClass().getSimpleName() + ((Object)((Object)this)).getClass().getSimpleName() + String.valueOf(Math.abs(node.getPath().hashCode()));
    }

    public UIComponent addUIDocList(String id) throws Exception {
        UIDocumentNodeList child = (UIDocumentNodeList)this.addChild(UIDocumentNodeList.class, null, id);
        child.setPadding(this.padding_ + 1);
        child.getContentPageIterator().setId(child.getId() + "PageIterator");
        return child;
    }

    public String getFileName(Node file, String title) throws Exception {
        if (!file.isNodeType("nt:file") || title == null) {
            return title;
        }
        int index = title.lastIndexOf(46);
        if (index != -1) {
            return title.substring(0, index);
        }
        return title;
    }

    public String getFileExtension(Node file, String title) throws Exception {
        if (!file.isNodeType("nt:file") || title == null) {
            return "";
        }
        int index = title.lastIndexOf(46);
        if (index != -1) {
            return title.substring(index);
        }
        return "";
    }

    public String getFileDate(Node file) throws Exception {
        String createdDate = this.getDatePropertyValue(file, "exo:dateCreated");
        String modifiedDate = this.getDatePropertyValue(file, "exo:lastModifiedDate");
        return StringUtils.isEmpty((String)modifiedDate) || this.equalDates(file, "exo:dateCreated", "exo:lastModifiedDate") ? this.getLabel("CreatedOn") + " " + createdDate : this.getLabel("Updated") + " " + modifiedDate;
    }

    private boolean equalDates(Node node, String p1, String p2) {
        Calendar pr1 = null;
        Calendar pr2 = null;
        try {
            pr1 = node.getProperty(p1).getDate();
        }
        catch (PathNotFoundException e) {
            pr1 = null;
        }
        catch (ValueFormatException e) {
            pr1 = null;
        }
        catch (RepositoryException e) {
            pr1 = null;
        }
        try {
            pr2 = node.getProperty(p2).getDate();
        }
        catch (PathNotFoundException e) {
            pr2 = null;
        }
        catch (ValueFormatException e) {
            pr2 = null;
        }
        catch (RepositoryException e) {
            pr2 = null;
        }
        if (pr1 == null && pr2 == null) {
            return true;
        }
        if (pr1 == null || pr2 == null) {
            return false;
        }
        return Math.abs(pr1.getTimeInMillis() - pr2.getTimeInMillis()) < 3000L;
    }

    public String getDatePropertyValue(Node node, String propertyName) throws Exception {
        try {
            Property property = node.getProperty(propertyName);
            if (property != null) {
                Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
                DateFormat dateFormat = SimpleDateFormat.getDateInstance(3, locale);
                return dateFormat.format(property.getDate().getTime());
            }
        }
        catch (PathNotFoundException PNE) {
            return "";
        }
        return "";
    }

    public String getLabel(String id) {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("UIDocumentNodeList.label." + id);
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }

    protected String getVersionNumber(Node file) throws Exception {
        String currentVersion = null;
        if (file.isNodeType("mix:versionable")) {
            try {
                if (file.isNodeType("mix:versionDisplayName") && file.hasProperty("exo:maxVersion")) {
                    int max = (int)file.getProperty("exo:maxVersion").getLong();
                    currentVersion = String.valueOf(max - 1);
                } else {
                    currentVersion = file.getBaseVersion().getName();
                    if (currentVersion.contains("jcr:rootVersion")) {
                        currentVersion = "0";
                    }
                }
            }
            catch (Exception e) {
                currentVersion = "0";
            }
            return "V" + currentVersion;
        }
        return "";
    }

    public String getAuthorName(Node file) throws Exception {
        String userName = ((UIDocumentInfo)this.getAncestorOfType(UIDocumentInfo.class)).getPropertyValue(file, "exo:lastModifier");
        if (StringUtils.isEmpty((String)userName) || IdentityConstants.SYSTEM.equals(userName)) {
            return "";
        }
        return String.format("%s %s", this.getLabel("by"), userName.equals(ConversationState.getCurrent().getIdentity().getUserId()) ? this.getLabel("you") : userName);
    }

    public String getFileSize(Node file) throws Exception {
        return Utils.fileSize((Node)file);
    }

    private PageList<Object> getPageList(String path) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Preference pref = uiExplorer.getPreference();
        DocumentProviderUtils docProviderUtil = DocumentProviderUtils.getInstance();
        if (docProviderUtil.canSortType(pref.getSortType()) && uiExplorer.getAllItemByTypeFilterMap().isEmpty()) {
            return docProviderUtil.getPageList(uiExplorer.getWorkspaceName(), path, pref, uiExplorer.getAllItemFilterMap(), uiExplorer.getAllItemByTypeFilterMap(), (NodeLinkAware)ItemLinkAware.newInstance((String)uiExplorer.getWorkspaceName(), (String)path, (Item)uiExplorer.getNodeByPath(path, uiExplorer.getSession())));
        }
        List<Node> nodeList = null;
        UIDocumentInfo uiDocInfo = (UIDocumentInfo)this.getAncestorOfType(UIDocumentInfo.class);
        int nodesPerPage = pref.getNodesPerPage();
        Set<String> allItemByTypeFilterMap = uiExplorer.getAllItemByTypeFilterMap();
        nodeList = allItemByTypeFilterMap.size() > 0 ? uiDocInfo.filterNodeList(uiExplorer.getChildrenList(path, !pref.isShowPreferenceDocuments())) : uiDocInfo.filterNodeList(uiExplorer.getChildrenList(path, pref.isShowPreferenceDocuments()));
        ListAccessImpl nodeAccList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(nodeList));
        return new LazyPageList((ListAccess)nodeAccList, nodesPerPage);
    }

    public static class MoreActionListener
    extends EventListener<UIDocumentNodeList> {
        public void execute(Event<UIDocumentNodeList> event) throws Exception {
            UIDocumentNodeList uicomp = (UIDocumentNodeList)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                int currentPage = uicomp.dataList_.size() / uicomp.pageIterator_.getPageList().getPageSize();
                uicomp.dataList_.addAll(uicomp.pageIterator_.getPageList().getPage(currentPage + 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uicomp);
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ManageVersionsActionListener
    extends EventListener<UIDocumentNodeList> {
        public void execute(Event<UIDocumentNodeList> event) throws Exception {
            NodeFinder nodeFinder = (NodeFinder)((UIDocumentNodeList)((Object)event.getSource())).getApplicationComponent(NodeFinder.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIDocumentNodeList)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            uri = LinkUtils.evaluatePath((String)uri);
            Node currentNode = (Node)nodeFinder.getItem(workspaceName, uri);
            uiExplorer.setIsHidePopup(false);
            if (currentNode.canAddMixin("mix:versionable")) {
                UIPopupContainer2.activate(UIActivateVersion.class, 400);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
            } else if (currentNode.isNodeType("mix:versionable")) {
                UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
                UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
                UIVersionInfo uiVersionInfo = (UIVersionInfo)uiDocumentWorkspace.getChild(UIVersionInfo.class);
                uiVersionInfo.setCurrentNode(currentNode);
                uiVersionInfo.setRootOwner(currentNode.getProperty("exo:lastModifier").getString());
                uiVersionInfo.activate();
                uiDocumentWorkspace.setRenderedChild(UIVersionInfo.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentWorkspace);
            }
        }
    }

    public static class CollapseNodeActionListener
    extends EventListener<UIDocumentNodeList> {
        public void execute(Event<UIDocumentNodeList> event) throws Exception {
            UIDocumentNodeList uicomp = (UIDocumentNodeList)((Object)event.getSource());
            NodeFinder nodeFinder = (NodeFinder)uicomp.getApplicationComponent(NodeFinder.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                uri = LinkUtils.evaluatePath((String)uri);
                Item item = nodeFinder.getItem(workspaceName, uri);
                if (item instanceof Node && org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)((Node)item))) {
                    return;
                }
                Node clickedNode = (Node)item;
                UIDocumentNodeList uiDocNodeListChild = (UIDocumentNodeList)uicomp.getChildById(uicomp.getID(clickedNode));
                uiDocNodeListChild.setPageList(EmptySerializablePageList.get());
                ((UIDocumentInfo)uicomp.getAncestorOfType(UIDocumentInfo.class)).getExpandedFolders().remove(uri);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocNodeListChild);
            }
            catch (ItemNotFoundException nu) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }

    public static class ExpandNodeActionListener
    extends EventListener<UIDocumentNodeList> {
        public void execute(Event<UIDocumentNodeList> event) throws Exception {
            UIDocumentNodeList uicomp = (UIDocumentNodeList)((Object)event.getSource());
            NodeFinder nodeFinder = (NodeFinder)uicomp.getApplicationComponent(NodeFinder.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
            try {
                uri = LinkUtils.evaluatePath((String)uri);
                Item item = nodeFinder.getItem(workspaceName, uri);
                if (item instanceof Node && org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)((Node)item))) {
                    return;
                }
                Node clickedNode = (Node)item;
                UIDocumentNodeList uiDocNodeListChild = (UIDocumentNodeList)uicomp.getChildById(uicomp.getID(clickedNode));
                uiDocNodeListChild.setCurrentNode(clickedNode);
                ((UIDocumentInfo)uicomp.getAncestorOfType(UIDocumentInfo.class)).getExpandedFolders().add(uri);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocNodeListChild);
            }
            catch (ItemNotFoundException nu) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                return;
            }
            catch (PathNotFoundException pa) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.path-not-found", null, 1));
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.access-denied", null, 1));
                return;
            }
            catch (RepositoryException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Repository cannot be found");
                }
                uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.repository-error", null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
        }
    }
}

