/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.service.storage.WebNotificationStorageImpl;
import org.exoplatform.commons.notification.impl.service.storage.cache.AbstractWebNotifListData;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.CacheLoader;
import org.exoplatform.commons.notification.impl.service.storage.cache.FutureExoCache;
import org.exoplatform.commons.notification.impl.service.storage.cache.FutureWebNotifExoCache;
import org.exoplatform.commons.notification.impl.service.storage.cache.ServiceContext;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.IntegerData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsData;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.ListWebNotificationsKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoCacheKey;
import org.exoplatform.commons.notification.impl.service.storage.cache.model.WebNotifInfoData;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CachedWebNotificationStorage
implements WebNotificationStorage {
    private static final Log LOG = ExoLogger.getLogger(CachedWebNotificationStorage.class);
    private static final String WEB_NOTIFICATION_CACHING_NAME = "WebNotificationCache";
    private static final String LIST_WEB_NOTIFICATION_CACHING_NAME = "WebNotificationsCache";
    private static final String WEB_NOTIFICATION_COUNT_CACHING_NAME = "WebNotificationCountCache";
    private final ExoCache<WebNotifInfoCacheKey, WebNotifInfoData> exoWebNotificationCache;
    private final ExoCache<WebNotifInfoCacheKey, IntegerData> exoWebNotificationCountCache;
    private final ExoCache<ListWebNotificationsKey, ListWebNotificationsData> exoWebNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, WebNotifInfoData, ServiceContext<WebNotifInfoData>> futureWebNotificationCache;
    private FutureWebNotifExoCache<String, ListWebNotificationsKey, ListWebNotificationsData, ServiceContext<ListWebNotificationsData>> futureWebNotificationsCache;
    private FutureExoCache<WebNotifInfoCacheKey, IntegerData, ServiceContext<IntegerData>> futureWebNotificationCountCache;
    private final WebNotificationStorageImpl storage;

    public CachedWebNotificationStorage(WebNotificationStorageImpl storage, CacheService cacheService) {
        this.storage = storage;
        this.exoWebNotificationCache = cacheService.getCacheInstance(WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationsCache = cacheService.getCacheInstance(LIST_WEB_NOTIFICATION_CACHING_NAME);
        this.exoWebNotificationCountCache = cacheService.getCacheInstance(WEB_NOTIFICATION_COUNT_CACHING_NAME);
        this.futureWebNotificationCache = this.createFutureCache(this.exoWebNotificationCache);
        this.futureWebNotificationsCache = this.createFutureWebNotifCache(this.exoWebNotificationsCache);
        this.futureWebNotificationCountCache = this.createFutureCache(this.exoWebNotificationCountCache);
    }

    public void save(NotificationInfo notification) {
        if (notification.isUpdate()) {
            this.update(notification, true);
        } else {
            this.storage.save(notification);
            WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notification.getTo());
            IntegerData data = (IntegerData)this.exoWebNotificationCountCache.get((Serializable)key);
            if (data != null) {
                Integer current = (Integer)data.build();
                this.exoWebNotificationCountCache.put((Serializable)key, (Object)new IntegerData(current + 1));
            }
            this.removeWebNotificationsEntry(notification, true);
            this.removeWebNotificationsEntry(notification, false);
            this.moveTopPopover(notification);
            this.moveTopViewAll(notification);
            this.clearIsMaxOnWebNotificationsData(notification.getTo(), false);
        }
    }

    private void removeWebNotificationsEntry(NotificationInfo notification, boolean isPopup) {
        ListWebNotificationsKey listWebNotificationsKey = ListWebNotificationsKey.key(notification.getTo(), isPopup);
        ListWebNotificationsData listWebNotificationsData = new ListWebNotificationsData(listWebNotificationsKey);
        this.exoWebNotificationsCache.put((Serializable)listWebNotificationsKey, (Object)listWebNotificationsData);
    }

    public void markRead(String notificationId) {
        this.storage.markRead(notificationId);
        this.updateRead(notificationId, true);
    }

    public void updateRead(String notificationId, boolean isRead) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData infoData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)key);
        if (infoData != null) {
            infoData.updateRead(isRead);
        }
        if (isRead) {
            this.clearWebNotificationCache(notificationId);
        }
    }

    public void updateAllRead(String userId) throws Exception {
        this.updateCacheByUser(userId, true);
    }

    private void updateCacheByUser(String userId, boolean isUpdateRead) {
        try {
            List infoDatas = this.exoWebNotificationCache.getCachedObjects();
            if (infoDatas != null) {
                ArrayList<String> removeIds = new ArrayList<String>();
                for (Object webNotifInfoData : infoDatas) {
                    WebNotifInfoData webData = (WebNotifInfoData)webNotifInfoData;
                    NotificationInfo ntf = webData.build();
                    if (!userId.equals(ntf.getTo())) continue;
                    if (isUpdateRead) {
                        webData.updateRead(true);
                        this.clearWebNotificationCache(ntf.getId());
                        continue;
                    }
                    removeIds.add(ntf.getId());
                }
                for (String notificationId : removeIds) {
                    this.exoWebNotificationCache.remove((Serializable)WebNotifInfoCacheKey.key(notificationId));
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to update cache by user: " + userId), (Throwable)e);
        }
    }

    public void markAllRead(String userId) {
        this.storage.markAllRead(userId);
    }

    public void hidePopover(String notificationId) {
        NotificationInfo notification;
        this.storage.hidePopover(notificationId);
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData infoData = (WebNotifInfoData)this.exoWebNotificationCache.get((Serializable)key);
        if (infoData != null) {
            infoData.updateShowPopover(false);
        }
        if ((notification = this.get(notificationId)) != null) {
            this.removePopover(notification);
        }
    }

    public List<NotificationInfo> get(final WebNotificationFilter filter, final int offset, final int limit) {
        final ListWebNotificationsKey key = ListWebNotificationsKey.key(filter.getUserId(), filter.isOnPopover());
        ListWebNotificationsData keys = (ListWebNotificationsData)this.futureWebNotificationsCache.get(new ServiceContext<ListWebNotificationsData>(){

            @Override
            public ListWebNotificationsData execute() {
                List<NotificationInfo> got = CachedWebNotificationStorage.this.storage.get(filter, offset, limit);
                boolean isMax = got.size() < limit;
                return CachedWebNotificationStorage.this.buildWebNotifDataIds(key, got, isMax);
            }
        }, key, offset, limit);
        return this.buildNotifications(keys, offset, limit);
    }

    public boolean remove(String notificationId) {
        NotificationInfo notification = this.get(notificationId);
        if (notification == null) {
            return false;
        }
        this.storage.remove(notificationId);
        this.removePopover(notification);
        this.removeViewAll(notification);
        this.clearWebNotificationCache(notificationId);
        this.clearWebNotificationCountCache(notification.getTo());
        return true;
    }

    public NotificationInfo get(final String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        WebNotifInfoData notificationInfo = (WebNotifInfoData)this.futureWebNotificationCache.get(new ServiceContext<WebNotifInfoData>(){

            @Override
            public WebNotifInfoData execute() {
                try {
                    NotificationInfo got = CachedWebNotificationStorage.this.storage.get(notificationId);
                    if (got != null) {
                        return new WebNotifInfoData(got);
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, key);
        if (notificationInfo == null) {
            return null;
        }
        return notificationInfo.build();
    }

    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String owner) {
        return this.storage.getUnreadNotification(pluginId, activityId, owner);
    }

    public boolean remove(String userId, long seconds) {
        this.clearWebNotificationCountCache(userId);
        this.updateCacheByUser(userId, false);
        return this.storage.remove(userId, seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long seconds) {
        boolean removed = false;
        try {
            boolean bl = removed = this.storage.remove(seconds);
            return bl;
        }
        finally {
            if (removed) {
                this.exoWebNotificationCache.clearCache();
                this.exoWebNotificationCountCache.clearCache();
            }
        }
    }

    private void clearIsMaxOnWebNotificationsData(String userId, boolean onlyPopopver) {
        ListWebNotificationsKey key = ListWebNotificationsKey.key(userId, true);
        this.getWebNotificationsData(key).setMax(false);
        if (!onlyPopopver) {
            key = ListWebNotificationsKey.key(userId, false);
            this.getWebNotificationsData(key).setMax(false);
        }
    }

    private ListWebNotificationsData getWebNotificationsData(ListWebNotificationsKey key) {
        ListWebNotificationsData data = (ListWebNotificationsData)this.exoWebNotificationsCache.get((Serializable)key);
        if (data == null) {
            data = new ListWebNotificationsData(key);
            this.exoWebNotificationsCache.put((Serializable)key, (Object)data);
        }
        return data;
    }

    private ListWebNotificationsData buildWebNotifDataIds(ListWebNotificationsKey key, List<NotificationInfo> notifications, boolean isMax) {
        ListWebNotificationsData data = this.getWebNotificationsData(key);
        data.setMax(isMax);
        int len = notifications.size();
        for (int i = 0; i < len; ++i) {
            NotificationInfo notif = notifications.get(i);
            if (notif == null || data.contains(notif.getId())) continue;
            data.insertLast(notif.getId());
        }
        return data;
    }

    private List<NotificationInfo> buildNotifications(ListWebNotificationsData data, long offset, long limit) {
        ArrayList<NotificationInfo> notifications = new ArrayList<NotificationInfo>();
        long to = Math.min((long)data.size(), offset + limit);
        List<String> ids = Collections.synchronizedList(data.subList((int)offset, (int)to));
        for (String id : ids) {
            NotificationInfo a = this.get(id);
            if (a == null) continue;
            notifications.add(a);
        }
        return notifications;
    }

    public void update(NotificationInfo notification, boolean moveTop) {
        this.storage.update(notification, moveTop);
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notification.getId());
        this.exoWebNotificationCache.put((Serializable)key, (Object)new WebNotifInfoData(notification));
        if (moveTop) {
            this.moveTopPopover(notification);
            this.moveTopViewAll(notification);
        }
        this.clearWebNotificationCountCache(notification.getTo());
    }

    public int getNumberOnBadge(final String userId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
        IntegerData numberOfMessageData = (IntegerData)this.futureWebNotificationCountCache.get(new ServiceContext<IntegerData>(){

            @Override
            public IntegerData execute() {
                try {
                    Integer number = CachedWebNotificationStorage.this.storage.getNumberOnBadge(userId);
                    if (number != null) {
                        return new IntegerData(number);
                    }
                    return new IntegerData(0);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, key);
        return (Integer)numberOfMessageData.build();
    }

    public void resetNumberOnBadge(String userId) {
        this.storage.resetNumberOnBadge(userId);
        this.clearWebNotificationCountCache(userId);
    }

    public void clearWebNotificationCountCache(String userId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(userId);
        this.exoWebNotificationCountCache.remove((Serializable)key);
    }

    public void clearWebNotificationCache(String notificationId) {
        WebNotifInfoCacheKey key = WebNotifInfoCacheKey.key(notificationId);
        this.exoWebNotificationCache.remove((Serializable)key);
    }

    public void moveTopPopover(NotificationInfo notification) {
        ListWebNotificationsKey userPopoverKey = ListWebNotificationsKey.key(notification.getTo(), true);
        ListWebNotificationsData listData = this.getWebNotificationsData(userPopoverKey);
        if (listData != null) {
            listData.moveTop(notification.getId(), notification.getTo());
        }
    }

    public void moveTopViewAll(NotificationInfo notification) {
        ListWebNotificationsKey userViewAllKey = ListWebNotificationsKey.key(notification.getTo(), false);
        ListWebNotificationsData listData = this.getWebNotificationsData(userViewAllKey);
        if (listData != null) {
            listData.moveTop(notification.getId(), notification.getTo());
        }
    }

    private void removePopover(NotificationInfo notification) {
        ListWebNotificationsKey userPopoverKey = ListWebNotificationsKey.key(notification.getTo(), true);
        ListWebNotificationsData listData = this.getWebNotificationsData(userPopoverKey);
        if (listData != null) {
            listData.removeByValue(notification.getId());
        }
    }

    private void removeViewAll(NotificationInfo notification) {
        ListWebNotificationsKey userViewAllKey = ListWebNotificationsKey.key(notification.getTo(), false);
        ListWebNotificationsData listData = this.getWebNotificationsData(userViewAllKey);
        if (listData != null) {
            listData.removeByValue(notification.getId());
        }
    }

    private <T extends Serializable, K extends CacheKey, V extends AbstractWebNotifListData<K, T>> FutureWebNotifExoCache<T, K, V, ServiceContext<V>> createFutureWebNotifCache(ExoCache<K, V> cache) {
        return new FutureWebNotifExoCache(new CacheLoader(), cache);
    }

    private <K extends CacheKey, V extends Serializable> FutureExoCache<K, V, ServiceContext<V>> createFutureCache(ExoCache<K, V> cache) {
        return new FutureExoCache(new CacheLoader(), cache);
    }
}

