/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class StringCommonUtils {
    private static final int BUFFER_SIZE = 32;

    public static InputStream compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return new ByteArrayInputStream(compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(InputStream is) throws IOException {
        GZIPInputStream gis = new GZIPInputStream(is, 32);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] data = new byte[32];
            while ((bytesRead = gis.read(data)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            String string = new String(buffer.toByteArray());
            return string;
        }
        finally {
            gis.close();
            is.close();
            buffer.close();
        }
    }
}

