/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.cache;

import java.io.Serializable;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingContext;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.api.settings.data.SettingScope;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.future.FutureExoCache;
import org.exoplatform.services.cache.future.Loader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.settings.cache.NullSettingValue;
import org.exoplatform.settings.cache.selector.SettingCacheSelector;
import org.exoplatform.settings.impl.SettingServiceImpl;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class CacheSettingServiceImpl
implements SettingService {
    private static final Log LOG = ExoLogger.getLogger(CacheSettingServiceImpl.class);
    protected ExoCache<SettingKey, SettingValue> settingCache;
    protected FutureExoCache<SettingKey, SettingValue, SettingServiceImpl> futureExoCache;
    private static final Logger log = LoggerFactory.getLogger(CacheSettingServiceImpl.class);
    private final SettingServiceImpl service;

    public CacheSettingServiceImpl(SettingServiceImpl service, CacheService cacheService) {
        this.settingCache = cacheService.getCacheInstance(SettingService.class.getSimpleName());
        Loader<SettingKey, SettingValue, SettingServiceImpl> loader = new Loader<SettingKey, SettingValue, SettingServiceImpl>(){

            public SettingValue retrieve(SettingServiceImpl service, SettingKey key) throws Exception {
                NullSettingValue settingValue = service.get(key.getContext(), key.getScope(), key.getKey());
                if (settingValue == null) {
                    settingValue = NullSettingValue.getInstance();
                }
                return settingValue;
            }
        };
        this.futureExoCache = new FutureExoCache((Loader)loader, this.settingCache);
        this.service = service;
    }

    public void set(Context context, Scope scope, String key, SettingValue<?> value) {
        SettingKey settingKey = new SettingKey(context, scope, key);
        this.settingCache.put((Serializable)settingKey, value);
        this.service.set(context, scope, key, value);
    }

    public SettingValue<?> get(Context context, Scope scope, String key) {
        SettingValue settingValue = (SettingValue)this.futureExoCache.get((Object)this.service, (Object)new SettingKey(context, scope, key));
        if (settingValue == NullSettingValue.getInstance() || settingValue.getValue() == null) {
            return null;
        }
        return settingValue;
    }

    public void remove(Context context, Scope scope, String key) {
        SettingKey settingKey = new SettingKey(context, scope, key);
        this.settingCache.remove((Serializable)settingKey);
        this.service.remove(context, scope, key);
    }

    public void remove(Context context, Scope scope) {
        SettingScope settingScope = new SettingScope(context, scope);
        try {
            this.settingCache.select((CachedObjectSelector)new SettingCacheSelector((SettingContext)settingScope));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot get setting cache", (Throwable)e);
        }
        this.service.remove(context, scope);
    }

    public void remove(Context context) {
        SettingContext settingContext = new SettingContext(context);
        try {
            this.settingCache.select((CachedObjectSelector)new SettingCacheSelector(settingContext));
        }
        catch (Exception e) {
            LOG.error((Object)"cannot get setting context", (Throwable)e);
        }
        this.service.remove(context);
    }
}

