/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@ThreadSafe
public class ResourceEntityResolver
implements EntityResolver {
    public static final String MML2_SYSTEMID = "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd";
    public static final String MML2_PUBLICID = "-//W3C//DTD MathML 2.0//EN";
    private static final String MML1_SYSTEMID_PATH = "http://www.w3.org/Math/DTD/mathml1";
    private static final Map<String, String> PUBLIC_ID_TO_INTERNAL = new HashMap<String, String>();
    private static final Map<String, String> PUBLIC_ID_TO_SYSYEM = new HashMap<String, String>();

    public InputSource resolveEntity(String string, String string2) {
        InputSource inputSource = null;
        String string3 = PUBLIC_ID_TO_INTERNAL.get(string);
        if (string3 == null && string2.startsWith(MML1_SYSTEMID_PATH)) {
            string3 = "/mathml.1.0.1" + string2.substring(MML1_SYSTEMID_PATH.length());
        }
        if (string3 != null) {
            inputSource = this.loadMappedResource(string, string2, string3);
        }
        return inputSource;
    }

    private InputSource loadMappedResource(String string, String string2, String string3) {
        InputSource inputSource = null;
        InputStream inputStream = ResourceEntityResolver.class.getResourceAsStream(string3);
        if (inputStream != null) {
            inputSource = new InputSource(inputStream);
            inputSource.setPublicId(string);
            String string4 = PUBLIC_ID_TO_SYSYEM.get(string);
            if (string4 == null) {
                string4 = string2;
            }
            inputSource.setSystemId(string4);
        }
        return inputSource;
    }

    static {
        PUBLIC_ID_TO_INTERNAL.put("-//OpenOffice.org//DTD Modified W3C MathML 1.01//EN", "/openoffice.mathml.1.0.1/math.dtd");
        PUBLIC_ID_TO_INTERNAL.put(MML2_PUBLICID, "/mathml.2.0/mathml2.dtd");
        PUBLIC_ID_TO_SYSYEM.put(MML2_PUBLICID, MML2_SYSTEMID);
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES MathML 2.0 Qualified Names 1.0//EN", "/mathml.2.0/mathml2-qname-1.mod");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Arrow Relations for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamsa.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Binary Operators for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamsb.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Delimiters for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamsc.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Negated Relations for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamsn.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Ordinary for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamso.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Math Symbols: Relations for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isoamsr.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Greek Symbols for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isogrk3.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Math Alphabets: Fraktur for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isomfrk.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Math Alphabets: Open Face for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isomopf.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Math Alphabets: Script for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isomscr.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES General Technical for MathML 2.0//EN", "/mathml.2.0/iso9573-13/isotech.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Box and Line Drawing for MathML 2.0//EN", "/mathml.2.0/iso8879/isobox.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Russian Cyrillic for MathML 2.0//EN", "/mathml.2.0/iso8879/isocyr1.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Non-Russian Cyrillic for MathML 2.0//EN", "/mathml.2.0/iso8879/isocyr2.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Diacritical Marks for MathML 2.0//EN", "/mathml.2.0/iso8879/isodia.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Latin 1 for MathML 2.0//EN", "/mathml.2.0/iso8879/isolat1.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Added Latin 2 for MathML 2.0//EN", "/mathml.2.0/iso8879/isolat2.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Numeric and Special Graphic for MathML 2.0//EN", "/mathml.2.0/iso8879/isonum.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Publishing for MathML 2.0//EN", "/mathml.2.0/iso8879/isopub.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Extra for MathML 2.0//EN", "/mathml.2.0/mathml/mmlextra.ent");
        PUBLIC_ID_TO_INTERNAL.put("-//W3C//ENTITIES Aliases for MathML 2.0//EN", "/mathml.2.0/mathml/mmlalias.ent");
    }
}

