/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.CharConverter;
import net.sourceforge.jeuclid.elements.support.text.CharacterMapping;
import net.sourceforge.jeuclid.elements.support.text.CodePointAndVariant;

public final class StringUtil {
    public static final boolean OSX = System.getProperty("mrj.version") != null;
    static final CharacterMapping CMAP = CharacterMapping.getInstance();

    private StringUtil() {
    }

    public static AttributedString convertStringtoAttributedString(String string, MathVariant mathVariant, float f, LayoutContext layoutContext) {
        Font font;
        if (string == null) {
            return new AttributedString("");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Font> arrayList = new ArrayList<Font>();
        String string2 = CharConverter.convertLate(string);
        for (int i = 0; i < string2.length(); ++i) {
            if (Character.isLowSurrogate(string2.charAt(i))) continue;
            CodePointAndVariant codePointAndVariant = new CodePointAndVariant(string2.codePointAt(i), mathVariant);
            Object[] objectArray = StringUtil.mapCpavToCpaf(codePointAndVariant, f, layoutContext);
            int c = (Integer)objectArray[0];
            font = (Font)objectArray[1];
            stringBuilder.appendCodePoint(c);
            arrayList.add(font);
            if (!Character.isSupplementaryCodePoint(c)) continue;
            arrayList.add(font);
        }
        AttributedString attributedString = new AttributedString(stringBuilder.toString());
        int n = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuilder.charAt(i);
            if (Character.isLowSurrogate(c)) continue;
            font = (Font)arrayList.get(i);
            int n2 = Character.isHighSurrogate(c) ? 2 : 1;
            attributedString.addAttribute(TextAttribute.FONT, font, i, i + n2);
        }
        return attributedString;
    }

    private static Object[] mapCpavToCpaf(CodePointAndVariant codePointAndVariant, float f, LayoutContext layoutContext) {
        List<CodePointAndVariant> list = CMAP.getAllAlternatives(codePointAndVariant);
        Font font = null;
        int n = 0;
        Iterator<CodePointAndVariant> iterator = list.iterator();
        boolean bl = true;
        while (bl) {
            CodePointAndVariant codePointAndVariant2 = iterator.next();
            if (iterator.hasNext()) {
                n = codePointAndVariant2.getCodePoint();
                font = codePointAndVariant2.getVariant().createFont(f, n, layoutContext, false);
                if (font == null) continue;
                bl = false;
                continue;
            }
            n = codePointAndVariant2.getCodePoint();
            font = codePointAndVariant2.getVariant().createFont(f, n, layoutContext, true);
            bl = false;
        }
        return new Object[]{n, font};
    }

    public static TextLayout createTextLayoutFromAttributedString(Graphics2D graphics2D, AttributedString attributedString, LayoutContext layoutContext) {
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        boolean bl = attributedCharacterIterator.first() == '\uffff';
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        boolean bl2 = (Boolean)layoutContext.getParameter(Parameter.ANTIALIAS);
        if (!bl && (object = (Font)attributedString.getIterator().getAttribute(TextAttribute.FONT)) != null) {
            float f;
            float f2 = ((Font)object).getSize2D();
            bl2 &= f2 >= (f = ((Float)layoutContext.getParameter(Parameter.ANTIALIAS_MINSIZE)).floatValue());
        }
        object = new FontRenderContext(fontRenderContext.getTransform(), bl2, false);
        TextLayout textLayout = bl ? new TextLayout(" ", new Font("", 0, 0), (FontRenderContext)object) : new TextLayout(attributedString.getIterator(), (FontRenderContext)object);
        return textLayout;
    }

    public static float getWidthForTextLayout(TextLayout textLayout) {
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = (float)rectangle2D.getWidth();
        float f2 = (float)rectangle2D.getX();
        if (f2 > 0.0f) {
            f += f2;
        }
        float f3 = textLayout.getAdvance() - textLayout.getVisibleAdvance();
        return f + f3;
    }

    public static TextLayoutInfo getTextLayoutInfo(TextLayout textLayout, boolean bl) {
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f = (float)(-rectangle2D.getY());
        float f2 = (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = (float)rectangle2D.getX();
        float f4 = f3 < 0.0f ? -f3 : (bl ? -f3 : 0.0f);
        float f5 = StringUtil.getWidthForTextLayout(textLayout);
        return new TextLayoutInfo(f, f2, f4, f5);
    }

    public static class TextLayoutInfo {
        private final float ascent;
        private final float descent;
        private final float offset;
        private final float width;

        protected TextLayoutInfo(float f, float f2, float f3, float f4) {
            this.ascent = f;
            this.descent = f2;
            this.offset = f3;
            this.width = f4;
        }

        public float getAscent() {
            return this.ascent;
        }

        public float getDescent() {
            return this.descent;
        }

        public float getOffset() {
            return this.offset;
        }

        public float getWidth() {
            return this.width;
        }
    }
}

