/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.localization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.gatein.common.i18n.LocaleFactory;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class LocaleContextInfoUtils {
    private static final String LOCALE_COOKIE = "LOCALE";
    private static final String PREV_LOCALE_SESSION_ATTR = "org.gatein.LAST_LOCALE";
    private static final String LOCALE_SESSION_ATTR = "org.gatein.LOCALE";
    private static final Logger LOG = LoggerFactory.getLogger(LocaleContextInfoUtils.class);

    public static LocaleContextInfo buildLocaleContextInfo(HttpServletRequest request) {
        LocaleContextInfo localeCtx = new LocaleContextInfo();
        localeCtx.setSupportedLocales(LocaleContextInfoUtils.getSupportedLocales());
        localeCtx.setPortalLocale(LocaleContextInfoUtils.getPortalLocale());
        if (request == null) {
            return localeCtx;
        }
        String username = request.getRemoteUser();
        String lastLocaleLangauge = LocaleContextInfoUtils.getPreviousLocale(request) == null ? null : LocaleContextInfoUtils.getPreviousLocale(request).toString();
        Locale sessionLocale = lastLocaleLangauge == null ? LocaleContextInfoUtils.getSessionLocale(request) : new Locale(lastLocaleLangauge);
        localeCtx.setSessionLocale(sessionLocale);
        localeCtx.setUserProfileLocale(LocaleContextInfoUtils.getUserLocale(username));
        localeCtx.setBrowserLocales(Collections.list(request.getLocales()));
        localeCtx.setCookieLocales(LocaleContextInfoUtils.getCookieLocales(request));
        localeCtx.setRemoteUser(username);
        return localeCtx;
    }

    public static LocaleContextInfo buildLocaleContextInfo(String userId) {
        LocaleContextInfo localeCtx = new LocaleContextInfo();
        localeCtx.setSupportedLocales(LocaleContextInfoUtils.getSupportedLocales());
        localeCtx.setUserProfileLocale(LocaleContextInfoUtils.getUserLocale(userId));
        localeCtx.setRemoteUser(userId);
        localeCtx.setPortalLocale(LocaleContextInfoUtils.getPortalLocale());
        return localeCtx;
    }

    public static List<Locale> getCookieLocales(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!LOCALE_COOKIE.equals(cookie.getName())) continue;
                ArrayList<Locale> locales = new ArrayList<Locale>();
                locales.add(LocaleContextInfo.getLocale((String)cookie.getValue()));
                return locales;
            }
        }
        return Collections.emptyList();
    }

    private static Locale getSessionLocale(HttpServletRequest request) {
        return LocaleContextInfoUtils.getLocaleFromSession(request, LOCALE_SESSION_ATTR);
    }

    private static Locale getPreviousLocale(HttpServletRequest request) {
        return LocaleContextInfoUtils.getLocaleFromSession(request, PREV_LOCALE_SESSION_ATTR);
    }

    public static Set<Locale> getSupportedLocales() {
        LocaleConfigService localeConfigService = (LocaleConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocaleConfigService.class);
        HashSet<Locale> supportedLocales = new HashSet<Locale>();
        if (localeConfigService != null) {
            for (LocaleConfig lc : localeConfigService.getLocalConfigs()) {
                supportedLocales.add(lc.getLocale());
            }
        }
        return supportedLocales;
    }

    private static Locale getLocaleFromSession(HttpServletRequest request, String attrName) {
        String lang = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            lang = (String)session.getAttribute(attrName);
        }
        return lang != null ? LocaleContextInfo.getLocale(lang) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale getUserLocale(String userId) {
        String lang = "";
        UserProfile profile = null;
        if (userId != null) {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            LocaleContextInfoUtils.beginContext(organizationService);
            try {
                profile = organizationService.getUserProfileHandler().findUserProfileByName(userId);
            }
            catch (Exception e) {
                LOG.debug((Object)(userId + " profile not found "), (Throwable)e);
            }
            finally {
                LocaleContextInfoUtils.endContext(organizationService);
            }
            if (profile != null) {
                lang = profile.getAttribute("user.language");
            }
            if (lang != null && lang.trim().length() > 0) {
                return LocaleFactory.DEFAULT_FACTORY.createLocale(lang);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Locale getPortalLocale() {
        String lang = "";
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(UserPortalConfigService.class);
        POMSessionManager pomSessionManager = (POMSessionManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(POMSessionManager.class);
        if (userPortalConfigService != null && pomSessionManager != null) {
            if (pomSessionManager.getSession() == null) {
                pomSessionManager.openSession();
            }
            try {
                PortalConfig config = userPortalConfigService.getDataStorage().getPortalConfig(userPortalConfigService.getDefaultPortal());
                if (config != null) {
                    lang = config.getLocale();
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"Can't load default portal config ", (Throwable)e);
            }
            finally {
                if (pomSessionManager.getSession() != null) {
                    pomSessionManager.getSession().close();
                }
            }
        }
        return lang != null && lang.trim().length() > 0 ? LocaleFactory.DEFAULT_FACTORY.createLocale(lang) : Locale.getDefault();
    }

    private static void beginContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)orgService));
        }
    }

    private static void endContext(OrganizationService orgService) {
        if (orgService instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

