/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.jsontoken;

import com.google.api.client.auth.jsontoken.JsonWebToken;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@Deprecated
public class JsonWebSignature
extends JsonWebToken {
    private final byte[] signatureBytes;
    private final byte[] signedContentBytes;

    public JsonWebSignature(Header header, JsonWebToken.Payload payload, byte[] signatureBytes, byte[] signedContentBytes) {
        super(header, payload);
        this.signatureBytes = signatureBytes;
        this.signedContentBytes = signedContentBytes;
    }

    public Header getHeader() {
        return (Header)super.getHeader();
    }

    public final byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public final byte[] getSignedContentBytes() {
        return this.signedContentBytes;
    }

    public static JsonWebSignature parse(JsonFactory jsonFactory, String tokenString) throws IOException {
        return JsonWebSignature.parser(jsonFactory).parse(tokenString);
    }

    public static Parser parser(JsonFactory jsonFactory) {
        return new Parser(jsonFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static final class Parser {
        private final JsonFactory jsonFactory;
        private Class<? extends Header> headerClass = Header.class;
        private Class<? extends JsonWebToken.Payload> payloadClass = JsonWebToken.Payload.class;

        public Parser(JsonFactory jsonFactory) {
            this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory);
        }

        public Class<? extends Header> getHeaderClass() {
            return this.headerClass;
        }

        public Parser setHeaderClass(Class<? extends Header> headerClass) {
            this.headerClass = headerClass;
            return this;
        }

        public Class<? extends JsonWebToken.Payload> getPayloadClass() {
            return this.payloadClass;
        }

        public Parser setPayloadClass(Class<? extends JsonWebToken.Payload> payloadClass) {
            this.payloadClass = payloadClass;
            return this;
        }

        public JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public JsonWebSignature parse(String tokenString) throws IOException {
            int firstDot = tokenString.indexOf(46);
            Preconditions.checkArgument((firstDot != -1 ? 1 : 0) != 0);
            byte[] headerBytes = Base64.decodeBase64((String)tokenString.substring(0, firstDot));
            int secondDot = tokenString.indexOf(46, firstDot + 1);
            Preconditions.checkArgument((secondDot != -1 ? 1 : 0) != 0);
            Preconditions.checkArgument((tokenString.indexOf(46, secondDot + 1) == -1 ? 1 : 0) != 0);
            byte[] payloadBytes = Base64.decodeBase64((String)tokenString.substring(firstDot + 1, secondDot));
            byte[] signatureBytes = Base64.decodeBase64((String)tokenString.substring(secondDot + 1));
            byte[] signedContentBytes = StringUtils.getBytesUtf8((String)tokenString.substring(0, secondDot));
            Header header = (Header)((Object)this.jsonFactory.fromInputStream((InputStream)new ByteArrayInputStream(headerBytes), this.headerClass));
            Preconditions.checkArgument((header.getAlgorithm() != null ? 1 : 0) != 0);
            JsonWebToken.Payload payload = (JsonWebToken.Payload)((Object)this.jsonFactory.fromInputStream((InputStream)new ByteArrayInputStream(payloadBytes), this.payloadClass));
            return new JsonWebSignature(header, payload, signatureBytes, signedContentBytes);
        }
    }

    @Deprecated
    public static class Header
    extends JsonWebToken.Header {
        @Key(value="alg")
        private String algorithm;
        @Key(value="jku")
        private String jwkUrl;
        @Key(value="kid")
        private String keyId;
        @Key(value="x5u")
        private String x509Url;
        @Key(value="x5t")
        private String x509Thumbprint;

        public Header setType(String type) {
            super.setType(type);
            return this;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public Header setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public String getJwkUrl() {
            return this.jwkUrl;
        }

        public Header setJwkUrl(String jwkUrl) {
            this.jwkUrl = jwkUrl;
            return this;
        }

        public String getKeyId() {
            return this.keyId;
        }

        public Header setKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public String getX509Url() {
            return this.x509Url;
        }

        public Header setX509Url(String x509Url) {
            this.x509Url = x509Url;
            return this;
        }

        public String getX509Thumbprint() {
            return this.x509Thumbprint;
        }

        public Header setX509Thumbprint(String x509Thumbprint) {
            this.x509Thumbprint = x509Thumbprint;
            return this;
        }

        public Header set(String fieldName, Object value) {
            return (Header)super.set(fieldName, value);
        }

        public Header clone() {
            return (Header)super.clone();
        }
    }
}

