/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.ElasticSearchFilter;
import org.exoplatform.commons.search.es.ElasticSearchFilterType;
import org.exoplatform.commons.search.es.ElasticSearchServiceConnector;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.service.search.SearchResult;
import org.exoplatform.wiki.service.search.SearchResultType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class WikiElasticSearchServiceConnector
extends ElasticSearchServiceConnector {
    private static final Log LOG = ExoLogger.getLogger(WikiElasticSearchServiceConnector.class);
    private static final String INDEX = "wiki";
    private static final String TYPE = "wiki,wiki-page,wiki-attachment";
    private static final String[] SEARCH_FIELDS = new String[]{"name", "title", "content", "comment", "file.content"};

    public WikiElasticSearchServiceConnector(InitParams initParams, ElasticSearchingClient client) {
        super(initParams, client);
        this.setIndex(INDEX);
        this.setType(TYPE);
        this.setSearchFields(new ArrayList<String>(Arrays.asList(SEARCH_FIELDS)));
    }

    protected String getSourceFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("title");
        fields.add("url");
        fields.add("wikiType");
        fields.add("wikiOwner");
        fields.add("createdDate");
        fields.add("updatedDate");
        fields.add("name");
        fields.add("pageName");
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (String sourceField : fields) {
            sourceFields.add("\"" + sourceField + "\"");
        }
        return StringUtils.join(sourceFields, (String)",");
    }

    public List<SearchResult> searchWiki(String searchedText, String wikiType, String wikiOwner, int offset, int limit, String sort, String order) {
        ArrayList<ElasticSearchFilter> filters = new ArrayList<ElasticSearchFilter>();
        filters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_BY_TERM, "wikiType", wikiType));
        filters.add(new ElasticSearchFilter(ElasticSearchFilterType.FILTER_BY_TERM, "wikiOwner", wikiOwner));
        List<SearchResult> searchResults = this.filteredWikiSearch(null, searchedText, filters, null, offset, limit, sort, order);
        return searchResults;
    }

    protected List<SearchResult> filteredWikiSearch(SearchContext context, String query, List<ElasticSearchFilter> filters, Collection<String> sites, int offset, int limit, String sort, String order) {
        String esQuery = this.buildFilteredQuery(query, sites, filters, offset, limit, sort, order);
        String jsonResponse = this.getClient().sendRequest(esQuery, this.getIndex(), this.getType());
        return this.buildWikiResult(jsonResponse);
    }

    protected List<SearchResult> buildWikiResult(String jsonResponse) {
        Map json;
        ArrayList<SearchResult> wikiResults = new ArrayList<SearchResult>();
        JSONParser parser = new JSONParser();
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            long score = ((Double)((JSONObject)jsonHit).get((Object)"_score")).longValue();
            JSONObject hitSource = (JSONObject)((JSONObject)jsonHit).get((Object)"_source");
            String title = (String)hitSource.get((Object)"title");
            String url = (String)hitSource.get((Object)"url");
            String wikiType = (String)hitSource.get((Object)"wikiType");
            String wikiOwner = (String)hitSource.get((Object)"wikiOwner");
            Calendar createdDate = Calendar.getInstance();
            createdDate.setTimeInMillis(Long.parseLong((String)hitSource.get((Object)"createdDate")));
            Calendar updatedDate = Calendar.getInstance();
            updatedDate.setTimeInMillis(Long.parseLong((String)hitSource.get((Object)"updatedDate")));
            SearchResultType type = SearchResultType.PAGE;
            String pageName = (String)hitSource.get((Object)"name");
            String attachmentName = null;
            if (((JSONObject)jsonHit).get((Object)"_type").equals("wiki-attachment")) {
                pageName = (String)hitSource.get((Object)"pageName");
                attachmentName = (String)hitSource.get((Object)"name");
            }
            JSONObject hitHighlight = (JSONObject)((JSONObject)jsonHit).get((Object)"highlight");
            StringBuilder excerpt = new StringBuilder();
            if (hitHighlight != null) {
                for (String key : hitHighlight.keySet()) {
                    JSONArray highlights = (JSONArray)hitHighlight.get((Object)key);
                    for (Object highlight : highlights) {
                        excerpt.append("... ").append(highlight);
                    }
                }
            }
            SearchResult wikiSearchResult = new SearchResult();
            wikiSearchResult.setWikiType(wikiType);
            wikiSearchResult.setWikiOwner(wikiOwner);
            wikiSearchResult.setPageName(pageName);
            wikiSearchResult.setAttachmentName(attachmentName);
            wikiSearchResult.setExcerpt(excerpt.toString());
            wikiSearchResult.setTitle(title);
            wikiSearchResult.setType(type);
            wikiSearchResult.setCreatedDate(createdDate);
            wikiSearchResult.setUpdatedDate(updatedDate);
            wikiSearchResult.setUrl(url);
            wikiSearchResult.setScore(score);
            wikiResults.add(wikiSearchResult);
        }
        return wikiResults;
    }
}

