/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIItemSelector;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/portal/webui/portal/UISkinSelector.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UISkinSelector
extends UIContainer {
    private String name_ = "UIChangeSkin";

    public UISkinSelector() {
        UIPortal uiPortal = Util.getUIPortal();
        ArrayList<Object> itemCategories = new ArrayList<Object>();
        SkinService skinService = (SkinService)uiPortal.getApplicationComponent(SkinService.class);
        for (String skin : skinService.getAvailableSkinNames()) {
            SelectItemCategory skinCategory = new SelectItemCategory(skin, false);
            skinCategory.addSelectItemOption(new SelectItemOption(skin, (Object)skin, skin));
            itemCategories.add(skinCategory);
        }
        ((SelectItemCategory)itemCategories.get(0)).setSelected(true);
        UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
        String currentSkin = uiPortalApp.getSkin();
        if (currentSkin == null) {
            currentSkin = "Default";
        }
        for (SelectItemCategory selectItemCategory : itemCategories) {
            if (selectItemCategory.getName().equals(currentSkin)) {
                selectItemCategory.setSelected(true);
                continue;
            }
            selectItemCategory.setSelected(false);
        }
        UIItemSelector selector = new UIItemSelector("Skin");
        selector.setItemCategories(itemCategories);
        selector.setRendered(true);
        this.addChild((UIComponent)selector);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public static class SaveActionListener
    extends EventListener<UISkinSelector> {
        public void execute(Event<UISkinSelector> event) throws Exception {
            WebuiRequestContext rContext = event.getRequestContext();
            String skin = rContext.getRequestParameter("skin");
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            uiMaskWS.createEvent("Close", Event.Phase.DECODE, rContext).broadcast();
            Util.getPortalRequestContext().ignoreAJAXUpdateOnPortlets(false);
            if (skin == null || skin.trim().length() < 1) {
                return;
            }
            uiApp.setSkin(skin);
            String remoteUser = rContext.getRemoteUser();
            OrganizationService orgService = (OrganizationService)((UISkinSelector)((Object)event.getSource())).getApplicationComponent(OrganizationService.class);
            if (remoteUser != null) {
                UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(remoteUser);
                if (userProfile == null) {
                    userProfile = orgService.getUserProfileHandler().createUserProfileInstance(remoteUser);
                }
                userProfile.getUserInfoMap().put("user.skin", skin);
                UserProfileHandler hanlder = orgService.getUserProfileHandler();
                hanlder.saveUserProfile(userProfile, true);
            }
        }
    }
}

