/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class UnifiedSearchSocialProfileListener
extends ProfileListenerPlugin {
    private static Log log = ExoLogger.getLogger(UnifiedSearchSocialProfileListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchSocialProfileListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void avatarUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    public void createProfile(ProfileLifeCycleEvent profileLifeCycleEvent) {
        this.profileUpdated(profileLifeCycleEvent);
    }

    protected void profileUpdated(ProfileLifeCycleEvent profileLifeCycleEvent) {
        if (this.indexingService != null) {
            HashMap<String, Profile> content = new HashMap<String, Profile>();
            content.put("profile", profileLifeCycleEvent.getProfile());
            SearchEntryId searchEntryId = new SearchEntryId("social", "profile", profileLifeCycleEvent.getProfile().getId());
            this.indexingService.update(searchEntryId, content);
        }
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
    }
}

