/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RSyncJob {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.RsyncJob");
    private static final String RSYNC_USER_SYSTEM_PROPERTY = "USER";
    private static final String RSYNC_PASSWORD_SYSTEM_PROPERTY = "RSYNC_PASSWORD";
    private Process process;
    private final String src;
    private final String dst;
    private String userName;
    private String password;

    public RSyncJob(String src, String dst, String userName, String password) {
        this.src = src.endsWith(File.separator) ? src : src + File.separator;
        this.dst = dst;
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        Runtime run = Runtime.getRuntime();
        try {
            String command = "rsync -rv --delete " + this.src + " " + this.dst;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Rsync job started: " + command));
            }
            if (this.userName != null && this.password != null) {
                String[] envProperties = new String[]{"USER=" + this.userName, "RSYNC_PASSWORD=" + this.password};
                this.process = run.exec(command, envProperties);
            } else {
                this.process = run.exec(command);
            }
            InputStream stderr = this.process.getErrorStream();
            InputStreamReader isrErr = new InputStreamReader(stderr);
            BufferedReader brErr = new BufferedReader(isrErr);
            InputStream stdout = this.process.getInputStream();
            InputStreamReader isrStd = new InputStreamReader(stdout);
            BufferedReader brStd = new BufferedReader(isrStd);
            String val = null;
            StringBuilder stringBuilderErr = new StringBuilder();
            StringBuilder stringBuilderStd = new StringBuilder();
            while ((val = brStd.readLine()) != null) {
                stringBuilderStd.append(val);
                stringBuilderStd.append('\n');
            }
            while ((val = brErr.readLine()) != null) {
                stringBuilderErr.append(val);
                stringBuilderErr.append('\n');
            }
            Integer returnCode = null;
            while (returnCode == null) {
                try {
                    returnCode = this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Rsync job finished: " + returnCode + ". Error stream output \n" + stringBuilderErr.toString() + " Standard stream output \n" + stringBuilderStd.toString()));
            }
            if (returnCode != 0) {
                throw new IOException("RSync job finished with exit code is " + returnCode + ". Error stream output: \n" + stringBuilderErr.toString());
            }
        }
        finally {
            this.process = null;
        }
    }

    public void forceCancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

