/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.ispn;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.Indexer;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.ispn.ChangesKey;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.AbstractCacheStoreConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.util.concurrent.FutureListener;

public abstract class AbstractIndexerCacheStore
extends AbstractCacheStore {
    protected final Map<String, Indexer> indexers = new HashMap<String, Indexer>();
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");

    public void register(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.indexers.put(searchManager.getWsId(), new Indexer(searchManager, parentSearchManager, handler, parentHandler));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register " + searchManager.getWsId() + " " + (Object)((Object)this) + " in " + this.indexers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        if (entry.getKey() instanceof ChangesKey && entry.getValue() instanceof ChangesFilterListsWrapper) {
            ChangesKey key;
            block7: {
                if (LOG.isDebugEnabled()) {
                    LOG.info((Object)"Received list wrapper, start indexing...");
                }
                ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)entry.getValue();
                key = (ChangesKey)entry.getKey();
                try {
                    Indexer indexer = this.indexers.get(key.getWsId());
                    if (indexer == null) {
                        LOG.warn((Object)("No indexer could be found for the cache entry " + key.toString()));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("The current content of the map of indexers is " + this.indexers));
                        }
                        break block7;
                    }
                    if (wrapper.withChanges()) {
                        indexer.updateIndex(wrapper.getChanges(), wrapper.getParentChanges());
                        break block7;
                    }
                    indexer.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
                }
                catch (Throwable throwable) {
                    this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)key).attachListener((FutureListener)new FutureListener<Object>(key){
                        final /* synthetic */ ChangesKey val$key;
                        {
                            this.val$key = changesKey;
                        }

                        public void futureDone(Future<Object> future) {
                            if (AbstractIndexerCacheStore.this.cache.containsKey((Object)this.val$key)) {
                                LOG.debug((Object)"The entry was not removed properly, it will try to remove it once again");
                                AbstractIndexerCacheStore.this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).remove((Object)this.val$key);
                            }
                        }
                    });
                    throw throwable;
                }
            }
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.IGNORE_RETURN_VALUES}).removeAsync((Object)key).attachListener((FutureListener)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void stop() throws CacheLoaderException {
        this.indexers.clear();
        super.stop();
    }

    public abstract IndexerIoModeHandler getModeHandler();

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return AbstractCacheStoreConfig.class;
    }

    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    protected void purgeInternal() throws CacheLoaderException {
    }

    public void clear() throws CacheLoaderException {
        throw new UnsupportedOperationException("This operation is not supported by this component.");
    }

    public boolean remove(Object key) throws CacheLoaderException {
        return true;
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        return null;
    }

    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        return Collections.emptySet();
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return Collections.emptySet();
    }

    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        return Collections.emptySet();
    }
}

