/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.NameQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.hits.AbstractHitCollector;

class DerefQuery
extends Query {
    private static final long serialVersionUID = 3414283404598890177L;
    private final Query contextQuery;
    private final String refProperty;
    private final InternalQName nameTest;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    DerefQuery(Query context, String refProperty, InternalQName nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this.contextQuery = context;
        this.refProperty = refProperty;
        this.nameTest = nameTest;
        this.version = version;
        this.nsMappings = nsMappings;
    }

    public Weight createWeight(Searcher searcher) {
        return new DerefWeight(searcher);
    }

    public String toString(String field) {
        return "DerefQuery";
    }

    public void extractTerms(Set<Term> terms) {
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query cQuery = this.contextQuery.rewrite(reader);
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new DerefQuery(cQuery, this.refProperty, this.nameTest, this.version, this.nsMappings);
    }

    private class DerefScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private List<String> uuids;
        private int nextDoc;

        protected DerefScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.uuids = null;
            this.nextDoc = -1;
            this.reader = reader;
            this.hits = new BitSet(reader.maxDoc());
        }

        public int nextDoc() throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        public int docID() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public int advance(int target) throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateChildren();
            this.nextDoc = this.hits.nextSetBit(target);
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateChildren() throws IOException {
            if (this.uuids == null) {
                this.uuids = new ArrayList<String>();
                DerefQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){

                    @Override
                    protected void collect(int doc, float score) {
                        DerefScorer.this.hits.set(doc);
                    }
                });
                final BitSet nameTestHits = new BitSet();
                if (DerefQuery.this.nameTestScorer != null) {
                    DerefQuery.this.nameTestScorer.score((Collector)new AbstractHitCollector(){

                        @Override
                        protected void collect(int doc, float score) {
                            nameTestHits.set(doc);
                        }
                    });
                }
                String prefix = FieldNames.createNamedValue(DerefQuery.this.refProperty, "");
                int i = this.hits.nextSetBit(0);
                while (i >= 0) {
                    String[] values = this.reader.document(i).getValues(FieldNames.PROPERTIES);
                    if (values != null) {
                        for (String value : values) {
                            if (!value.startsWith(prefix)) continue;
                            this.uuids.add(value.substring(prefix.length()));
                        }
                    }
                    i = this.hits.nextSetBit(i + 1);
                }
                this.hits.clear();
                for (String uuid : this.uuids) {
                    try (TermDocs node = this.reader.termDocs(new Term(FieldNames.UUID, uuid));){
                        while (node.next()) {
                            this.hits.set(node.doc());
                        }
                    }
                }
                if (DerefQuery.this.nameTestScorer != null) {
                    this.hits.and(nameTestHits);
                }
            }
        }
    }

    private class DerefWeight
    extends Weight {
        private static final long serialVersionUID = 8633819810846476967L;
        private final Searcher searcher;

        private DerefWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DerefQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DerefQuery.this.contextScorer = DerefQuery.this.contextQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            if (DerefQuery.this.nameTest != null) {
                DerefQuery.this.nameTestScorer = new NameQuery(DerefQuery.this.nameTest, DerefQuery.this.version, DerefQuery.this.nsMappings).weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            }
            return new DerefScorer(this.searcher.getSimilarity(), reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

