/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.CloseableHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocOrderScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineIOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineRepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiColumnQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.RowIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.exoplatform.services.security.IdentityConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryResultImpl
implements QueryResult {
    private static final Logger LOG = LoggerFactory.getLogger((String)"exo.jcr.component.core.QueryResultImpl");
    protected final SearchIndex index;
    protected final SessionDataManager itemMgr;
    protected final SessionImpl session;
    protected final AccessManager accessMgr;
    protected final AbstractQueryImpl queryImpl;
    protected final SpellSuggestion spellSuggestion;
    protected final InternalQName[] selectProps;
    protected final QPath[] orderProps;
    protected final boolean[] orderSpecs;
    private final List<ScoreNode[]> resultNodes = new ArrayList<ScoreNode[]>();
    private int numResults = -1;
    private InternalQName[] selectorNames;
    private int invalid = 0;
    protected final boolean docOrder;
    private ExcerptProvider excerptProvider;
    private final long offset;
    private final long limit;
    private final boolean isSystemSession;

    public QueryResultImpl(SearchIndex index, SessionDataManager itemMgr, SessionImpl session, AccessManager accessMgr, AbstractQueryImpl queryImpl, SpellSuggestion spellSuggestion, InternalQName[] selectProps, QPath[] orderProps, boolean[] orderSpecs, boolean documentOrder, long offset, long limit) throws RepositoryException {
        this.index = index;
        this.itemMgr = itemMgr;
        this.session = session;
        this.accessMgr = accessMgr;
        this.queryImpl = queryImpl;
        this.spellSuggestion = spellSuggestion;
        this.selectProps = selectProps;
        this.orderProps = orderProps;
        this.orderSpecs = orderSpecs;
        this.docOrder = orderProps.length == 0 && documentOrder;
        this.offset = offset;
        this.limit = limit;
        this.isSystemSession = IdentityConstants.SYSTEM.equals(session.getUserID());
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = this.session.getLocationFactory().createJCRName(this.selectProps[i]).getAsString();
            }
            return propNames;
        }
        catch (NamespaceException npde) {
            String msg = "encountered invalid property name";
            LOG.debug(msg);
            throw new RepositoryException(msg, (Throwable)npde);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return new NodeIteratorImpl(this.itemMgr, this.getScoreNodes(), 0);
    }

    public RowIterator getRows() throws RepositoryException {
        if (this.excerptProvider == null) {
            try {
                this.excerptProvider = this.createExcerptProvider();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return new RowIteratorImpl(this.getScoreNodes(), this.selectProps, this.selectorNames, this.itemMgr, this.session.getLocationFactory(), this.excerptProvider, this.spellSuggestion, this.index.getContext().getCleanerHolder());
    }

    protected abstract MultiColumnQueryHits executeQuery(long var1) throws IOException, RepositoryException;

    protected abstract ExcerptProvider createExcerptProvider() throws IOException;

    private ScoreNodeIterator getScoreNodes() {
        if (this.docOrder) {
            return new DocOrderScoreNodeIterator(this.itemMgr, this.resultNodes, 0);
        }
        return new LazyScoreNodeIteratorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getResults(long size) throws RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getResults({}) limit={}", (Object)new Long(size), (Object)new Long(this.limit));
        }
        long maxResultSize = size;
        if (this.limit > 0L) {
            maxResultSize = this.limit;
        }
        if ((long)this.resultNodes.size() >= maxResultSize) {
            return;
        }
        CloseableHits result = null;
        try {
            long time = 0L;
            if (LOG.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            result = this.executeQuery(maxResultSize);
            if (LOG.isDebugEnabled()) {
                LOG.debug("query executed in {} ms", (Object)new Long(System.currentTimeMillis() - time));
            }
            this.selectorNames = result.getSelectorNames();
            if (this.resultNodes.isEmpty() && this.offset > 0L) {
                this.collectScoreNodes((MultiColumnQueryHits)result, new ArrayList<ScoreNode[]>(), this.offset, true);
            } else {
                int start = this.resultNodes.size() + this.invalid + (int)this.offset;
                result.skip(start);
            }
            if (LOG.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            this.collectScoreNodes((MultiColumnQueryHits)result, this.resultNodes, maxResultSize, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("retrieved ScoreNodes in {} ms", (Object)new Long(System.currentTimeMillis() - time));
            }
            this.numResults = result.getSize();
        }
        catch (IndexOfflineIOException e) {
            throw new IndexOfflineRepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.error("Exception while executing query: ", (Throwable)e);
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    LOG.warn("Unable to close query result: " + e);
                }
            }
        }
    }

    private void collectScoreNodes(MultiColumnQueryHits hits, List<ScoreNode[]> collector, long maxResults, boolean isOffset) throws IOException, RepositoryException {
        ScoreNode[] sn;
        while ((long)collector.size() < maxResults && (sn = hits.nextScoreNodes()) != null) {
            if (!this.docOrder && !isOffset || this.isAccessGranted(sn)) {
                collector.add(sn);
                continue;
            }
            ++this.invalid;
        }
    }

    private boolean isAccessGranted(ScoreNode[] nodes) throws RepositoryException {
        if (this.isSystemSession) {
            return true;
        }
        for (int i = 0; i < nodes.length; ++i) {
            try {
                NodeData nodeData;
                if (nodes[i] == null || (nodeData = (NodeData)this.itemMgr.getItemData(nodes[i].getNodeId())) != null && this.accessMgr.hasPermission(nodeData.getACL(), "read", this.session.getUserState().getIdentity())) continue;
                return false;
            }
            catch (ItemNotFoundException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("An exception occurred: " + e.getMessage());
            }
        }
        return true;
    }

    public int getTotalSize() {
        if (this.numResults == -1) {
            return -1;
        }
        return this.numResults - this.invalid;
    }

    private final class LazyScoreNodeIteratorImpl
    implements ScoreNodeIterator {
        private int position = -1;
        private boolean initialized = false;
        private ScoreNode[] next;

        private LazyScoreNodeIteratorImpl() {
        }

        @Override
        public ScoreNode[] nextScoreNodes() {
            this.initialize();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ScoreNode[] sn = this.next;
            this.fetchNext();
            return sn;
        }

        public void skip(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if (skipNum != 0L) {
                long expectedPosition = (long)this.position + skipNum;
                while ((long)this.position < expectedPosition) {
                    this.fetchNext();
                    if (this.next != null) continue;
                    throw new NoSuchElementException();
                }
            }
        }

        @Override
        public void skipBack(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if ((long)this.position - skipNum < 0L) {
                throw new NoSuchElementException();
            }
            if (skipNum != 0L) {
                this.position = (int)((long)this.position - (skipNum + 1L));
                this.fetchNext();
            }
        }

        public long getSize() {
            int total = QueryResultImpl.this.getTotalSize();
            if (total == -1) {
                return -1L;
            }
            long size = (long)total - QueryResultImpl.this.offset;
            if (QueryResultImpl.this.limit > 0L && size > QueryResultImpl.this.limit) {
                return QueryResultImpl.this.limit;
            }
            return size;
        }

        public long getPosition() {
            this.initialize();
            return this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.initialize();
            return this.next != null;
        }

        public Object next() {
            return this.nextScoreNodes();
        }

        private void initialize() {
            if (!this.initialized) {
                this.fetchNext();
                this.initialized = true;
            }
        }

        private void fetchNext() {
            this.next = null;
            int nextPos = this.position + 1;
            while (this.next == null) {
                if (nextPos >= QueryResultImpl.this.resultNodes.size()) {
                    if (QueryResultImpl.this.numResults != -1 && nextPos + QueryResultImpl.this.invalid >= QueryResultImpl.this.numResults) break;
                    try {
                        int num = QueryResultImpl.this.resultNodes.size() == 0 ? QueryResultImpl.this.index.getResultFetchSize() : QueryResultImpl.this.resultNodes.size() * 2;
                        QueryResultImpl.this.getResults(num);
                    }
                    catch (RepositoryException e) {
                        LOG.warn("Exception getting more results: " + (Object)((Object)e));
                    }
                    if (nextPos >= QueryResultImpl.this.resultNodes.size()) break;
                }
                this.next = (ScoreNode[])QueryResultImpl.this.resultNodes.get(nextPos);
                try {
                    if (QueryResultImpl.this.isAccessGranted(this.next)) continue;
                    this.next = null;
                    QueryResultImpl.this.invalid++;
                    QueryResultImpl.this.resultNodes.remove(nextPos);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("The node is invalid since we don't have sufficient rights to access it, it will be removed from the results set");
                }
                catch (RepositoryException e) {
                    LOG.error("Could not check access permission", (Throwable)e);
                    break;
                }
            }
            ++this.position;
        }
    }
}

