/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.directory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;

public class RAMDirectoryManager
implements DirectoryManager {
    private final Map<String, Directory> directories = new HashMap<String, Directory>();

    @Override
    public void init(SearchIndex handler) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDirectory(String name) throws IOException {
        Map<String, Directory> map = this.directories;
        synchronized (map) {
            return this.directories.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Directory getDirectory(String name) {
        Map<String, Directory> map = this.directories;
        synchronized (map) {
            Directory dir = this.directories.get(name);
            if (dir == null) {
                dir = new RAMDirectory();
                this.directories.put(name, dir);
            }
            return dir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDirectoryNames() throws IOException {
        Map<String, Directory> map = this.directories;
        synchronized (map) {
            return this.directories.keySet().toArray(new String[this.directories.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String name) {
        Map<String, Directory> map = this.directories;
        synchronized (map) {
            this.directories.remove(name);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(String from, String to) {
        Map<String, Directory> map = this.directories;
        synchronized (map) {
            if (this.directories.containsKey(to)) {
                return false;
            }
            Directory dir = this.directories.remove(from);
            if (dir == null) {
                return false;
            }
            this.directories.put(to, dir);
            return true;
        }
    }

    @Override
    public void dispose() {
    }
}

