/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataUtil;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.ValueOperation;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.DeleteValues;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileIOHelper;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.WriteValue;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;

public abstract class FileIOChannel
extends ValueFileIOHelper
implements ValueIOChannel {
    protected final File tempDir;
    protected final File rootDir;
    protected final FileCleaner cleaner;
    protected final ValueDataResourceHolder resources;
    protected final String storageId;
    protected final List<ValueOperation> changes = new ArrayList<ValueOperation>();

    public FileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
        this.storageId = storageId;
        this.resources = resources;
        this.tempDir = new File(rootDir, "temp");
    }

    @Override
    public void write(String propertyId, ValueData value, ChangedSizeHandler sizeHandler) throws IOException {
        WriteValue o = new WriteValue(this.getFile(propertyId, value.getOrderNumber()), value, this.resources, this.cleaner, this.tempDir, sizeHandler);
        o.execute();
        this.changes.add(o);
    }

    @Override
    public void delete(String propertyId) throws IOException {
        DeleteValues o = new DeleteValues(this.getFiles(propertyId), this.resources, this.cleaner, this.tempDir);
        o.execute();
        this.changes.add(o);
    }

    @Override
    public void prepare() throws IOException {
        for (ValueOperation vo : this.changes) {
            vo.prepare();
        }
    }

    @Override
    public void commit() throws IOException {
        try {
            for (ValueOperation vo : this.changes) {
                vo.commit();
            }
        }
        finally {
            this.changes.clear();
        }
    }

    @Override
    public void twoPhaseCommit() throws IOException {
        try {
            for (ValueOperation vo : this.changes) {
                vo.twoPhaseCommit();
            }
        }
        finally {
            this.changes.clear();
        }
    }

    @Override
    public void rollback() throws IOException {
        try {
            for (int p = this.changes.size() - 1; p >= 0; --p) {
                this.changes.get(p).rollback();
            }
        }
        finally {
            this.changes.clear();
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ValueDataUtil.ValueDataWrapper read(String propertyId, int orderNumber, int type, SpoolConfig spoolConfig) throws IOException {
        File file = this.getFile(propertyId, orderNumber);
        return ValueDataUtil.readValueData(type, orderNumber, file, spoolConfig);
    }

    @Override
    public void checkValueData(String propertyId, int orderNumber) throws ValueDataNotFoundException, IOException {
        File f = this.getFile(propertyId, orderNumber);
        if (!f.exists()) {
            throw new ValueDataNotFoundException("Value data corresponding to property with [id=" + propertyId + ", ordernum=" + orderNumber + "] does not exist.");
        }
    }

    @Override
    public void repairValueData(String propertyId, int orderNumber) throws IOException {
        File f = this.getFile(propertyId, orderNumber);
        if (!f.createNewFile()) {
            throw new IOException("Can not create empty file " + f.getAbsolutePath());
        }
    }

    @Override
    public long getValueSize(String propertyId, int orderNumber) throws IOException {
        File f = this.getFile(propertyId, orderNumber);
        return f.exists() ? f.length() : 0L;
    }

    @Override
    public long getValueSize(String propertyId) throws IOException {
        long size = 0L;
        for (File file : this.getFiles(propertyId)) {
            size += file.length();
        }
        return size;
    }

    protected abstract String makeFilePath(String var1, int var2);

    protected abstract File getFile(String var1, int var2) throws IOException;

    protected abstract File[] getFiles(String var1) throws IOException;

    @Override
    public String getStorageId() {
        return this.storageId;
    }
}

