/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class DeleteValues
extends ValueFileOperation {
    private static final AtomicLong SEQUENCE = new AtomicLong();
    private final File[] files;
    private ValueFileOperation.ValueFileLock[] locks;
    protected File[] bckFiles;

    public DeleteValues(File[] files, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        super(resources, cleaner, tempDir);
        this.files = files;
    }

    @Override
    public void execute() throws IOException {
        this.makePerformed();
        this.locks = new ValueFileOperation.ValueFileLock[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            ValueFileOperation.ValueFileLock fl = new ValueFileOperation.ValueFileLock(this.files[i]);
            fl.lock();
            this.locks[i] = fl;
        }
    }

    @Override
    public void prepare() throws IOException {
        if (this.locks != null) {
            this.bckFiles = new File[this.files.length];
            int length = this.files.length;
            for (int i = 0; i < length; ++i) {
                File file = this.files[i];
                if (!file.exists()) continue;
                this.bckFiles[i] = new File(file.getAbsolutePath() + "." + System.currentTimeMillis() + "_" + SEQUENCE.incrementAndGet());
                this.move(file, this.bckFiles[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        if (this.locks != null) {
            try {
                if (this.bckFiles == null) {
                    return;
                }
                int length = this.bckFiles.length;
                for (int i = 0; i < length; ++i) {
                    File f = this.bckFiles[i];
                    if (f == null) continue;
                    this.cleaner.removeFile(this.files[i]);
                    this.move(f, this.files[i]);
                }
            }
            finally {
                for (ValueFileOperation.ValueFileLock fl : this.locks) {
                    fl.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void twoPhaseCommit() throws IOException {
        if (this.locks != null) {
            try {
                if (this.bckFiles == null) {
                    return;
                }
                for (File f : this.bckFiles) {
                    if (f == null || f.delete()) continue;
                    this.cleaner.addFile(f);
                }
            }
            finally {
                for (ValueFileOperation.ValueFileLock fl : this.locks) {
                    fl.unlock();
                }
            }
        }
    }
}

