/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ActivityCommentPlugin", template="war:/intranet-notification/templates/ActivityCommentPlugin.gtmpl"), @TemplateConfig(pluginId="ActivityMentionPlugin", template="war:/intranet-notification/templates/ActivityMentionPlugin.gtmpl"), @TemplateConfig(pluginId="LikePlugin", template="war:/intranet-notification/templates/LikePlugin.gtmpl"), @TemplateConfig(pluginId="NewUserPlugin", template="war:/intranet-notification/templates/NewUserPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivityPlugin", template="war:/intranet-notification/templates/PostActivityPlugin.gtmpl"), @TemplateConfig(pluginId="PostActivitySpaceStreamPlugin", template="war:/intranet-notification/templates/PostActivitySpaceStreamPlugin.gtmpl"), @TemplateConfig(pluginId="RelationshipReceivedRequestPlugin", template="war:/intranet-notification/templates/RelationshipReceivedRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestJoinSpacePlugin", template="war:/intranet-notification/templates/RequestJoinSpacePlugin.gtmpl"), @TemplateConfig(pluginId="SpaceInvitationPlugin", template="war:/intranet-notification/templates/SpaceInvitationPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    private static final String ACCEPT_INVITATION_TO_CONNECT = "social/intranet-notification/confirmInvitationToConnect";
    private static final String REFUSE_INVITATION_TO_CONNECT = "social/intranet-notification/ignoreInvitationToConnect";
    private static final String VALIDATE_SPACE_REQUEST = "social/intranet-notification/validateRequestToJoinSpace";
    private static final String REFUSE_SPACE_REQUEST = "social/intranet-notification/refuseRequestToJoinSpace";
    private static final String ACCEPT_SPACE_INVITATION = "social/intranet-notification/acceptInvitationToJoinSpace";
    private static final String REFUSE_SPACE_INVITATION = "social/intranet-notification/ignoreInvitationToJoinSpace";
    private static final String MESSAGE_JSON_FILE_NAME = "message.json";
    private AbstractTemplateBuilder comment = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            boolean notHighLightComment;
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            ExoSocialActivity comment = null;
            if (activity.isComment()) {
                comment = activity;
                activity = Utils.getActivityManager().getParentActivity(comment);
                notification.with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId());
                notification.with(SocialNotificationUtils.COMMENT_ID.getKey(), comment.getId());
            } else {
                comment = Utils.getActivityManager().getActivity(notification.getValueOwnerParameter(SocialNotificationUtils.COMMENT_ID.getKey()));
            }
            String pluginId = notification.getKey().getId();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activity.getTitle(), (String)activity.getType()));
            templateContext.put((Object)"COMMENT", (Object)(ctx.getNotificationInfo().isOnPopOver() ? this.cutStringByMaxLength(comment.getTitle(), 30) : comment.getTitle()));
            List<String> users = SocialNotificationUtils.mergeUsers(ctx, templateContext, SocialNotificationUtils.POSTER.getKey(), activity.getId(), notification.getValueOwnerParameter(SocialNotificationUtils.POSTER.getKey()));
            int nbUsers = users.size();
            if (nbUsers > 0) {
                Identity lastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", users.get(nbUsers - 1), true);
                Profile profile = lastIdentity.getProfile();
                templateContext.put((Object)"USER", (Object)profile.getFullName());
                templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)lastIdentity.getRemoteId()));
                templateContext.put((Object)"NB_USERS", (Object)nbUsers);
                if (nbUsers >= 2) {
                    Identity beforeLastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", users.get(nbUsers - 2), true);
                    templateContext.put((Object)"LAST_USER", (Object)beforeLastIdentity.getProfile().getFullName());
                    if (nbUsers > 2) {
                        templateContext.put((Object)"COUNT", (Object)(nbUsers - 2));
                    }
                }
            }
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)((notHighLightComment = Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.NOT_HIGHLIGHT_COMMENT_PORPERTY.getKey())).booleanValue()) ? activity.getId() : activity.getId() + "#comment-" + comment.getId())));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        private String cutStringByMaxLength(String st, int maxLength) {
            if (st == null) {
                return st;
            }
            if ((st = StringEscapeUtils.unescapeHtml((String)st)).length() <= maxLength) {
                return st;
            }
            String noHtmlSt = st.replaceAll("\\<.*?\\>", "");
            if (noHtmlSt.length() <= maxLength) {
                return noHtmlSt;
            }
            return noHtmlSt.substring(0, maxLength) + "...";
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder mention = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)profile.getFullName());
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            String activityTitle = activity.getTitle();
            if (activity.isComment()) {
                ExoSocialActivity parentActivity = Utils.getActivityManager().getParentActivity(activity);
                activityTitle = parentActivity.getTitle();
                activityId = parentActivity.getId();
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)(activityId + "#comment-" + activity.getId())));
            } else {
                templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)activityId));
            }
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activityTitle, (String)activity.getType()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder like = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String pluginId = notification.getKey().getId();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activity.getTitle(), (String)activity.getType()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)activity.getId()));
            List<String> users = SocialNotificationUtils.mergeUsers(ctx, templateContext, SocialNotificationUtils.LIKER.getKey(), activity.getId(), notification.getValueOwnerParameter(SocialNotificationUtils.LIKER.getKey()));
            int nbUsers = users.size();
            if (nbUsers > 0) {
                Identity lastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", users.get(nbUsers - 1), true);
                Profile profile = lastIdentity.getProfile();
                templateContext.put((Object)"USER", (Object)profile.getFullName());
                templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
                templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)lastIdentity.getRemoteId()));
                templateContext.put((Object)"NB_USERS", (Object)nbUsers);
                if (nbUsers >= 2) {
                    Identity beforeLastIdentity = Utils.getIdentityManager().getOrCreateIdentity("organization", users.get(nbUsers - 2), true);
                    templateContext.put((Object)"LAST_USER", (Object)beforeLastIdentity.getProfile().getFullName());
                    if (nbUsers > 2) {
                        templateContext.put((Object)"COUNT", (Object)(nbUsers - 2));
                    }
                }
            }
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder newUser = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String remoteId = notification.getValueOwnerParameter(SocialNotificationUtils.REMOTE_ID.getKey());
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", remoteId, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            templateContext.put((Object)"PORTAL_NAME", (Object)NotificationPluginUtils.getBrandingPortalName());
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivity = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activity.getTitle(), (String)activity.getType()));
            templateContext.put((Object)"USER", (Object)profile.getFullName());
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)activity.getId()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder postActivitySpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
            ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
            Identity identity = Utils.getIdentityManager().getIdentity(activity.getPosterId(), true);
            Profile profile = identity.getProfile();
            Identity spaceIdentity = Utils.getIdentityManager().getOrCreateIdentity("space", activity.getStreamOwner(), true);
            Space space = Utils.getSpaceService().getSpaceByPrettyName(spaceIdentity.getRemoteId());
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)profile.getFullName());
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"ACTIVITY", (Object)NotificationUtils.getNotificationActivityTitle((String)activity.getTitle(), (String)activity.getType()));
            templateContext.put((Object)"SPACE", (Object)spaceIdentity.getProfile().getFullName());
            templateContext.put((Object)"SPACE_URL", (Object)LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)LinkProvider.getSingleActivityUrl((String)activity.getId()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder relationshipReceived = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String sender = notification.getValueOwnerParameter("sender");
            String status = notification.getValueOwnerParameter("status");
            String toUser = notification.getTo();
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", sender, true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProvider.getUserProfileUri((String)identity.getRemoteId()));
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"ACCEPT_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.ACCEPT_INVITATION_TO_CONNECT, sender, toUser, notification.getId(), WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            templateContext.put((Object)"REFUSE_CONNECTION_REQUEST_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.REFUSE_INVITATION_TO_CONNECT, sender, toUser, notification.getId(), WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder requestJoinSpace = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String status = notification.getValueOwnerParameter("status");
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getValueOwnerParameter("request_from"), true);
            Profile userProfile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"USER", (Object)userProfile.getFullName());
            templateContext.put((Object)"SPACE_URL", (Object)LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")));
            templateContext.put((Object)"AVATAR", (Object)(userProfile.getAvatarUrl() != null ? userProfile.getAvatarUrl() : "/eXoSkin/skin/images/system/UserAvtDefault.png"));
            templateContext.put((Object)"VALIDATE_SPACE_REQUEST_ACTION_URL", (Object)(LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.VALIDATE_SPACE_REQUEST, space.getId(), identity.getRemoteId()) + "/" + notification.getTo() + "/" + notification.getId() + "/" + WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            templateContext.put((Object)"REFUSE_SPACE_REQUEST_ACTION_URL", (Object)(LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.REFUSE_SPACE_REQUEST, space.getId(), identity.getRemoteId()) + "/" + notification.getTo() + "/" + notification.getId() + "/" + WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder spaceInvitation = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            String status = notification.getValueOwnerParameter("status");
            String spaceId = notification.getValueOwnerParameter(SocialNotificationUtils.SPACE_ID.getKey());
            Space space = Utils.getSpaceService().getSpaceById(spaceId);
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"STATUS", (Object)(status != null && status.equals("accepted") ? "ACCEPTED" : "PENDING"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"SPACE", (Object)space.getDisplayName());
            templateContext.put((Object)"SPACE_URL", (Object)LinkProvider.getActivityUriForSpace((String)space.getPrettyName(), (String)space.getGroupId().replace("/spaces/", "")));
            templateContext.put((Object)"SPACE_AVATAR", (Object)(space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png"));
            templateContext.put((Object)"ACCEPT_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.ACCEPT_SPACE_INVITATION, space.getId(), notification.getTo(), notification.getId(), WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            templateContext.put((Object)"REFUSE_SPACE_INVITATION_ACTION_URL", (Object)LinkProviderUtils.getWebNotificationRestUrl(WebTemplateProvider.REFUSE_SPACE_INVITATION, space.getId(), notification.getTo(), notification.getId(), WebTemplateProvider.MESSAGE_JSON_FILE_NAME));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"ActivityCommentPlugin"), this.comment);
        this.templateBuilders.put(PluginKey.key((String)"ActivityMentionPlugin"), this.mention);
        this.templateBuilders.put(PluginKey.key((String)"LikePlugin"), this.like);
        this.templateBuilders.put(PluginKey.key((String)"NewUserPlugin"), this.newUser);
        this.templateBuilders.put(PluginKey.key((String)"PostActivityPlugin"), this.postActivity);
        this.templateBuilders.put(PluginKey.key((String)"PostActivitySpaceStreamPlugin"), this.postActivitySpace);
        this.templateBuilders.put(PluginKey.key((String)"RelationshipReceivedRequestPlugin"), this.relationshipReceived);
        this.templateBuilders.put(PluginKey.key((String)"RequestJoinSpacePlugin"), this.requestJoinSpace);
        this.templateBuilders.put(PluginKey.key((String)"SpaceInvitationPlugin"), this.spaceInvitation);
    }
}

