/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.tools;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.velocity.context.AbstractContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.generic.ValueParser;
import org.apache.velocity.tools.view.context.ChainedContext;
import org.apache.velocity.tools.view.context.ViewContext;

public class ContextTool {
    public static final String SAFE_MODE_KEY = "safe-mode";
    protected ViewContext context;
    protected Map toolbox;
    protected HttpServletRequest request;
    protected HttpSession session;
    protected ServletContext application;
    private boolean safeMode = true;

    public void configure(Map params) {
        if (params != null) {
            ValueParser parser = new ValueParser(params);
            this.safeMode = parser.getBoolean(SAFE_MODE_KEY, true);
        }
    }

    public void init(Object obj) {
        this.context = (ViewContext)obj;
        this.request = this.context.getRequest();
        this.session = this.request.getSession(false);
        this.application = this.context.getServletContext();
    }

    public ViewContext getThis() {
        return this.context;
    }

    public Map getToolbox() {
        if (this.toolbox == null && this.context instanceof ChainedContext) {
            this.toolbox = ((ChainedContext)this.context).getToolbox();
        }
        return this.toolbox;
    }

    public Set getKeys() {
        HashSet<Object> keys = new HashSet<Object>();
        Map tools = this.getToolbox();
        if (tools != null) {
            keys.addAll(tools.keySet());
        }
        Context velctx = this.context.getVelocityContext();
        while (velctx != null) {
            Object[] ctxKeys = velctx.getKeys();
            keys.addAll(Arrays.asList(ctxKeys));
            if (velctx instanceof AbstractContext) {
                velctx = ((AbstractContext)velctx).getChainedContext();
                continue;
            }
            velctx = null;
        }
        Enumeration e = this.request.getAttributeNames();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        if (this.session != null) {
            e = this.session.getAttributeNames();
            while (e.hasMoreElements()) {
                keys.add(e.nextElement());
            }
        }
        e = this.application.getAttributeNames();
        while (e.hasMoreElements()) {
            keys.add(e.nextElement());
        }
        if (this.safeMode) {
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String key = String.valueOf(i.next());
                if (key.indexOf(46) < 0) continue;
                i.remove();
            }
        }
        return keys;
    }

    public Set getValues() {
        Set keys = this.getKeys();
        HashSet<Object> values = new HashSet<Object>(keys.size());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = String.valueOf(i.next());
            values.add(this.context.getVelocityContext().get(key));
        }
        return values;
    }

    public boolean contains(Object refName) {
        return this.get(refName) != null;
    }

    public Object get(Object refName) {
        String key = String.valueOf(refName);
        if (this.safeMode && key.indexOf(46) >= 0) {
            return null;
        }
        return this.context.getVelocityContext().get(key);
    }
}

