/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.chromattic;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.SynchronizedContext;

public class Synchronization {
    private final Map<String, Session> repositorySessions = new HashMap<String, Session>();
    private final Map<String, SynchronizedContext> contexts = new HashMap<String, SynchronizedContext>();
    private boolean saveOnClose = true;

    public SynchronizedContext getContext(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.contexts.get(name);
    }

    public SynchronizedContext openContext(ChromatticLifeCycle lifeCycle) throws IllegalStateException {
        if (lifeCycle == null) {
            throw new NullPointerException();
        }
        String name = lifeCycle.getDomainName();
        SynchronizedContext context = this.contexts.get(name);
        if (context != null) {
            throw new IllegalStateException();
        }
        context = new SynchronizedContext(lifeCycle, this);
        this.contexts.put(name, context);
        lifeCycle.onOpenSession(context);
        return context;
    }

    public Session doLogin(SynchronizedContext ctx) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (ctx.synchronization != this) {
            throw new IllegalArgumentException();
        }
        String workspaceName = ctx.lifeCycle.getWorkspaceName();
        Session session = this.repositorySessions.get(workspaceName);
        if (session == null) {
            session = ctx.openSession();
            this.repositorySessions.put(workspaceName, session);
        }
        return session;
    }

    public void close(ChromatticLifeCycle lifecycle, boolean save) {
        SynchronizedContext context = this.contexts.remove(lifecycle.getDomainName());
        context.close(save);
        lifecycle.onCloseSession(context);
    }

    public void close(boolean save) {
        SynchronizedContext[] array = new SynchronizedContext[this.contexts.size()];
        for (SynchronizedContext context : this.contexts.values().toArray(array)) {
            this.close(context.lifeCycle, save);
        }
        for (Session session : this.repositorySessions.values()) {
            session.logout();
        }
    }

    public boolean getSaveOnClose() {
        return this.saveOnClose;
    }

    public void setSaveOnClose(boolean saveOnClose) {
        this.saveOnClose = saveOnClose;
    }
}

