/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.infinispan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.lock.LockTableHandler;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.LockData;
import org.exoplatform.services.jcr.impl.core.lock.infinispan.ISPNLockTableHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.infinispan.ISPNCacheFactory;
import org.exoplatform.services.jcr.infinispan.PrivilegedISPNCacheHelper;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.TransactionService;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;

@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class ISPNCacheableLockManagerImpl
extends AbstractCacheableLockManager {
    public static final String INFINISPAN_JDBC_CL_DATASOURCE = "infinispan-cl-cache.jdbc.datasource";
    public static final String INFINISPAN_JDBC_CL_DIALECT = "infinispan-cl-cache.jdbc.dialect";
    public static final String INFINISPAN_JDBC_CL_DATA_COLUMN = "infinispan-cl-cache.jdbc.data.type";
    public static final String INFINISPAN_JDBC_CL_TIMESTAMP_COLUMN = "infinispan-cl-cache.jdbc.timestamp.type";
    public static final String INFINISPAN_JDBC_CL_ID_COLUMN = "infinispan-cl-cache.jdbc.id.type";
    public static final String INFINISPAN_JDBC_CL_ID_COLUMN_NAME = "infinispan-cl-cache.jdbc.id.column";
    public static final String INFINISPAN_JDBC_TABLE_NAME = "infinispan-cl-cache.jdbc.table.name";
    public static final String INFINISPAN_JDBC_CL_AUTO = "auto";
    private AdvancedCache<Serializable, Object> cache;

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionService transactionService, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, transactionService.getTransactionManager(), cfm, lockRemoverHolder);
    }

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, (TransactionManager)null, cfm, lockRemoverHolder);
    }

    public ISPNCacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionManager transactionManager, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        super(dataManager, config, transactionManager, lockRemoverHolder);
        ISPNCacheFactory factory;
        if (config.getLockManager() != null) {
            factory = new ISPNCacheFactory(cfm, transactionManager);
            try {
                String dataSourceName = config.getLockManager().getParameterValue(INFINISPAN_JDBC_CL_DATASOURCE);
                this.dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
            }
            catch (NamingException e) {
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        } else {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        ISPNCacheFactory.configureCacheStore(config.getLockManager(), INFINISPAN_JDBC_CL_DATASOURCE, INFINISPAN_JDBC_CL_DATA_COLUMN, INFINISPAN_JDBC_CL_ID_COLUMN, INFINISPAN_JDBC_CL_TIMESTAMP_COLUMN, INFINISPAN_JDBC_CL_DIALECT);
        this.cache = factory.createCache("L" + config.getUniqueName().replace("_", ""), config.getLockManager()).getAdvancedCache();
        this.getNumLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Integer, Object>(){

            @Override
            public Integer execute(Object arg) {
                return ISPNCacheableLockManagerImpl.this.cache.size();
            }
        };
        this.hasLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, Object>(){

            @Override
            public Boolean execute(Object arg) {
                return !ISPNCacheableLockManagerImpl.this.cache.isEmpty();
            }
        };
        this.isLockLive = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, String>(){

            @Override
            public Boolean execute(String nodeId) {
                return ISPNCacheableLockManagerImpl.this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).containsKey((Object)nodeId);
            }
        };
        this.refresh = new AbstractCacheableLockManager.LockActionNonTxAware<Object, LockData>(){

            @Override
            public Object execute(LockData newLockData) throws LockException {
                Object oldValue = PrivilegedISPNCacheHelper.put((Cache<Serializable, Object>)ISPNCacheableLockManagerImpl.this.cache, (Serializable)((Object)newLockData.getNodeIdentifier()), newLockData);
                if (oldValue == null) {
                    throw new LockException("Can't refresh lock for node " + newLockData.getNodeIdentifier() + " since lock is not exist");
                }
                return null;
            }
        };
        this.lockExist = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, String>(){

            @Override
            public Boolean execute(String nodeId) throws LockException {
                return ISPNCacheableLockManagerImpl.this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).containsKey((Object)nodeId);
            }
        };
        this.getLockDataById = new AbstractCacheableLockManager.LockActionNonTxAware<LockData, String>(){

            @Override
            public LockData execute(String nodeId) throws LockException {
                return (LockData)ISPNCacheableLockManagerImpl.this.cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD}).get((Object)nodeId);
            }
        };
        this.getLockList = new AbstractCacheableLockManager.LockActionNonTxAware<List<LockData>, Object>(){

            @Override
            public List<LockData> execute(Object arg) throws LockException {
                Collection datas = ISPNCacheableLockManagerImpl.this.cache.values();
                ArrayList<LockData> locksData = new ArrayList<LockData>();
                for (Object lockData : datas) {
                    if (lockData == null) continue;
                    locksData.add((LockData)lockData);
                }
                return locksData;
            }
        };
    }

    @Override
    public void start() {
        PrivilegedISPNCacheHelper.start(this.cache);
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        PrivilegedISPNCacheHelper.stop(this.cache);
        ISPNCacheFactory.releaseUniqueInstance(this.cache.getCacheManager());
    }

    @Override
    protected synchronized void internalLock(String sessionId, String nodeIdentifier) throws LockException {
        CacheableSessionLockManager session = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
        if (session != null && session.containsPendingLock(nodeIdentifier)) {
            LockData lockData = session.getPendingLock(nodeIdentifier);
            LockData oldLockData = this.doPut(lockData);
            if (oldLockData != null) {
                throw new LockException("Unable to write LockData. Node [" + lockData.getNodeIdentifier() + "] already has LockData!");
            }
        } else {
            throw new LockException("No lock in pending locks");
        }
        session.notifyLockPersisted(nodeIdentifier);
    }

    @Override
    protected synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws LockException {
        LockData lData = this.getLockDataById(nodeIdentifier);
        if (lData != null) {
            this.doRemove(lData);
            CacheableSessionLockManager sessMgr = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
            if (sessMgr != null) {
                sessMgr.notifyLockRemoved(nodeIdentifier);
            }
        }
    }

    @Override
    protected LockData doPut(LockData lockData) {
        return (LockData)PrivilegedISPNCacheHelper.putIfAbsent(this.cache, (Serializable)((Object)lockData.getNodeIdentifier()), lockData);
    }

    @Override
    protected void doRemove(LockData lockData) {
        this.cache.remove((Object)lockData.getNodeIdentifier());
    }

    @Override
    protected boolean isAloneInCluster() {
        return this.cache.getRpcManager() == null || this.cache.getCacheManager().getMembers().size() == 1;
    }

    @Override
    protected void doClean() {
        if (this.cache.getStatus() == ComponentStatus.RUNNING) {
            for (LockData lockData : this.getLockList()) {
                this.doRemove(lockData);
            }
        }
    }

    @Override
    public LockTableHandler getLockTableHandler() {
        return new ISPNLockTableHandler(this.config, this.dataSource);
    }
}

