/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.NamePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.PathPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.PermissionPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.ReferencePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.BooleanPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CalendarPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.DoublePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LongPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.StringPersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;

public class ValueDataUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueDataWrapper readValueData(String cid, int type, int orderNumber, int version, InputStream content, SpoolConfig spoolConfig) throws IOException {
        SwapFile swapFile;
        int len;
        byte[] buffer;
        ValueDataWrapper vdDataWrapper;
        block10: {
            vdDataWrapper = new ValueDataWrapper();
            buffer = new byte[]{};
            byte[] spoolBuffer = new byte[32768];
            len = 0;
            OutputStream out = null;
            swapFile = null;
            try {
                int read;
                if (content == null) break block10;
                while ((read = content.read(spoolBuffer)) >= 0) {
                    if (out != null) {
                        out.write(spoolBuffer, 0, read);
                    } else if (len + read > spoolConfig.maxBufferSize) {
                        swapFile = SwapFile.get(spoolConfig.tempDirectory, cid + orderNumber + "." + version, spoolConfig.fileCleaner);
                        if (swapFile.isSpooled()) {
                            buffer = null;
                            break;
                        }
                        out = PrivilegedFileHelper.fileOutputStream((File)swapFile);
                        out.write(buffer, 0, len);
                        out.write(spoolBuffer, 0, read);
                        buffer = null;
                    } else {
                        byte[] newBuffer = new byte[len + read];
                        System.arraycopy(buffer, 0, newBuffer, 0, len);
                        System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                        buffer = newBuffer;
                    }
                    len += read;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                    swapFile.spoolDone();
                }
            }
        }
        vdDataWrapper.size = len;
        vdDataWrapper.value = swapFile != null ? new CleanableFilePersistedValueData(orderNumber, swapFile, spoolConfig) : ValueDataUtil.createValueData(type, orderNumber, buffer);
        return vdDataWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueDataWrapper readValueData(int type, int orderNumber, File file, SpoolConfig spoolConfig) throws IOException {
        long fileSize;
        ValueDataWrapper vdDataWrapper = new ValueDataWrapper();
        vdDataWrapper.size = fileSize = file.length();
        if (fileSize > (long)spoolConfig.maxBufferSize) {
            vdDataWrapper.value = new FilePersistedValueData(orderNumber, file, spoolConfig);
        } else {
            try (FileInputStream is = new FileInputStream(file);){
                int read;
                byte[] data = new byte[(int)fileSize];
                byte[] buff = new byte[32768L > fileSize ? 32768 : (int)fileSize];
                int rpos = 0;
                while ((read = is.read(buff)) >= 0) {
                    System.arraycopy(buff, 0, data, rpos, read);
                    rpos += read;
                }
                vdDataWrapper.value = ValueDataUtil.createValueData(type, orderNumber, data);
            }
        }
        return vdDataWrapper;
    }

    public static PersistedValueData createValueData(int type, int orderNumber, byte[] data) throws IOException {
        switch (type) {
            case 0: 
            case 2: {
                return new ByteArrayPersistedValueData(orderNumber, data);
            }
            case 6: {
                return new BooleanPersistedValueData(orderNumber, Boolean.valueOf(ValueDataUtil.getString(data)));
            }
            case 5: {
                try {
                    return new CalendarPersistedValueData(orderNumber, JCRDateFormat.parse(ValueDataUtil.getString(data)));
                }
                catch (ValueFormatException e) {
                    throw new IOException("Can't create Calendar value", e);
                }
            }
            case 4: {
                return new DoublePersistedValueData(orderNumber, Double.valueOf(ValueDataUtil.getString(data)));
            }
            case 3: {
                return new LongPersistedValueData(orderNumber, Long.valueOf(ValueDataUtil.getString(data)));
            }
            case 7: {
                try {
                    return new NamePersistedValueData(orderNumber, InternalQName.parse(ValueDataUtil.getString(data)));
                }
                catch (IllegalNameException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
            case 8: {
                try {
                    return new PathPersistedValueData(orderNumber, QPath.parse(ValueDataUtil.getString(data)));
                }
                catch (IllegalPathException e) {
                    throw new IOException(e.getMessage(), (Throwable)((Object)e));
                }
            }
            case 9: {
                return new ReferencePersistedValueData(orderNumber, new Identifier(data));
            }
            case 1: {
                return new StringPersistedValueData(orderNumber, ValueDataUtil.getString(data));
            }
            case 100: {
                return new PermissionPersistedValueData(orderNumber, AccessControlEntry.parse(ValueDataUtil.getString(data)));
            }
        }
        throw new IllegalStateException("Unknown property type " + type);
    }

    public static TransientValueData createTransientCopy(ValueData valueData) throws IOException {
        return ValueDataUtil.createTransientCopy(valueData, 0);
    }

    public static TransientValueData createTransientCopy(ValueData valueData, int orderNumber) throws IOException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.createTransientCopy(((TransientValueData)valueData).delegate, orderNumber);
        }
        if (valueData instanceof AbstractValueData) {
            return ((AbstractValueData)valueData).createTransientCopy(orderNumber);
        }
        return new TransientValueData(orderNumber, valueData.getAsByteArray());
    }

    public static Long getLong(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getLong(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getLong();
    }

    public static Double getDouble(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getDouble(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getDouble();
    }

    public static Calendar getDate(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getDate(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getDate();
    }

    public static Boolean getBoolean(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getBoolean(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getBoolean();
    }

    public static String getString(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getString(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getString();
    }

    public static InternalQName getName(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getName(((TransientValueData)valueData).delegate);
        }
        try {
            return ((AbstractValueData)valueData).getName();
        }
        catch (IllegalNameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public static QPath getPath(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getPath(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getPath();
    }

    public static String getReference(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getReference(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getReference();
    }

    public static AccessControlEntry getPermission(ValueData valueData) throws RepositoryException {
        if (valueData instanceof TransientValueData) {
            return ValueDataUtil.getPermission(((TransientValueData)valueData).delegate);
        }
        return ((AbstractValueData)valueData).getPermission();
    }

    private static String getString(byte[] data) throws UnsupportedEncodingException {
        return new String(data, "UTF-8");
    }

    public static class ValueDataWrapper {
        public long size;
        public PersistedValueData value;

        private ValueDataWrapper() {
        }
    }
}

