/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class FileValueStorage
extends ValueStoragePlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.FileValueStorage");
    public static final String PATH = "path";
    public static final String TEMP_DIR_NAME = "temp";
    protected File rootDir;
    protected FileCleaner cleaner;
    protected ValueDataResourceHolder resources;

    public FileValueStorage(FileCleaner fileCleaner) {
        this.cleaner = fileCleaner;
    }

    @Override
    public void init(Properties props, ValueDataResourceHolder resources) throws IOException, RepositoryConfigurationException {
        this.resources = resources;
        this.prepareRootDir(props.getProperty(PATH));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void prepareRootDir(String rootDirPath) throws IOException, RepositoryConfigurationException {
        this.rootDir = new File(rootDirPath);
        if (!this.rootDir.exists()) {
            if (this.rootDir.mkdirs()) {
                LOG.info((Object)("Value storage directory created: " + this.rootDir.getAbsolutePath()));
                File tempDir = new File(this.rootDir, TEMP_DIR_NAME);
                tempDir.mkdirs();
                if (!tempDir.exists() || !tempDir.isDirectory()) throw new RepositoryConfigurationException("Cannot create temp directory under External Value Storage.");
                for (File tmpf : tempDir.listFiles()) {
                    if (tmpf.delete()) continue;
                    LOG.warn((Object)("Storage temporary directory contains un-deletable file " + tmpf.getAbsolutePath() + ". It's recommended to leave this directory for JCR External Values Storage private use."));
                }
                return;
            } else {
                LOG.warn((Object)("Directory IS NOT created: " + this.rootDir.getAbsolutePath()));
            }
            return;
        } else {
            if (this.rootDir.isDirectory()) return;
            throw new RepositoryConfigurationException("File exists but is not a directory " + rootDirPath);
        }
    }
}

