/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class SetCurrentIdentityFilter
extends AbstractFilter {
    private boolean restoreIdentity;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.SetCurrentIdentityFilter");

    protected void afterInit(FilterConfig config) throws ServletException {
        super.afterInit(config);
        this.restoreIdentity = Boolean.parseBoolean(config.getInitParameter("restoreIdentity"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExoContainer container = this.getContainer();
        try {
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            ConversationState state = this.getCurrentState(container, httpRequest);
            ConversationState.setCurrent(state);
            chain.doFilter(request, response);
        }
        finally {
            try {
                ConversationState.setCurrent(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
            try {
                ExoContainerContext.setCurrentContainer(null);
            }
            catch (Exception e) {
                LOG.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
            }
        }
    }

    private ConversationState getCurrentState(ExoContainer container, HttpServletRequest httpRequest) {
        ConversationRegistry conversationRegistry = (ConversationRegistry)container.getComponentInstanceOfType(ConversationRegistry.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)container.getComponentInstanceOfType(IdentityRegistry.class);
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null) {
            HttpSession httpSession = httpRequest.getSession();
            HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Looking for Conversation State " + httpSession.getId()));
            }
            if ((state = conversationRegistry.getState(stateKey)) == null) {
                Identity identity;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Conversation State not found, try create new one.");
                }
                if ((identity = identityRegistry.getIdentity(userId)) != null) {
                    state = new ConversationState(identity);
                    state.setAttribute("subject", identity.getSubject());
                } else if (this.restoreIdentity) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Not found identity for " + userId + " try to restore it. "));
                    }
                    Authenticator authenticator = (Authenticator)container.getComponentInstanceOfType(Authenticator.class);
                    try {
                        identity = authenticator.createIdentity(userId);
                        identityRegistry.register(identity);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable restore identity. " + e.getMessage()), (Throwable)e);
                    }
                    if (identity != null) {
                        state = new ConversationState(identity);
                    }
                } else {
                    LOG.error((Object)("Not found identity in IdentityRegistry for user " + userId + ", check Login Module."));
                }
                if (state != null) {
                    conversationRegistry.register(stateKey, state);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Register Conversation state " + httpSession.getId()));
                    }
                }
            } else if (!userId.equals(state.getIdentity().getUserId())) {
                state = new ConversationState(new Identity(IdentityConstants.ANONIM));
                LOG.error((Object)("The current conversation state with the session ID " + httpSession.getId() + " does not belong to the user " + userId + ", this user should re-login again !"));
            }
        } else {
            state = new ConversationState(new Identity(IdentityConstants.ANONIM));
        }
        return state;
    }

    public void destroy() {
    }
}

