/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.plugin.doc.UIDocActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.UIDocumentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivitySelector.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectedFileActionListener.class})})
public class UIDocActivitySelector
extends UIContainer
implements UIPopupComponent {
    protected static final String UIDOCUMENTSELECTOR = "UIDocumentSelector";
    protected static final String CANCEL = "Cancel";
    public static final String SELECTEDFILE = "SelectedFile";
    private static final Log LOG = ExoLogger.getLogger(UIDocActivitySelector.class);

    public UIDocActivitySelector() {
        try {
            this.addChild(UIDocumentSelector.class, null, UIDOCUMENTSELECTOR);
        }
        catch (Exception e) {
            LOG.error((Object)"An exception happens when init UIDocActivitySelector", (Throwable)e);
        }
    }

    public void activate() {
    }

    public void deActivate() {
        UIPopupWindow popup = (UIPopupWindow)this.getParent();
        popup.setUIComponent(null);
        popup.setShow(false);
        popup.setRendered(false);
        ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax(popup.getParent());
    }

    public static class SelectedFileActionListener
    extends EventListener<UIDocActivitySelector> {
        public void execute(Event<UIDocActivitySelector> event) throws Exception {
            UIDocActivitySelector uiDocActivitySelector = (UIDocActivitySelector)((Object)event.getSource());
            UIPortletApplication uiApp = (UIPortletApplication)uiDocActivitySelector.getAncestorOfType(UIPortletApplication.class);
            UIDocumentSelector documentSelector = (UIDocumentSelector)uiDocActivitySelector.getChild(UIDocumentSelector.class);
            String rawPath = documentSelector.getSeletedFile();
            if (rawPath == null || rawPath.trim().length() <= 0) {
                uiApp.addMessage(new ApplicationMessage("UIDocActivitySelector.msg.not-a-file", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
                return;
            }
            UIComposer uiComposer = (UIComposer)uiApp.findFirstComponentOfType(UIComposer.class);
            UIDocActivityComposer uiDocActivityComposer = (UIDocActivityComposer)uiComposer.findFirstComponentOfType(UIDocActivityComposer.class);
            uiDocActivityComposer.doSelect(documentSelector.getSeletedFileType(), rawPath);
            uiDocActivitySelector.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDocActivityComposer.getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIDocActivitySelector> {
        public void execute(Event<UIDocActivitySelector> event) throws Exception {
            UIDocActivitySelector uiDocActivitySelector = (UIDocActivitySelector)((Object)event.getSource());
            uiDocActivitySelector.deActivate();
        }
    }
}

