/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.pointers;

import org.apache.poi.hdgf.pointers.Pointer;
import org.apache.poi.hdgf.pointers.PointerV6;
import org.apache.poi.util.LittleEndian;

public final class PointerFactory {
    private int version;

    public PointerFactory(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Pointer createPointer(byte[] data, int offset) {
        if (this.version >= 6) {
            PointerV6 p = new PointerV6();
            p.type = LittleEndian.getInt((byte[])data, (int)(offset + 0));
            p.address = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 4));
            p.offset = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 8));
            p.length = (int)LittleEndian.getUInt((byte[])data, (int)(offset + 12));
            p.format = LittleEndian.getShort((byte[])data, (int)(offset + 16));
            return p;
        }
        if (this.version == 5) {
            throw new RuntimeException("TODO Support v5 Pointers");
        }
        throw new IllegalArgumentException("Visio files with versions below 5 are not supported, yours was " + this.version);
    }
}

