/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.comparator.PropertyValueComparator;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/favorite/")
public class FavoriteRESTService
implements ResourceContainer {
    private final FavoriteService favoriteService;
    private ManageDriveService manageDriveService;
    private static final String DATE_MODIFIED = "exo:dateModified";
    private static final String TITLE = "exo:title";
    private static final int NO_PER_PAGE = 10;
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final Log LOG = ExoLogger.getLogger((String)FavoriteRESTService.class.getName());

    public FavoriteRESTService(FavoriteService favoriteService, ManageDriveService manageDriveService) {
        this.favoriteService = favoriteService;
        this.manageDriveService = manageDriveService;
    }

    @GET
    @Path(value="/all/{repoName}/{workspaceName}/{userName}")
    public Response getFavoriteByUser(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String workspaceName, @PathParam(value="userName") String userName, @QueryParam(value="showItems") String showItems) throws Exception {
        ArrayList<FavoriteNode> listFavorites = new ArrayList<FavoriteNode>();
        List listDrive = this.manageDriveService.getAllDrives();
        if (StringUtils.isEmpty((String)showItems)) {
            showItems = String.valueOf(10);
        }
        try {
            List listNodes = this.favoriteService.getAllFavoriteNodesByUser(workspaceName, repoName, userName);
            Collections.sort(listNodes, new PropertyValueComparator(DATE_MODIFIED, "Descending"));
            for (Node favorite : listNodes) {
                FavoriteNode favoriteNode = new FavoriteNode();
                favoriteNode.setName(favorite.getName());
                favoriteNode.setTitle(this.getTitle(favorite));
                favoriteNode.setDateAddFavorite(this.getDateFormat(favorite.getProperty(DATE_MODIFIED).getDate()));
                favoriteNode.setDriveName(this.getDriveName(listDrive, favorite));
                favoriteNode.setPath(favorite.getPath());
                if (favoriteNode == null || listFavorites.size() >= Integer.valueOf(showItems)) continue;
                listFavorites.add(favoriteNode);
            }
        }
        catch (ItemNotFoundException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return Response.serverError().build();
        }
        catch (RepositoryException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return Response.serverError().build();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e);
            }
            return Response.serverError().build();
        }
        ListResultNode listResultNode = new ListResultNode();
        listResultNode.setListFavorite(listFavorites);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)listResultNode, (MediaType)new MediaType("application", "json")).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private String getTitle(Node node) throws Exception {
        if (node.hasProperty(TITLE)) {
            return node.getProperty(TITLE).getString();
        }
        return node.getName();
    }

    private String getDateFormat(Calendar date) {
        return String.valueOf(date.getTimeInMillis());
    }

    private String getDriveName(List<DriveData> listDrive, Node node) throws RepositoryException {
        String driveName = "";
        for (DriveData drive : listDrive) {
            if (!node.getSession().getWorkspace().getName().equals(drive.getWorkspace()) || !node.getPath().contains(drive.getHomePath()) || !drive.getHomePath().equals("/")) continue;
            driveName = drive.getName();
            break;
        }
        return driveName;
    }

    public class FavoriteNode {
        private String name;
        private String nodePath;
        private String dateAddFavorite;
        private String driveName;
        private String title;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPath(String path) {
            this.nodePath = path;
        }

        public String getPath() {
            return this.nodePath;
        }

        public void setDateAddFavorite(String dateAddFavorite) {
            this.dateAddFavorite = dateAddFavorite;
        }

        public String getDateAddFavorite() {
            return this.dateAddFavorite;
        }

        public void setDriveName(String driveName) {
            this.driveName = driveName;
        }

        public String getDriveName() {
            return this.driveName;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public class ListResultNode {
        private List<? extends FavoriteNode> listFavorite;

        public List<? extends FavoriteNode> getListFavorite() {
            return this.listFavorite;
        }

        public void setListFavorite(List<? extends FavoriteNode> listFavorite) {
            this.listFavorite = listFavorite;
        }
    }
}

