/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.documents;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.groovy.util.ListHashMap;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.connector.BaseConnector;

@Path(value="/document/")
public class DocumentConnector
extends BaseConnector
implements ResourceContainer {
    private DocumentService documentService;
    private DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");

    public DocumentConnector(DocumentService documentService) {
        this.documentService = documentService;
    }

    @GET
    @Path(value="/docOpenUri")
    public Response getDocOpenUri(@QueryParam(value="nodePath") String nodePath) {
        try {
            ListHashMap uris = new ListHashMap();
            if (nodePath.startsWith("/")) {
                nodePath = nodePath.substring(1);
            }
            if (nodePath.endsWith("/")) {
                nodePath = nodePath.substring(0, nodePath.length() - 1);
            }
            String path = "";
            for (String nodeName : nodePath.split("/")) {
                path = path + "/" + nodeName;
                try {
                    DriveData drive = this.documentService.getDriveOfNode(path);
                    Node docNode = NodeLocation.getNodeByExpression((String)(WCMCoreUtils.getRepository().getConfiguration().getName() + ":" + drive.getWorkspace() + ":" + path));
                    String nodeTitle = Utils.getTitle((Node)docNode);
                    String docLink = this.documentService.getLinkInDocumentsApp(path);
                    ArrayList<String> titleAndLink = new ArrayList<String>();
                    titleAndLink.add(nodeTitle);
                    titleAndLink.add(docLink);
                    uris.put(path, titleAndLink);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return Response.ok((Object)uris, (MediaType)MediaType.APPLICATION_JSON_TYPE).header("Last-Modified", (Object)this.dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        return null;
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }
}

