/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.exoplatform.social.common.service.ExecutorServiceManager;
import org.exoplatform.social.common.service.thread.DefaultThreadPoolFactory;
import org.exoplatform.social.common.service.thread.SocialThreadFactory;
import org.exoplatform.social.common.service.thread.ThreadPoolConfig;
import org.exoplatform.social.common.service.thread.ThreadPoolFactory;

public class ExecutorServiceManagerImpl
implements ExecutorServiceManager {
    private ThreadPoolFactory threadPoolFactory = new DefaultThreadPoolFactory();
    private String threadNamePattern;
    private final Map<String, ThreadPoolConfig> threadPoolProfiles = new HashMap<String, ThreadPoolConfig>();
    private ThreadPoolConfig defaultConfig = new ThreadPoolConfig();

    public ExecutorServiceManagerImpl() {
        this.defaultConfig.setDefaultProfile(true);
        this.defaultConfig.setPoolSize(10);
        this.defaultConfig.setMaxPoolSize(20);
        this.defaultConfig.setKeepAliveTime(10L);
        this.defaultConfig.setTimeUnit(TimeUnit.SECONDS);
        this.defaultConfig.setMaxQueueSize(1000);
        this.defaultConfig.setPriority(5);
    }

    @Override
    public void setThreadNamePattern(String pattern) throws IllegalArgumentException {
    }

    @Override
    public String getThreadNamePattern() {
        return null;
    }

    @Override
    public Thread newThread(String name, Runnable runnable) {
        return null;
    }

    @Override
    public ExecutorService newDefaultThreadPool(String name) {
        return this.newThreadPool(name, this.defaultConfig);
    }

    @Override
    public ThreadPoolConfig getThreadPoolConfig(String id) {
        return this.threadPoolProfiles.get(id);
    }

    @Override
    public ExecutorService newThreadPool(String name, ThreadPoolConfig config) {
        ThreadFactory threadFactory = this.createThreadFactory(name, true, config.getPriority());
        ExecutorService executorService = this.threadPoolFactory.newThreadPool(config, threadFactory);
        return executorService;
    }

    private ThreadFactory createThreadFactory(String name, boolean isDaemon, int priority) {
        return new SocialThreadFactory(this.threadNamePattern, name, isDaemon, priority);
    }
}

