/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.serializer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.xml.XMLConfiguration;
import org.xwiki.filter.xml.internal.XMLUtils;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.xml.stax.StAXUtils;

@Component
@Singleton
public class DefaultXMLSerializer
implements InvocationHandler {
    private static final Pattern VALID_ELEMENTNAME = Pattern.compile("[A-Za-z][A-Za-z0-9:_.-]*");
    private final XMLStreamWriter xmlStreamWriter;
    private final ParameterManager parameterManager;
    private final FilterDescriptor descriptor;
    private final ConverterManager converter;
    private final XMLConfiguration configuration;

    public DefaultXMLSerializer(Result result, ParameterManager parameterManager, FilterDescriptor descriptor, ConverterManager converter, XMLConfiguration configuration) throws XMLStreamException, FactoryConfigurationError {
        this.parameterManager = parameterManager;
        this.descriptor = descriptor;
        this.converter = converter;
        this.configuration = configuration != null ? configuration : new XMLConfiguration();
        this.xmlStreamWriter = StAXUtils.getXMLStreamWriter((Result)result);
    }

    private boolean isValidBlockElementName(String blockName) {
        return VALID_ELEMENTNAME.matcher(blockName).matches() && !this.configuration.getElementParameters().equals(blockName);
    }

    private boolean isValidParameterElementName(String parameterName) {
        return VALID_ELEMENTNAME.matcher(parameterName).matches() && !XMLUtils.INDEX_PATTERN.matcher(parameterName).matches();
    }

    private boolean isValidParameterAttributeName(String parameterName) {
        return this.isValidParameterElementName(parameterName) && !this.configuration.getAttributeParameterName().equals(parameterName);
    }

    private String getBlockName(String eventName, String prefix) {
        String blockName = eventName.substring(prefix.length());
        blockName = Character.toLowerCase(blockName.charAt(0)) + blockName.substring(1);
        return blockName;
    }

    private void writeInlineParameters(List<Object> parameters, FilterElementDescriptor element) throws XMLStreamException {
        for (int i = 0; i < parameters.size(); ++i) {
            FilterElementParameterDescriptor filterParameter;
            Object parameterValue = parameters.get(i);
            if (parameterValue == null || ObjectUtils.equals((Object)(filterParameter = element.getParameters()[i]).getDefaultValue(), (Object)parameterValue)) continue;
            Class typeClass = ReflectionUtils.getTypeClass((Type)filterParameter.getType());
            String attributeName = filterParameter.getName() != null ? (this.isValidParameterAttributeName(filterParameter.getName()) ? filterParameter.getName() : null) : "_" + filterParameter.getIndex();
            if (attributeName == null) continue;
            if (parameterValue instanceof String) {
                this.xmlStreamWriter.writeAttribute(attributeName, (String)parameterValue);
                parameters.set(filterParameter.getIndex(), null);
                continue;
            }
            if (XMLUtils.isSimpleType(typeClass)) {
                this.xmlStreamWriter.writeAttribute(attributeName, (String)this.converter.convert(String.class, parameterValue));
                parameters.set(filterParameter.getIndex(), null);
                continue;
            }
            if (!ObjectUtils.equals((Object)XMLUtils.emptyValue(typeClass), (Object)parameterValue)) continue;
            this.xmlStreamWriter.writeAttribute(attributeName, "");
            parameters.set(filterParameter.getIndex(), null);
        }
    }

    private void writeStartAttributes(String blockName, List<Object> parameters) throws XMLStreamException {
        if (!this.isValidBlockElementName(blockName)) {
            this.xmlStreamWriter.writeAttribute(this.configuration.getAttributeBlockName(), blockName);
        }
        if (parameters != null) {
            FilterElementDescriptor element = this.descriptor.getElement(blockName);
            this.writeInlineParameters(parameters, element);
        }
    }

    private void removeDefaultParameters(List<Object> parameters, FilterElementDescriptor descriptor) {
        if (parameters != null) {
            for (int i = 0; i < parameters.size(); ++i) {
                Object value = parameters.get(i);
                if (this.shouldWriteParameter(value, descriptor.getParameters()[i])) continue;
                parameters.set(i, null);
            }
        }
    }

    private void beginEvent(String eventName, Object[] parameters) throws XMLStreamException {
        String blockName = this.getBlockName(eventName, "begin");
        FilterElementDescriptor element = this.descriptor.getElement(blockName);
        List<Object> elementParameters = parameters != null ? Arrays.asList(parameters) : null;
        this.removeDefaultParameters(elementParameters, element);
        String elementName = this.isValidBlockElementName(blockName) ? blockName : this.configuration.getElementBlock();
        this.xmlStreamWriter.writeStartElement(elementName);
        this.writeStartAttributes(blockName, elementParameters);
        this.writeParameters(elementParameters, element);
    }

    private void endEvent() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
    }

    private void onEvent(String eventName, Object[] parameters) throws XMLStreamException {
        String blockName = this.getBlockName(eventName, "on");
        FilterElementDescriptor element = this.descriptor.getElement(blockName);
        List<Object> elementParameters = parameters != null ? Arrays.asList(parameters) : null;
        this.removeDefaultParameters(elementParameters, element);
        String elementName = this.isValidBlockElementName(blockName) ? blockName : this.configuration.getElementBlock();
        this.xmlStreamWriter.writeStartElement(elementName);
        if (elementParameters != null && elementParameters.size() > 1) {
            this.writeStartAttributes(blockName, Arrays.asList(parameters));
        }
        if (parameters != null && parameters.length == 1 && XMLUtils.isSimpleType(element.getParameters()[0].getType())) {
            Object parameter = parameters[0];
            if (parameter != null && !ObjectUtils.equals((Object)element.getParameters()[0].getDefaultValue(), (Object)parameter)) {
                String value = parameter.toString();
                this.xmlStreamWriter.writeCharacters(value);
            }
        } else {
            this.writeParameters(elementParameters, element);
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private boolean shouldWriteParameter(Object value, FilterElementParameterDescriptor<?> filterParameter) {
        boolean write;
        if (value != null && !ObjectUtils.equals((Object)filterParameter.getDefaultValue(), (Object)value)) {
            write = true;
            Type type = filterParameter.getType();
            if (type instanceof Class) {
                Class typeClass = (Class)type;
                try {
                    if (typeClass.isPrimitive()) {
                        write = !XMLUtils.emptyValue(typeClass).equals(value);
                    }
                }
                catch (Exception e) {}
            }
        } else {
            write = false;
        }
        return write;
    }

    private void writeParameters(List<Object> parameters, FilterElementDescriptor descriptor) throws XMLStreamException {
        if (parameters != null && !parameters.isEmpty()) {
            boolean writeContainer = false;
            for (Object parameter : parameters) {
                if (parameter == null) continue;
                writeContainer = true;
                break;
            }
            if (writeContainer) {
                this.xmlStreamWriter.writeStartElement(this.configuration.getElementParameters());
            }
            for (int i = 0; i < parameters.size(); ++i) {
                String elementName;
                FilterElementParameterDescriptor filterParameter;
                Object parameterValue = parameters.get(i);
                if (!this.shouldWriteParameter(parameterValue, filterParameter = descriptor.getParameters()[i])) continue;
                String attributeName = null;
                String attributeValue = null;
                if (filterParameter.getName() != null) {
                    if (this.isValidParameterElementName(filterParameter.getName())) {
                        elementName = filterParameter.getName();
                    } else {
                        elementName = "_" + filterParameter.getIndex();
                        attributeName = this.configuration.getAttributeParameterName();
                        attributeValue = filterParameter.getName();
                    }
                } else {
                    elementName = "_" + filterParameter.getIndex();
                }
                this.xmlStreamWriter.writeStartElement(elementName);
                if (attributeName != null) {
                    this.xmlStreamWriter.writeAttribute(attributeName, attributeValue);
                }
                if (descriptor.getParameters()[i].getType() == Object.class && parameterValue.getClass() != String.class) {
                    this.xmlStreamWriter.writeAttribute(this.configuration.getAttributeParameterType(), parameterValue.getClass().getCanonicalName());
                }
                this.parameterManager.serialize(descriptor.getParameters()[i].getType(), parameterValue, this.xmlStreamWriter);
                this.xmlStreamWriter.writeEndElement();
            }
            if (writeContainer) {
                this.xmlStreamWriter.writeEndElement();
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.getName().startsWith("begin")) {
            this.beginEvent(method.getName(), args);
        } else if (method.getName().startsWith("end")) {
            this.endEvent();
        } else if (method.getName().startsWith("on")) {
            this.onEvent(method.getName(), args);
        } else {
            throw new NoSuchMethodException(method.toGenericString());
        }
        return result;
    }
}

